/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.redshift.model.HsmClientCertificate;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.transform.TagUnmarshaller;

public class HsmClientCertificateUnmarshaller
implements Unmarshaller<HsmClientCertificate, StaxUnmarshallerContext> {
    private static HsmClientCertificateUnmarshaller INSTANCE;

    public HsmClientCertificate unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        HsmClientCertificate.Builder hsmClientCertificate = HsmClientCertificate.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("HsmClientCertificateIdentifier", targetDepth)) {
                    hsmClientCertificate.hsmClientCertificateIdentifier(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HsmClientCertificatePublicKey", targetDepth)) {
                    hsmClientCertificate.hsmClientCertificatePublicKey(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Tags", targetDepth)) {
                    hsmClientCertificate.tags(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("Tags/Tag", targetDepth)) continue;
                hsmClientCertificate.tags(TagUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (HsmClientCertificate)hsmClientCertificate.build();
    }

    public static HsmClientCertificateUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HsmClientCertificateUnmarshaller();
        }
        return INSTANCE;
    }
}

