/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.EnableSnapshotCopyRequest;
import software.amazon.awssdk.util.StringUtils;

public class EnableSnapshotCopyRequestMarshaller
implements Marshaller<Request<EnableSnapshotCopyRequest>, EnableSnapshotCopyRequest> {
    public Request<EnableSnapshotCopyRequest> marshall(EnableSnapshotCopyRequest enableSnapshotCopyRequest) {
        if (enableSnapshotCopyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)enableSnapshotCopyRequest, "RedshiftClient");
        request.addParameter("Action", "EnableSnapshotCopy");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (enableSnapshotCopyRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)enableSnapshotCopyRequest.clusterIdentifier()));
        }
        if (enableSnapshotCopyRequest.destinationRegion() != null) {
            request.addParameter("DestinationRegion", StringUtils.fromString((String)enableSnapshotCopyRequest.destinationRegion()));
        }
        if (enableSnapshotCopyRequest.retentionPeriod() != null) {
            request.addParameter("RetentionPeriod", StringUtils.fromInteger((Integer)enableSnapshotCopyRequest.retentionPeriod()));
        }
        if (enableSnapshotCopyRequest.snapshotCopyGrantName() != null) {
            request.addParameter("SnapshotCopyGrantName", StringUtils.fromString((String)enableSnapshotCopyRequest.snapshotCopyGrantName()));
        }
        return request;
    }
}

