/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroup;
import software.amazon.awssdk.services.redshift.model.EC2SecurityGroup;
import software.amazon.awssdk.services.redshift.model.IPRange;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.transform.EC2SecurityGroupUnmarshaller;
import software.amazon.awssdk.services.redshift.transform.IPRangeUnmarshaller;
import software.amazon.awssdk.services.redshift.transform.TagUnmarshaller;

public class ClusterSecurityGroupUnmarshaller
implements Unmarshaller<ClusterSecurityGroup, StaxUnmarshallerContext> {
    private static ClusterSecurityGroupUnmarshaller INSTANCE;

    public ClusterSecurityGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ClusterSecurityGroup.Builder clusterSecurityGroup = ClusterSecurityGroup.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ClusterSecurityGroupName", targetDepth)) {
                    clusterSecurityGroup.clusterSecurityGroupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Description", targetDepth)) {
                    clusterSecurityGroup.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EC2SecurityGroups", targetDepth)) {
                    clusterSecurityGroup.ec2SecurityGroups(new ArrayList<EC2SecurityGroup>());
                    continue;
                }
                if (context.testExpression("EC2SecurityGroups/EC2SecurityGroup", targetDepth)) {
                    clusterSecurityGroup.ec2SecurityGroups(EC2SecurityGroupUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IPRanges", targetDepth)) {
                    clusterSecurityGroup.ipRanges(new ArrayList<IPRange>());
                    continue;
                }
                if (context.testExpression("IPRanges/IPRange", targetDepth)) {
                    clusterSecurityGroup.ipRanges(IPRangeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Tags", targetDepth)) {
                    clusterSecurityGroup.tags(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("Tags/Tag", targetDepth)) continue;
                clusterSecurityGroup.tags(TagUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ClusterSecurityGroup)clusterSecurityGroup.build();
    }

    public static ClusterSecurityGroupUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ClusterSecurityGroupUnmarshaller();
        }
        return INSTANCE;
    }
}

