/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.redshift.model.Parameter;
import software.amazon.awssdk.services.redshift.model.ParametersListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DefaultClusterParameters
implements ToCopyableBuilder<Builder, DefaultClusterParameters> {
    private final String parameterGroupFamily;
    private final String marker;
    private final List<Parameter> parameters;

    private DefaultClusterParameters(BuilderImpl builder) {
        this.parameterGroupFamily = builder.parameterGroupFamily;
        this.marker = builder.marker;
        this.parameters = builder.parameters;
    }

    public String parameterGroupFamily() {
        return this.parameterGroupFamily;
    }

    public String marker() {
        return this.marker;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.parameterGroupFamily() == null ? 0 : this.parameterGroupFamily().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultClusterParameters)) {
            return false;
        }
        DefaultClusterParameters other = (DefaultClusterParameters)obj;
        if (other.parameterGroupFamily() == null ^ this.parameterGroupFamily() == null) {
            return false;
        }
        if (other.parameterGroupFamily() != null && !other.parameterGroupFamily().equals(this.parameterGroupFamily())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        return other.parameters() == null || other.parameters().equals(this.parameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.parameterGroupFamily() != null) {
            sb.append("ParameterGroupFamily: ").append(this.parameterGroupFamily()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String parameterGroupFamily;
        private String marker;
        private List<Parameter> parameters = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultClusterParameters model) {
            this.setParameterGroupFamily(model.parameterGroupFamily);
            this.setMarker(model.marker);
            this.setParameters(model.parameters);
        }

        public final String getParameterGroupFamily() {
            return this.parameterGroupFamily;
        }

        @Override
        public final Builder parameterGroupFamily(String parameterGroupFamily) {
            this.parameterGroupFamily = parameterGroupFamily;
            return this;
        }

        public final void setParameterGroupFamily(String parameterGroupFamily) {
            this.parameterGroupFamily = parameterGroupFamily;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<Parameter> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            if (this.parameters == null) {
                this.parameters = new SdkInternalList(parameters.length);
            }
            for (Parameter e : parameters) {
                this.parameters.add(e);
            }
            return this;
        }

        public final void setParameters(Collection<Parameter> parameters) {
            this.parameters = ParametersListCopier.copy(parameters);
        }

        @SafeVarargs
        public final void setParameters(Parameter ... parameters) {
            if (this.parameters == null) {
                this.parameters = new SdkInternalList(parameters.length);
            }
            for (Parameter e : parameters) {
                this.parameters.add(e);
            }
        }

        public DefaultClusterParameters build() {
            return new DefaultClusterParameters(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DefaultClusterParameters> {
        public Builder parameterGroupFamily(String var1);

        public Builder marker(String var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);
    }
}

