/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rdsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rdsdata.model.DecimalReturnType;
import software.amazon.awssdk.services.rdsdata.model.LongReturnType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResultSetOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResultSetOptions> {
    private static final SdkField<String> DECIMAL_RETURN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("decimalReturnType").getter(ResultSetOptions.getter(ResultSetOptions::decimalReturnTypeAsString)).setter(ResultSetOptions.setter(Builder::decimalReturnType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decimalReturnType").build()}).build();
    private static final SdkField<String> LONG_RETURN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("longReturnType").getter(ResultSetOptions.getter(ResultSetOptions::longReturnTypeAsString)).setter(ResultSetOptions.setter(Builder::longReturnType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("longReturnType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DECIMAL_RETURN_TYPE_FIELD, LONG_RETURN_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResultSetOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String decimalReturnType;
    private final String longReturnType;

    private ResultSetOptions(BuilderImpl builder) {
        this.decimalReturnType = builder.decimalReturnType;
        this.longReturnType = builder.longReturnType;
    }

    public final DecimalReturnType decimalReturnType() {
        return DecimalReturnType.fromValue(this.decimalReturnType);
    }

    public final String decimalReturnTypeAsString() {
        return this.decimalReturnType;
    }

    public final LongReturnType longReturnType() {
        return LongReturnType.fromValue(this.longReturnType);
    }

    public final String longReturnTypeAsString() {
        return this.longReturnType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.decimalReturnTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.longReturnTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultSetOptions)) {
            return false;
        }
        ResultSetOptions other = (ResultSetOptions)obj;
        return Objects.equals(this.decimalReturnTypeAsString(), other.decimalReturnTypeAsString()) && Objects.equals(this.longReturnTypeAsString(), other.longReturnTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ResultSetOptions").add("DecimalReturnType", (Object)this.decimalReturnTypeAsString()).add("LongReturnType", (Object)this.longReturnTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "decimalReturnType": {
                return Optional.ofNullable(clazz.cast(this.decimalReturnTypeAsString()));
            }
            case "longReturnType": {
                return Optional.ofNullable(clazz.cast(this.longReturnTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("decimalReturnType", DECIMAL_RETURN_TYPE_FIELD);
        map.put("longReturnType", LONG_RETURN_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResultSetOptions, T> g) {
        return obj -> g.apply((ResultSetOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String decimalReturnType;
        private String longReturnType;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultSetOptions model) {
            this.decimalReturnType(model.decimalReturnType);
            this.longReturnType(model.longReturnType);
        }

        public final String getDecimalReturnType() {
            return this.decimalReturnType;
        }

        public final void setDecimalReturnType(String decimalReturnType) {
            this.decimalReturnType = decimalReturnType;
        }

        @Override
        public final Builder decimalReturnType(String decimalReturnType) {
            this.decimalReturnType = decimalReturnType;
            return this;
        }

        @Override
        public final Builder decimalReturnType(DecimalReturnType decimalReturnType) {
            this.decimalReturnType(decimalReturnType == null ? null : decimalReturnType.toString());
            return this;
        }

        public final String getLongReturnType() {
            return this.longReturnType;
        }

        public final void setLongReturnType(String longReturnType) {
            this.longReturnType = longReturnType;
        }

        @Override
        public final Builder longReturnType(String longReturnType) {
            this.longReturnType = longReturnType;
            return this;
        }

        @Override
        public final Builder longReturnType(LongReturnType longReturnType) {
            this.longReturnType(longReturnType == null ? null : longReturnType.toString());
            return this;
        }

        public ResultSetOptions build() {
            return new ResultSetOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResultSetOptions> {
        public Builder decimalReturnType(String var1);

        public Builder decimalReturnType(DecimalReturnType var1);

        public Builder longReturnType(String var1);

        public Builder longReturnType(LongReturnType var1);
    }
}

