/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.services.rds.model.ReservedDBInstancesOffering;
import software.amazon.awssdk.services.rds.model.ReservedDBInstancesOfferingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReservedDbInstancesOfferingsResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeReservedDbInstancesOfferingsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservedDbInstancesOfferingsResponse.getter(DescribeReservedDbInstancesOfferingsResponse::marker)).setter(DescribeReservedDbInstancesOfferingsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<ReservedDBInstancesOffering>> RESERVED_DB_INSTANCES_OFFERINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeReservedDbInstancesOfferingsResponse.getter(DescribeReservedDbInstancesOfferingsResponse::reservedDBInstancesOfferings)).setter(DescribeReservedDbInstancesOfferingsResponse.setter(Builder::reservedDBInstancesOfferings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedDBInstancesOfferings").build(), ListTrait.builder().memberLocationName("ReservedDBInstancesOffering").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservedDBInstancesOffering::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedDBInstancesOffering").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, RESERVED_DB_INSTANCES_OFFERINGS_FIELD));
    private final String marker;
    private final List<ReservedDBInstancesOffering> reservedDBInstancesOfferings;

    private DescribeReservedDbInstancesOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.reservedDBInstancesOfferings = builder.reservedDBInstancesOfferings;
    }

    public String marker() {
        return this.marker;
    }

    public List<ReservedDBInstancesOffering> reservedDBInstancesOfferings() {
        return this.reservedDBInstancesOfferings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedDBInstancesOfferings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedDbInstancesOfferingsResponse)) {
            return false;
        }
        DescribeReservedDbInstancesOfferingsResponse other = (DescribeReservedDbInstancesOfferingsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.reservedDBInstancesOfferings(), other.reservedDBInstancesOfferings());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReservedDbInstancesOfferingsResponse").add("Marker", (Object)this.marker()).add("ReservedDBInstancesOfferings", this.reservedDBInstancesOfferings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ReservedDBInstancesOfferings": {
                return Optional.ofNullable(clazz.cast(this.reservedDBInstancesOfferings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedDbInstancesOfferingsResponse, T> g) {
        return obj -> g.apply((DescribeReservedDbInstancesOfferingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ReservedDBInstancesOffering> reservedDBInstancesOfferings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedDbInstancesOfferingsResponse model) {
            super(model);
            this.marker(model.marker);
            this.reservedDBInstancesOfferings(model.reservedDBInstancesOfferings);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReservedDBInstancesOffering.Builder> getReservedDBInstancesOfferings() {
            return this.reservedDBInstancesOfferings != null ? (Collection)this.reservedDBInstancesOfferings.stream().map(ReservedDBInstancesOffering::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedDBInstancesOfferings(Collection<ReservedDBInstancesOffering> reservedDBInstancesOfferings) {
            this.reservedDBInstancesOfferings = ReservedDBInstancesOfferingListCopier.copy(reservedDBInstancesOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedDBInstancesOfferings(ReservedDBInstancesOffering ... reservedDBInstancesOfferings) {
            this.reservedDBInstancesOfferings(Arrays.asList(reservedDBInstancesOfferings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedDBInstancesOfferings(Consumer<ReservedDBInstancesOffering.Builder> ... reservedDBInstancesOfferings) {
            this.reservedDBInstancesOfferings(Stream.of(reservedDBInstancesOfferings).map(c -> (ReservedDBInstancesOffering)((ReservedDBInstancesOffering.Builder)ReservedDBInstancesOffering.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReservedDBInstancesOfferings(Collection<ReservedDBInstancesOffering.BuilderImpl> reservedDBInstancesOfferings) {
            this.reservedDBInstancesOfferings = ReservedDBInstancesOfferingListCopier.copyFromBuilder(reservedDBInstancesOfferings);
        }

        @Override
        public DescribeReservedDbInstancesOfferingsResponse build() {
            return new DescribeReservedDbInstancesOfferingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReservedDbInstancesOfferingsResponse> {
        public Builder marker(String var1);

        public Builder reservedDBInstancesOfferings(Collection<ReservedDBInstancesOffering> var1);

        public Builder reservedDBInstancesOfferings(ReservedDBInstancesOffering ... var1);

        public Builder reservedDBInstancesOfferings(Consumer<ReservedDBInstancesOffering.Builder> ... var1);
    }
}

