/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.RecommendedActionUpdate;
import software.amazon.awssdk.services.rds.model.RecommendedActionUpdateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyDbRecommendationRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, ModifyDbRecommendationRequest> {
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationId").getter(ModifyDbRecommendationRequest.getter(ModifyDbRecommendationRequest::recommendationId)).setter(ModifyDbRecommendationRequest.setter(Builder::recommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationId").build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Locale").getter(ModifyDbRecommendationRequest.getter(ModifyDbRecommendationRequest::locale)).setter(ModifyDbRecommendationRequest.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locale").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ModifyDbRecommendationRequest.getter(ModifyDbRecommendationRequest::status)).setter(ModifyDbRecommendationRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<RecommendedActionUpdate>> RECOMMENDED_ACTION_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecommendedActionUpdates").getter(ModifyDbRecommendationRequest.getter(ModifyDbRecommendationRequest::recommendedActionUpdates)).setter(ModifyDbRecommendationRequest.setter(Builder::recommendedActionUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendedActionUpdates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommendedActionUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_ID_FIELD, LOCALE_FIELD, STATUS_FIELD, RECOMMENDED_ACTION_UPDATES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyDbRecommendationRequest.memberNameToFieldInitializer();
    private final String recommendationId;
    private final String locale;
    private final String status;
    private final List<RecommendedActionUpdate> recommendedActionUpdates;

    private ModifyDbRecommendationRequest(BuilderImpl builder) {
        super(builder);
        this.recommendationId = builder.recommendationId;
        this.locale = builder.locale;
        this.status = builder.status;
        this.recommendedActionUpdates = builder.recommendedActionUpdates;
    }

    public final String recommendationId() {
        return this.recommendationId;
    }

    public final String locale() {
        return this.locale;
    }

    public final String status() {
        return this.status;
    }

    public final boolean hasRecommendedActionUpdates() {
        return this.recommendedActionUpdates != null && !(this.recommendedActionUpdates instanceof SdkAutoConstructList);
    }

    public final List<RecommendedActionUpdate> recommendedActionUpdates() {
        return this.recommendedActionUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.locale());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendedActionUpdates() ? this.recommendedActionUpdates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbRecommendationRequest)) {
            return false;
        }
        ModifyDbRecommendationRequest other = (ModifyDbRecommendationRequest)((Object)obj);
        return Objects.equals(this.recommendationId(), other.recommendationId()) && Objects.equals(this.locale(), other.locale()) && Objects.equals(this.status(), other.status()) && this.hasRecommendedActionUpdates() == other.hasRecommendedActionUpdates() && Objects.equals(this.recommendedActionUpdates(), other.recommendedActionUpdates());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyDbRecommendationRequest").add("RecommendationId", (Object)this.recommendationId()).add("Locale", (Object)this.locale()).add("Status", (Object)this.status()).add("RecommendedActionUpdates", this.hasRecommendedActionUpdates() ? this.recommendedActionUpdates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecommendationId": {
                return Optional.ofNullable(clazz.cast(this.recommendationId()));
            }
            case "Locale": {
                return Optional.ofNullable(clazz.cast(this.locale()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "RecommendedActionUpdates": {
                return Optional.ofNullable(clazz.cast(this.recommendedActionUpdates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RecommendationId", RECOMMENDATION_ID_FIELD);
        map.put("Locale", LOCALE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("RecommendedActionUpdates", RECOMMENDED_ACTION_UPDATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbRecommendationRequest, T> g) {
        return obj -> g.apply((ModifyDbRecommendationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String recommendationId;
        private String locale;
        private String status;
        private List<RecommendedActionUpdate> recommendedActionUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbRecommendationRequest model) {
            super(model);
            this.recommendationId(model.recommendationId);
            this.locale(model.locale);
            this.status(model.status);
            this.recommendedActionUpdates(model.recommendedActionUpdates);
        }

        public final String getRecommendationId() {
            return this.recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final String getLocale() {
            return this.locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final List<RecommendedActionUpdate.Builder> getRecommendedActionUpdates() {
            List<RecommendedActionUpdate.Builder> result = RecommendedActionUpdateListCopier.copyToBuilder(this.recommendedActionUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendedActionUpdates(Collection<RecommendedActionUpdate.BuilderImpl> recommendedActionUpdates) {
            this.recommendedActionUpdates = RecommendedActionUpdateListCopier.copyFromBuilder(recommendedActionUpdates);
        }

        @Override
        public final Builder recommendedActionUpdates(Collection<RecommendedActionUpdate> recommendedActionUpdates) {
            this.recommendedActionUpdates = RecommendedActionUpdateListCopier.copy(recommendedActionUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedActionUpdates(RecommendedActionUpdate ... recommendedActionUpdates) {
            this.recommendedActionUpdates(Arrays.asList(recommendedActionUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedActionUpdates(Consumer<RecommendedActionUpdate.Builder> ... recommendedActionUpdates) {
            this.recommendedActionUpdates(Stream.of(recommendedActionUpdates).map(c -> (RecommendedActionUpdate)((RecommendedActionUpdate.Builder)RecommendedActionUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbRecommendationRequest build() {
            return new ModifyDbRecommendationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyDbRecommendationRequest> {
        public Builder recommendationId(String var1);

        public Builder locale(String var1);

        public Builder status(String var1);

        public Builder recommendedActionUpdates(Collection<RecommendedActionUpdate> var1);

        public Builder recommendedActionUpdates(RecommendedActionUpdate ... var1);

        public Builder recommendedActionUpdates(Consumer<RecommendedActionUpdate.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

