/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.internal.UserAgentUtils;
import software.amazon.awssdk.services.rds.model.DBClusterEndpoint;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsResponse;

public class DescribeDBClusterEndpointsPublisher
implements SdkPublisher<DescribeDbClusterEndpointsResponse> {
    private final RdsAsyncClient client;
    private final DescribeDbClusterEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBClusterEndpointsPublisher(RdsAsyncClient client, DescribeDbClusterEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBClusterEndpointsPublisher(RdsAsyncClient client, DescribeDbClusterEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDbClusterEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDbClusterEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DBClusterEndpoint> dbClusterEndpoints() {
        Function<DescribeDbClusterEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbClusterEndpoints() != null) {
                return response.dbClusterEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDbClusterEndpointsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDbClusterEndpointsResponseFetcher
    implements AsyncPageFetcher<DescribeDbClusterEndpointsResponse> {
        private DescribeDbClusterEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbClusterEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeDbClusterEndpointsResponse> nextPage(DescribeDbClusterEndpointsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBClusterEndpointsPublisher.this.client.describeDBClusterEndpoints(DescribeDBClusterEndpointsPublisher.this.firstRequest);
            }
            return DescribeDBClusterEndpointsPublisher.this.client.describeDBClusterEndpoints((DescribeDbClusterEndpointsRequest)((Object)DescribeDBClusterEndpointsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

