/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.CACertificateIdentifiersListCopier;
import software.amazon.awssdk.services.rds.model.CharacterSet;
import software.amazon.awssdk.services.rds.model.CustomDBEngineVersionAMI;
import software.amazon.awssdk.services.rds.model.EngineModeListCopier;
import software.amazon.awssdk.services.rds.model.FeatureNameListCopier;
import software.amazon.awssdk.services.rds.model.LogTypeListCopier;
import software.amazon.awssdk.services.rds.model.ServerlessV2FeaturesSupport;
import software.amazon.awssdk.services.rds.model.SupportedCharacterSetsListCopier;
import software.amazon.awssdk.services.rds.model.SupportedTimezonesListCopier;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.services.rds.model.Timezone;
import software.amazon.awssdk.services.rds.model.UpgradeTarget;
import software.amazon.awssdk.services.rds.model.ValidUpgradeTargetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBEngineVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBEngineVersion> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(DBEngineVersion.getter(DBEngineVersion::engine)).setter(DBEngineVersion.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> MAJOR_ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MajorEngineVersion").getter(DBEngineVersion.getter(DBEngineVersion::majorEngineVersion)).setter(DBEngineVersion.setter(Builder::majorEngineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorEngineVersion").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(DBEngineVersion.getter(DBEngineVersion::engineVersion)).setter(DBEngineVersion.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> DATABASE_INSTALLATION_FILES_S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseInstallationFilesS3BucketName").getter(DBEngineVersion.getter(DBEngineVersion::databaseInstallationFilesS3BucketName)).setter(DBEngineVersion.setter(Builder::databaseInstallationFilesS3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseInstallationFilesS3BucketName").build()}).build();
    private static final SdkField<String> DATABASE_INSTALLATION_FILES_S3_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseInstallationFilesS3Prefix").getter(DBEngineVersion.getter(DBEngineVersion::databaseInstallationFilesS3Prefix)).setter(DBEngineVersion.setter(Builder::databaseInstallationFilesS3Prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseInstallationFilesS3Prefix").build()}).build();
    private static final SdkField<String> CUSTOM_DB_ENGINE_VERSION_MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomDBEngineVersionManifest").getter(DBEngineVersion.getter(DBEngineVersion::customDBEngineVersionManifest)).setter(DBEngineVersion.setter(Builder::customDBEngineVersionManifest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDBEngineVersionManifest").build()}).build();
    private static final SdkField<String> DB_PARAMETER_GROUP_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBParameterGroupFamily").getter(DBEngineVersion.getter(DBEngineVersion::dbParameterGroupFamily)).setter(DBEngineVersion.setter(Builder::dbParameterGroupFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupFamily").build()}).build();
    private static final SdkField<String> DB_ENGINE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBEngineDescription").getter(DBEngineVersion.getter(DBEngineVersion::dbEngineDescription)).setter(DBEngineVersion.setter(Builder::dbEngineDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBEngineDescription").build()}).build();
    private static final SdkField<String> DB_ENGINE_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBEngineVersionArn").getter(DBEngineVersion.getter(DBEngineVersion::dbEngineVersionArn)).setter(DBEngineVersion.setter(Builder::dbEngineVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBEngineVersionArn").build()}).build();
    private static final SdkField<String> DB_ENGINE_VERSION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBEngineVersionDescription").getter(DBEngineVersion.getter(DBEngineVersion::dbEngineVersionDescription)).setter(DBEngineVersion.setter(Builder::dbEngineVersionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBEngineVersionDescription").build()}).build();
    private static final SdkField<CharacterSet> DEFAULT_CHARACTER_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultCharacterSet").getter(DBEngineVersion.getter(DBEngineVersion::defaultCharacterSet)).setter(DBEngineVersion.setter(Builder::defaultCharacterSet)).constructor(CharacterSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCharacterSet").build()}).build();
    private static final SdkField<CustomDBEngineVersionAMI> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Image").getter(DBEngineVersion.getter(DBEngineVersion::image)).setter(DBEngineVersion.setter(Builder::image)).constructor(CustomDBEngineVersionAMI::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()}).build();
    private static final SdkField<String> DB_ENGINE_MEDIA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBEngineMediaType").getter(DBEngineVersion.getter(DBEngineVersion::dbEngineMediaType)).setter(DBEngineVersion.setter(Builder::dbEngineMediaType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBEngineMediaType").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSKeyId").getter(DBEngineVersion.getter(DBEngineVersion::kmsKeyId)).setter(DBEngineVersion.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyId").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(DBEngineVersion.getter(DBEngineVersion::createTime)).setter(DBEngineVersion.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()}).build();
    private static final SdkField<List<CharacterSet>> SUPPORTED_CHARACTER_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedCharacterSets").getter(DBEngineVersion.getter(DBEngineVersion::supportedCharacterSets)).setter(DBEngineVersion.setter(Builder::supportedCharacterSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedCharacterSets").build(), ListTrait.builder().memberLocationName("CharacterSet").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CharacterSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterSet").build()}).build()).build()}).build();
    private static final SdkField<List<CharacterSet>> SUPPORTED_NCHAR_CHARACTER_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedNcharCharacterSets").getter(DBEngineVersion.getter(DBEngineVersion::supportedNcharCharacterSets)).setter(DBEngineVersion.setter(Builder::supportedNcharCharacterSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedNcharCharacterSets").build(), ListTrait.builder().memberLocationName("CharacterSet").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CharacterSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterSet").build()}).build()).build()}).build();
    private static final SdkField<List<UpgradeTarget>> VALID_UPGRADE_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValidUpgradeTarget").getter(DBEngineVersion.getter(DBEngineVersion::validUpgradeTarget)).setter(DBEngineVersion.setter(Builder::validUpgradeTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUpgradeTarget").build(), ListTrait.builder().memberLocationName("UpgradeTarget").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpgradeTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeTarget").build()}).build()).build()}).build();
    private static final SdkField<List<Timezone>> SUPPORTED_TIMEZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedTimezones").getter(DBEngineVersion.getter(DBEngineVersion::supportedTimezones)).setter(DBEngineVersion.setter(Builder::supportedTimezones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedTimezones").build(), ListTrait.builder().memberLocationName("Timezone").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Timezone::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXPORTABLE_LOG_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExportableLogTypes").getter(DBEngineVersion.getter(DBEngineVersion::exportableLogTypes)).setter(DBEngineVersion.setter(Builder::exportableLogTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportableLogTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SUPPORTS_LOG_EXPORTS_TO_CLOUDWATCH_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsLogExportsToCloudwatchLogs").getter(DBEngineVersion.getter(DBEngineVersion::supportsLogExportsToCloudwatchLogs)).setter(DBEngineVersion.setter(Builder::supportsLogExportsToCloudwatchLogs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsLogExportsToCloudwatchLogs").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_READ_REPLICA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsReadReplica").getter(DBEngineVersion.getter(DBEngineVersion::supportsReadReplica)).setter(DBEngineVersion.setter(Builder::supportsReadReplica)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsReadReplica").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_ENGINE_MODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedEngineModes").getter(DBEngineVersion.getter(DBEngineVersion::supportedEngineModes)).setter(DBEngineVersion.setter(Builder::supportedEngineModes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedEngineModes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_FEATURE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedFeatureNames").getter(DBEngineVersion.getter(DBEngineVersion::supportedFeatureNames)).setter(DBEngineVersion.setter(Builder::supportedFeatureNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedFeatureNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DBEngineVersion.getter(DBEngineVersion::status)).setter(DBEngineVersion.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_PARALLEL_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsParallelQuery").getter(DBEngineVersion.getter(DBEngineVersion::supportsParallelQuery)).setter(DBEngineVersion.setter(Builder::supportsParallelQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsParallelQuery").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_GLOBAL_DATABASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsGlobalDatabases").getter(DBEngineVersion.getter(DBEngineVersion::supportsGlobalDatabases)).setter(DBEngineVersion.setter(Builder::supportsGlobalDatabases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsGlobalDatabases").build()}).build();
    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagList").getter(DBEngineVersion.getter(DBEngineVersion::tagList)).setter(DBEngineVersion.setter(Builder::tagList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagList").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SUPPORTS_BABELFISH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsBabelfish").getter(DBEngineVersion.getter(DBEngineVersion::supportsBabelfish)).setter(DBEngineVersion.setter(Builder::supportsBabelfish)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsBabelfish").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_LIMITLESS_DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsLimitlessDatabase").getter(DBEngineVersion.getter(DBEngineVersion::supportsLimitlessDatabase)).setter(DBEngineVersion.setter(Builder::supportsLimitlessDatabase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsLimitlessDatabase").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_CERTIFICATE_ROTATION_WITHOUT_RESTART_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsCertificateRotationWithoutRestart").getter(DBEngineVersion.getter(DBEngineVersion::supportsCertificateRotationWithoutRestart)).setter(DBEngineVersion.setter(Builder::supportsCertificateRotationWithoutRestart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsCertificateRotationWithoutRestart").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_CA_CERTIFICATE_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedCACertificateIdentifiers").getter(DBEngineVersion.getter(DBEngineVersion::supportedCACertificateIdentifiers)).setter(DBEngineVersion.setter(Builder::supportedCACertificateIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedCACertificateIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SUPPORTS_LOCAL_WRITE_FORWARDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsLocalWriteForwarding").getter(DBEngineVersion.getter(DBEngineVersion::supportsLocalWriteForwarding)).setter(DBEngineVersion.setter(Builder::supportsLocalWriteForwarding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsLocalWriteForwarding").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_INTEGRATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsIntegrations").getter(DBEngineVersion.getter(DBEngineVersion::supportsIntegrations)).setter(DBEngineVersion.setter(Builder::supportsIntegrations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsIntegrations").build()}).build();
    private static final SdkField<ServerlessV2FeaturesSupport> SERVERLESS_V2_FEATURES_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServerlessV2FeaturesSupport").getter(DBEngineVersion.getter(DBEngineVersion::serverlessV2FeaturesSupport)).setter(DBEngineVersion.setter(Builder::serverlessV2FeaturesSupport)).constructor(ServerlessV2FeaturesSupport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessV2FeaturesSupport").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD, MAJOR_ENGINE_VERSION_FIELD, ENGINE_VERSION_FIELD, DATABASE_INSTALLATION_FILES_S3_BUCKET_NAME_FIELD, DATABASE_INSTALLATION_FILES_S3_PREFIX_FIELD, CUSTOM_DB_ENGINE_VERSION_MANIFEST_FIELD, DB_PARAMETER_GROUP_FAMILY_FIELD, DB_ENGINE_DESCRIPTION_FIELD, DB_ENGINE_VERSION_ARN_FIELD, DB_ENGINE_VERSION_DESCRIPTION_FIELD, DEFAULT_CHARACTER_SET_FIELD, IMAGE_FIELD, DB_ENGINE_MEDIA_TYPE_FIELD, KMS_KEY_ID_FIELD, CREATE_TIME_FIELD, SUPPORTED_CHARACTER_SETS_FIELD, SUPPORTED_NCHAR_CHARACTER_SETS_FIELD, VALID_UPGRADE_TARGET_FIELD, SUPPORTED_TIMEZONES_FIELD, EXPORTABLE_LOG_TYPES_FIELD, SUPPORTS_LOG_EXPORTS_TO_CLOUDWATCH_LOGS_FIELD, SUPPORTS_READ_REPLICA_FIELD, SUPPORTED_ENGINE_MODES_FIELD, SUPPORTED_FEATURE_NAMES_FIELD, STATUS_FIELD, SUPPORTS_PARALLEL_QUERY_FIELD, SUPPORTS_GLOBAL_DATABASES_FIELD, TAG_LIST_FIELD, SUPPORTS_BABELFISH_FIELD, SUPPORTS_LIMITLESS_DATABASE_FIELD, SUPPORTS_CERTIFICATE_ROTATION_WITHOUT_RESTART_FIELD, SUPPORTED_CA_CERTIFICATE_IDENTIFIERS_FIELD, SUPPORTS_LOCAL_WRITE_FORWARDING_FIELD, SUPPORTS_INTEGRATIONS_FIELD, SERVERLESS_V2_FEATURES_SUPPORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DBEngineVersion.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String engine;
    private final String majorEngineVersion;
    private final String engineVersion;
    private final String databaseInstallationFilesS3BucketName;
    private final String databaseInstallationFilesS3Prefix;
    private final String customDBEngineVersionManifest;
    private final String dbParameterGroupFamily;
    private final String dbEngineDescription;
    private final String dbEngineVersionArn;
    private final String dbEngineVersionDescription;
    private final CharacterSet defaultCharacterSet;
    private final CustomDBEngineVersionAMI image;
    private final String dbEngineMediaType;
    private final String kmsKeyId;
    private final Instant createTime;
    private final List<CharacterSet> supportedCharacterSets;
    private final List<CharacterSet> supportedNcharCharacterSets;
    private final List<UpgradeTarget> validUpgradeTarget;
    private final List<Timezone> supportedTimezones;
    private final List<String> exportableLogTypes;
    private final Boolean supportsLogExportsToCloudwatchLogs;
    private final Boolean supportsReadReplica;
    private final List<String> supportedEngineModes;
    private final List<String> supportedFeatureNames;
    private final String status;
    private final Boolean supportsParallelQuery;
    private final Boolean supportsGlobalDatabases;
    private final List<Tag> tagList;
    private final Boolean supportsBabelfish;
    private final Boolean supportsLimitlessDatabase;
    private final Boolean supportsCertificateRotationWithoutRestart;
    private final List<String> supportedCACertificateIdentifiers;
    private final Boolean supportsLocalWriteForwarding;
    private final Boolean supportsIntegrations;
    private final ServerlessV2FeaturesSupport serverlessV2FeaturesSupport;

    private DBEngineVersion(BuilderImpl builder) {
        this.engine = builder.engine;
        this.majorEngineVersion = builder.majorEngineVersion;
        this.engineVersion = builder.engineVersion;
        this.databaseInstallationFilesS3BucketName = builder.databaseInstallationFilesS3BucketName;
        this.databaseInstallationFilesS3Prefix = builder.databaseInstallationFilesS3Prefix;
        this.customDBEngineVersionManifest = builder.customDBEngineVersionManifest;
        this.dbParameterGroupFamily = builder.dbParameterGroupFamily;
        this.dbEngineDescription = builder.dbEngineDescription;
        this.dbEngineVersionArn = builder.dbEngineVersionArn;
        this.dbEngineVersionDescription = builder.dbEngineVersionDescription;
        this.defaultCharacterSet = builder.defaultCharacterSet;
        this.image = builder.image;
        this.dbEngineMediaType = builder.dbEngineMediaType;
        this.kmsKeyId = builder.kmsKeyId;
        this.createTime = builder.createTime;
        this.supportedCharacterSets = builder.supportedCharacterSets;
        this.supportedNcharCharacterSets = builder.supportedNcharCharacterSets;
        this.validUpgradeTarget = builder.validUpgradeTarget;
        this.supportedTimezones = builder.supportedTimezones;
        this.exportableLogTypes = builder.exportableLogTypes;
        this.supportsLogExportsToCloudwatchLogs = builder.supportsLogExportsToCloudwatchLogs;
        this.supportsReadReplica = builder.supportsReadReplica;
        this.supportedEngineModes = builder.supportedEngineModes;
        this.supportedFeatureNames = builder.supportedFeatureNames;
        this.status = builder.status;
        this.supportsParallelQuery = builder.supportsParallelQuery;
        this.supportsGlobalDatabases = builder.supportsGlobalDatabases;
        this.tagList = builder.tagList;
        this.supportsBabelfish = builder.supportsBabelfish;
        this.supportsLimitlessDatabase = builder.supportsLimitlessDatabase;
        this.supportsCertificateRotationWithoutRestart = builder.supportsCertificateRotationWithoutRestart;
        this.supportedCACertificateIdentifiers = builder.supportedCACertificateIdentifiers;
        this.supportsLocalWriteForwarding = builder.supportsLocalWriteForwarding;
        this.supportsIntegrations = builder.supportsIntegrations;
        this.serverlessV2FeaturesSupport = builder.serverlessV2FeaturesSupport;
    }

    public final String engine() {
        return this.engine;
    }

    public final String majorEngineVersion() {
        return this.majorEngineVersion;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String databaseInstallationFilesS3BucketName() {
        return this.databaseInstallationFilesS3BucketName;
    }

    public final String databaseInstallationFilesS3Prefix() {
        return this.databaseInstallationFilesS3Prefix;
    }

    public final String customDBEngineVersionManifest() {
        return this.customDBEngineVersionManifest;
    }

    public final String dbParameterGroupFamily() {
        return this.dbParameterGroupFamily;
    }

    public final String dbEngineDescription() {
        return this.dbEngineDescription;
    }

    public final String dbEngineVersionArn() {
        return this.dbEngineVersionArn;
    }

    public final String dbEngineVersionDescription() {
        return this.dbEngineVersionDescription;
    }

    public final CharacterSet defaultCharacterSet() {
        return this.defaultCharacterSet;
    }

    public final CustomDBEngineVersionAMI image() {
        return this.image;
    }

    public final String dbEngineMediaType() {
        return this.dbEngineMediaType;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final boolean hasSupportedCharacterSets() {
        return this.supportedCharacterSets != null && !(this.supportedCharacterSets instanceof SdkAutoConstructList);
    }

    public final List<CharacterSet> supportedCharacterSets() {
        return this.supportedCharacterSets;
    }

    public final boolean hasSupportedNcharCharacterSets() {
        return this.supportedNcharCharacterSets != null && !(this.supportedNcharCharacterSets instanceof SdkAutoConstructList);
    }

    public final List<CharacterSet> supportedNcharCharacterSets() {
        return this.supportedNcharCharacterSets;
    }

    public final boolean hasValidUpgradeTarget() {
        return this.validUpgradeTarget != null && !(this.validUpgradeTarget instanceof SdkAutoConstructList);
    }

    public final List<UpgradeTarget> validUpgradeTarget() {
        return this.validUpgradeTarget;
    }

    public final boolean hasSupportedTimezones() {
        return this.supportedTimezones != null && !(this.supportedTimezones instanceof SdkAutoConstructList);
    }

    public final List<Timezone> supportedTimezones() {
        return this.supportedTimezones;
    }

    public final boolean hasExportableLogTypes() {
        return this.exportableLogTypes != null && !(this.exportableLogTypes instanceof SdkAutoConstructList);
    }

    public final List<String> exportableLogTypes() {
        return this.exportableLogTypes;
    }

    public final Boolean supportsLogExportsToCloudwatchLogs() {
        return this.supportsLogExportsToCloudwatchLogs;
    }

    public final Boolean supportsReadReplica() {
        return this.supportsReadReplica;
    }

    public final boolean hasSupportedEngineModes() {
        return this.supportedEngineModes != null && !(this.supportedEngineModes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedEngineModes() {
        return this.supportedEngineModes;
    }

    public final boolean hasSupportedFeatureNames() {
        return this.supportedFeatureNames != null && !(this.supportedFeatureNames instanceof SdkAutoConstructList);
    }

    public final List<String> supportedFeatureNames() {
        return this.supportedFeatureNames;
    }

    public final String status() {
        return this.status;
    }

    public final Boolean supportsParallelQuery() {
        return this.supportsParallelQuery;
    }

    public final Boolean supportsGlobalDatabases() {
        return this.supportsGlobalDatabases;
    }

    public final boolean hasTagList() {
        return this.tagList != null && !(this.tagList instanceof SdkAutoConstructList);
    }

    public final List<Tag> tagList() {
        return this.tagList;
    }

    public final Boolean supportsBabelfish() {
        return this.supportsBabelfish;
    }

    public final Boolean supportsLimitlessDatabase() {
        return this.supportsLimitlessDatabase;
    }

    public final Boolean supportsCertificateRotationWithoutRestart() {
        return this.supportsCertificateRotationWithoutRestart;
    }

    public final boolean hasSupportedCACertificateIdentifiers() {
        return this.supportedCACertificateIdentifiers != null && !(this.supportedCACertificateIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> supportedCACertificateIdentifiers() {
        return this.supportedCACertificateIdentifiers;
    }

    public final Boolean supportsLocalWriteForwarding() {
        return this.supportsLocalWriteForwarding;
    }

    public final Boolean supportsIntegrations() {
        return this.supportsIntegrations;
    }

    public final ServerlessV2FeaturesSupport serverlessV2FeaturesSupport() {
        return this.serverlessV2FeaturesSupport;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.majorEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseInstallationFilesS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseInstallationFilesS3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.customDBEngineVersionManifest());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbEngineDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbEngineVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbEngineVersionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCharacterSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbEngineMediaType());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedCharacterSets() ? this.supportedCharacterSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedNcharCharacterSets() ? this.supportedNcharCharacterSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidUpgradeTarget() ? this.validUpgradeTarget() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedTimezones() ? this.supportedTimezones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExportableLogTypes() ? this.exportableLogTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsLogExportsToCloudwatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsReadReplica());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedEngineModes() ? this.supportedEngineModes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedFeatureNames() ? this.supportedFeatureNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsParallelQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsGlobalDatabases());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagList() ? this.tagList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsBabelfish());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsLimitlessDatabase());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsCertificateRotationWithoutRestart());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedCACertificateIdentifiers() ? this.supportedCACertificateIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsLocalWriteForwarding());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsIntegrations());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverlessV2FeaturesSupport());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBEngineVersion)) {
            return false;
        }
        DBEngineVersion other = (DBEngineVersion)obj;
        return Objects.equals(this.engine(), other.engine()) && Objects.equals(this.majorEngineVersion(), other.majorEngineVersion()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.databaseInstallationFilesS3BucketName(), other.databaseInstallationFilesS3BucketName()) && Objects.equals(this.databaseInstallationFilesS3Prefix(), other.databaseInstallationFilesS3Prefix()) && Objects.equals(this.customDBEngineVersionManifest(), other.customDBEngineVersionManifest()) && Objects.equals(this.dbParameterGroupFamily(), other.dbParameterGroupFamily()) && Objects.equals(this.dbEngineDescription(), other.dbEngineDescription()) && Objects.equals(this.dbEngineVersionArn(), other.dbEngineVersionArn()) && Objects.equals(this.dbEngineVersionDescription(), other.dbEngineVersionDescription()) && Objects.equals(this.defaultCharacterSet(), other.defaultCharacterSet()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.dbEngineMediaType(), other.dbEngineMediaType()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.createTime(), other.createTime()) && this.hasSupportedCharacterSets() == other.hasSupportedCharacterSets() && Objects.equals(this.supportedCharacterSets(), other.supportedCharacterSets()) && this.hasSupportedNcharCharacterSets() == other.hasSupportedNcharCharacterSets() && Objects.equals(this.supportedNcharCharacterSets(), other.supportedNcharCharacterSets()) && this.hasValidUpgradeTarget() == other.hasValidUpgradeTarget() && Objects.equals(this.validUpgradeTarget(), other.validUpgradeTarget()) && this.hasSupportedTimezones() == other.hasSupportedTimezones() && Objects.equals(this.supportedTimezones(), other.supportedTimezones()) && this.hasExportableLogTypes() == other.hasExportableLogTypes() && Objects.equals(this.exportableLogTypes(), other.exportableLogTypes()) && Objects.equals(this.supportsLogExportsToCloudwatchLogs(), other.supportsLogExportsToCloudwatchLogs()) && Objects.equals(this.supportsReadReplica(), other.supportsReadReplica()) && this.hasSupportedEngineModes() == other.hasSupportedEngineModes() && Objects.equals(this.supportedEngineModes(), other.supportedEngineModes()) && this.hasSupportedFeatureNames() == other.hasSupportedFeatureNames() && Objects.equals(this.supportedFeatureNames(), other.supportedFeatureNames()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.supportsParallelQuery(), other.supportsParallelQuery()) && Objects.equals(this.supportsGlobalDatabases(), other.supportsGlobalDatabases()) && this.hasTagList() == other.hasTagList() && Objects.equals(this.tagList(), other.tagList()) && Objects.equals(this.supportsBabelfish(), other.supportsBabelfish()) && Objects.equals(this.supportsLimitlessDatabase(), other.supportsLimitlessDatabase()) && Objects.equals(this.supportsCertificateRotationWithoutRestart(), other.supportsCertificateRotationWithoutRestart()) && this.hasSupportedCACertificateIdentifiers() == other.hasSupportedCACertificateIdentifiers() && Objects.equals(this.supportedCACertificateIdentifiers(), other.supportedCACertificateIdentifiers()) && Objects.equals(this.supportsLocalWriteForwarding(), other.supportsLocalWriteForwarding()) && Objects.equals(this.supportsIntegrations(), other.supportsIntegrations()) && Objects.equals(this.serverlessV2FeaturesSupport(), other.serverlessV2FeaturesSupport());
    }

    public final String toString() {
        return ToString.builder((String)"DBEngineVersion").add("Engine", (Object)this.engine()).add("MajorEngineVersion", (Object)this.majorEngineVersion()).add("EngineVersion", (Object)this.engineVersion()).add("DatabaseInstallationFilesS3BucketName", (Object)this.databaseInstallationFilesS3BucketName()).add("DatabaseInstallationFilesS3Prefix", (Object)this.databaseInstallationFilesS3Prefix()).add("CustomDBEngineVersionManifest", (Object)this.customDBEngineVersionManifest()).add("DBParameterGroupFamily", (Object)this.dbParameterGroupFamily()).add("DBEngineDescription", (Object)this.dbEngineDescription()).add("DBEngineVersionArn", (Object)this.dbEngineVersionArn()).add("DBEngineVersionDescription", (Object)this.dbEngineVersionDescription()).add("DefaultCharacterSet", (Object)this.defaultCharacterSet()).add("Image", (Object)this.image()).add("DBEngineMediaType", (Object)this.dbEngineMediaType()).add("KMSKeyId", (Object)this.kmsKeyId()).add("CreateTime", (Object)this.createTime()).add("SupportedCharacterSets", this.hasSupportedCharacterSets() ? this.supportedCharacterSets() : null).add("SupportedNcharCharacterSets", this.hasSupportedNcharCharacterSets() ? this.supportedNcharCharacterSets() : null).add("ValidUpgradeTarget", this.hasValidUpgradeTarget() ? this.validUpgradeTarget() : null).add("SupportedTimezones", this.hasSupportedTimezones() ? this.supportedTimezones() : null).add("ExportableLogTypes", this.hasExportableLogTypes() ? this.exportableLogTypes() : null).add("SupportsLogExportsToCloudwatchLogs", (Object)this.supportsLogExportsToCloudwatchLogs()).add("SupportsReadReplica", (Object)this.supportsReadReplica()).add("SupportedEngineModes", this.hasSupportedEngineModes() ? this.supportedEngineModes() : null).add("SupportedFeatureNames", this.hasSupportedFeatureNames() ? this.supportedFeatureNames() : null).add("Status", (Object)this.status()).add("SupportsParallelQuery", (Object)this.supportsParallelQuery()).add("SupportsGlobalDatabases", (Object)this.supportsGlobalDatabases()).add("TagList", this.hasTagList() ? this.tagList() : null).add("SupportsBabelfish", (Object)this.supportsBabelfish()).add("SupportsLimitlessDatabase", (Object)this.supportsLimitlessDatabase()).add("SupportsCertificateRotationWithoutRestart", (Object)this.supportsCertificateRotationWithoutRestart()).add("SupportedCACertificateIdentifiers", this.hasSupportedCACertificateIdentifiers() ? this.supportedCACertificateIdentifiers() : null).add("SupportsLocalWriteForwarding", (Object)this.supportsLocalWriteForwarding()).add("SupportsIntegrations", (Object)this.supportsIntegrations()).add("ServerlessV2FeaturesSupport", (Object)this.serverlessV2FeaturesSupport()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "MajorEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.majorEngineVersion()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "DatabaseInstallationFilesS3BucketName": {
                return Optional.ofNullable(clazz.cast(this.databaseInstallationFilesS3BucketName()));
            }
            case "DatabaseInstallationFilesS3Prefix": {
                return Optional.ofNullable(clazz.cast(this.databaseInstallationFilesS3Prefix()));
            }
            case "CustomDBEngineVersionManifest": {
                return Optional.ofNullable(clazz.cast(this.customDBEngineVersionManifest()));
            }
            case "DBParameterGroupFamily": {
                return Optional.ofNullable(clazz.cast(this.dbParameterGroupFamily()));
            }
            case "DBEngineDescription": {
                return Optional.ofNullable(clazz.cast(this.dbEngineDescription()));
            }
            case "DBEngineVersionArn": {
                return Optional.ofNullable(clazz.cast(this.dbEngineVersionArn()));
            }
            case "DBEngineVersionDescription": {
                return Optional.ofNullable(clazz.cast(this.dbEngineVersionDescription()));
            }
            case "DefaultCharacterSet": {
                return Optional.ofNullable(clazz.cast(this.defaultCharacterSet()));
            }
            case "Image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "DBEngineMediaType": {
                return Optional.ofNullable(clazz.cast(this.dbEngineMediaType()));
            }
            case "KMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "SupportedCharacterSets": {
                return Optional.ofNullable(clazz.cast(this.supportedCharacterSets()));
            }
            case "SupportedNcharCharacterSets": {
                return Optional.ofNullable(clazz.cast(this.supportedNcharCharacterSets()));
            }
            case "ValidUpgradeTarget": {
                return Optional.ofNullable(clazz.cast(this.validUpgradeTarget()));
            }
            case "SupportedTimezones": {
                return Optional.ofNullable(clazz.cast(this.supportedTimezones()));
            }
            case "ExportableLogTypes": {
                return Optional.ofNullable(clazz.cast(this.exportableLogTypes()));
            }
            case "SupportsLogExportsToCloudwatchLogs": {
                return Optional.ofNullable(clazz.cast(this.supportsLogExportsToCloudwatchLogs()));
            }
            case "SupportsReadReplica": {
                return Optional.ofNullable(clazz.cast(this.supportsReadReplica()));
            }
            case "SupportedEngineModes": {
                return Optional.ofNullable(clazz.cast(this.supportedEngineModes()));
            }
            case "SupportedFeatureNames": {
                return Optional.ofNullable(clazz.cast(this.supportedFeatureNames()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "SupportsParallelQuery": {
                return Optional.ofNullable(clazz.cast(this.supportsParallelQuery()));
            }
            case "SupportsGlobalDatabases": {
                return Optional.ofNullable(clazz.cast(this.supportsGlobalDatabases()));
            }
            case "TagList": {
                return Optional.ofNullable(clazz.cast(this.tagList()));
            }
            case "SupportsBabelfish": {
                return Optional.ofNullable(clazz.cast(this.supportsBabelfish()));
            }
            case "SupportsLimitlessDatabase": {
                return Optional.ofNullable(clazz.cast(this.supportsLimitlessDatabase()));
            }
            case "SupportsCertificateRotationWithoutRestart": {
                return Optional.ofNullable(clazz.cast(this.supportsCertificateRotationWithoutRestart()));
            }
            case "SupportedCACertificateIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.supportedCACertificateIdentifiers()));
            }
            case "SupportsLocalWriteForwarding": {
                return Optional.ofNullable(clazz.cast(this.supportsLocalWriteForwarding()));
            }
            case "SupportsIntegrations": {
                return Optional.ofNullable(clazz.cast(this.supportsIntegrations()));
            }
            case "ServerlessV2FeaturesSupport": {
                return Optional.ofNullable(clazz.cast(this.serverlessV2FeaturesSupport()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Engine", ENGINE_FIELD);
        map.put("MajorEngineVersion", MAJOR_ENGINE_VERSION_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("DatabaseInstallationFilesS3BucketName", DATABASE_INSTALLATION_FILES_S3_BUCKET_NAME_FIELD);
        map.put("DatabaseInstallationFilesS3Prefix", DATABASE_INSTALLATION_FILES_S3_PREFIX_FIELD);
        map.put("CustomDBEngineVersionManifest", CUSTOM_DB_ENGINE_VERSION_MANIFEST_FIELD);
        map.put("DBParameterGroupFamily", DB_PARAMETER_GROUP_FAMILY_FIELD);
        map.put("DBEngineDescription", DB_ENGINE_DESCRIPTION_FIELD);
        map.put("DBEngineVersionArn", DB_ENGINE_VERSION_ARN_FIELD);
        map.put("DBEngineVersionDescription", DB_ENGINE_VERSION_DESCRIPTION_FIELD);
        map.put("DefaultCharacterSet", DEFAULT_CHARACTER_SET_FIELD);
        map.put("Image", IMAGE_FIELD);
        map.put("DBEngineMediaType", DB_ENGINE_MEDIA_TYPE_FIELD);
        map.put("KMSKeyId", KMS_KEY_ID_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("SupportedCharacterSets", SUPPORTED_CHARACTER_SETS_FIELD);
        map.put("SupportedNcharCharacterSets", SUPPORTED_NCHAR_CHARACTER_SETS_FIELD);
        map.put("ValidUpgradeTarget", VALID_UPGRADE_TARGET_FIELD);
        map.put("SupportedTimezones", SUPPORTED_TIMEZONES_FIELD);
        map.put("ExportableLogTypes", EXPORTABLE_LOG_TYPES_FIELD);
        map.put("SupportsLogExportsToCloudwatchLogs", SUPPORTS_LOG_EXPORTS_TO_CLOUDWATCH_LOGS_FIELD);
        map.put("SupportsReadReplica", SUPPORTS_READ_REPLICA_FIELD);
        map.put("SupportedEngineModes", SUPPORTED_ENGINE_MODES_FIELD);
        map.put("SupportedFeatureNames", SUPPORTED_FEATURE_NAMES_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("SupportsParallelQuery", SUPPORTS_PARALLEL_QUERY_FIELD);
        map.put("SupportsGlobalDatabases", SUPPORTS_GLOBAL_DATABASES_FIELD);
        map.put("TagList", TAG_LIST_FIELD);
        map.put("SupportsBabelfish", SUPPORTS_BABELFISH_FIELD);
        map.put("SupportsLimitlessDatabase", SUPPORTS_LIMITLESS_DATABASE_FIELD);
        map.put("SupportsCertificateRotationWithoutRestart", SUPPORTS_CERTIFICATE_ROTATION_WITHOUT_RESTART_FIELD);
        map.put("SupportedCACertificateIdentifiers", SUPPORTED_CA_CERTIFICATE_IDENTIFIERS_FIELD);
        map.put("SupportsLocalWriteForwarding", SUPPORTS_LOCAL_WRITE_FORWARDING_FIELD);
        map.put("SupportsIntegrations", SUPPORTS_INTEGRATIONS_FIELD);
        map.put("ServerlessV2FeaturesSupport", SERVERLESS_V2_FEATURES_SUPPORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DBEngineVersion, T> g) {
        return obj -> g.apply((DBEngineVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String engine;
        private String majorEngineVersion;
        private String engineVersion;
        private String databaseInstallationFilesS3BucketName;
        private String databaseInstallationFilesS3Prefix;
        private String customDBEngineVersionManifest;
        private String dbParameterGroupFamily;
        private String dbEngineDescription;
        private String dbEngineVersionArn;
        private String dbEngineVersionDescription;
        private CharacterSet defaultCharacterSet;
        private CustomDBEngineVersionAMI image;
        private String dbEngineMediaType;
        private String kmsKeyId;
        private Instant createTime;
        private List<CharacterSet> supportedCharacterSets = DefaultSdkAutoConstructList.getInstance();
        private List<CharacterSet> supportedNcharCharacterSets = DefaultSdkAutoConstructList.getInstance();
        private List<UpgradeTarget> validUpgradeTarget = DefaultSdkAutoConstructList.getInstance();
        private List<Timezone> supportedTimezones = DefaultSdkAutoConstructList.getInstance();
        private List<String> exportableLogTypes = DefaultSdkAutoConstructList.getInstance();
        private Boolean supportsLogExportsToCloudwatchLogs;
        private Boolean supportsReadReplica;
        private List<String> supportedEngineModes = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedFeatureNames = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private Boolean supportsParallelQuery;
        private Boolean supportsGlobalDatabases;
        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();
        private Boolean supportsBabelfish;
        private Boolean supportsLimitlessDatabase;
        private Boolean supportsCertificateRotationWithoutRestart;
        private List<String> supportedCACertificateIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private Boolean supportsLocalWriteForwarding;
        private Boolean supportsIntegrations;
        private ServerlessV2FeaturesSupport serverlessV2FeaturesSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(DBEngineVersion model) {
            this.engine(model.engine);
            this.majorEngineVersion(model.majorEngineVersion);
            this.engineVersion(model.engineVersion);
            this.databaseInstallationFilesS3BucketName(model.databaseInstallationFilesS3BucketName);
            this.databaseInstallationFilesS3Prefix(model.databaseInstallationFilesS3Prefix);
            this.customDBEngineVersionManifest(model.customDBEngineVersionManifest);
            this.dbParameterGroupFamily(model.dbParameterGroupFamily);
            this.dbEngineDescription(model.dbEngineDescription);
            this.dbEngineVersionArn(model.dbEngineVersionArn);
            this.dbEngineVersionDescription(model.dbEngineVersionDescription);
            this.defaultCharacterSet(model.defaultCharacterSet);
            this.image(model.image);
            this.dbEngineMediaType(model.dbEngineMediaType);
            this.kmsKeyId(model.kmsKeyId);
            this.createTime(model.createTime);
            this.supportedCharacterSets(model.supportedCharacterSets);
            this.supportedNcharCharacterSets(model.supportedNcharCharacterSets);
            this.validUpgradeTarget(model.validUpgradeTarget);
            this.supportedTimezones(model.supportedTimezones);
            this.exportableLogTypes(model.exportableLogTypes);
            this.supportsLogExportsToCloudwatchLogs(model.supportsLogExportsToCloudwatchLogs);
            this.supportsReadReplica(model.supportsReadReplica);
            this.supportedEngineModes(model.supportedEngineModes);
            this.supportedFeatureNames(model.supportedFeatureNames);
            this.status(model.status);
            this.supportsParallelQuery(model.supportsParallelQuery);
            this.supportsGlobalDatabases(model.supportsGlobalDatabases);
            this.tagList(model.tagList);
            this.supportsBabelfish(model.supportsBabelfish);
            this.supportsLimitlessDatabase(model.supportsLimitlessDatabase);
            this.supportsCertificateRotationWithoutRestart(model.supportsCertificateRotationWithoutRestart);
            this.supportedCACertificateIdentifiers(model.supportedCACertificateIdentifiers);
            this.supportsLocalWriteForwarding(model.supportsLocalWriteForwarding);
            this.supportsIntegrations(model.supportsIntegrations);
            this.serverlessV2FeaturesSupport(model.serverlessV2FeaturesSupport);
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getMajorEngineVersion() {
            return this.majorEngineVersion;
        }

        public final void setMajorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
        }

        @Override
        public final Builder majorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getDatabaseInstallationFilesS3BucketName() {
            return this.databaseInstallationFilesS3BucketName;
        }

        public final void setDatabaseInstallationFilesS3BucketName(String databaseInstallationFilesS3BucketName) {
            this.databaseInstallationFilesS3BucketName = databaseInstallationFilesS3BucketName;
        }

        @Override
        public final Builder databaseInstallationFilesS3BucketName(String databaseInstallationFilesS3BucketName) {
            this.databaseInstallationFilesS3BucketName = databaseInstallationFilesS3BucketName;
            return this;
        }

        public final String getDatabaseInstallationFilesS3Prefix() {
            return this.databaseInstallationFilesS3Prefix;
        }

        public final void setDatabaseInstallationFilesS3Prefix(String databaseInstallationFilesS3Prefix) {
            this.databaseInstallationFilesS3Prefix = databaseInstallationFilesS3Prefix;
        }

        @Override
        public final Builder databaseInstallationFilesS3Prefix(String databaseInstallationFilesS3Prefix) {
            this.databaseInstallationFilesS3Prefix = databaseInstallationFilesS3Prefix;
            return this;
        }

        public final String getCustomDBEngineVersionManifest() {
            return this.customDBEngineVersionManifest;
        }

        public final void setCustomDBEngineVersionManifest(String customDBEngineVersionManifest) {
            this.customDBEngineVersionManifest = customDBEngineVersionManifest;
        }

        @Override
        public final Builder customDBEngineVersionManifest(String customDBEngineVersionManifest) {
            this.customDBEngineVersionManifest = customDBEngineVersionManifest;
            return this;
        }

        public final String getDbParameterGroupFamily() {
            return this.dbParameterGroupFamily;
        }

        public final void setDbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
        }

        @Override
        public final Builder dbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
            return this;
        }

        public final String getDbEngineDescription() {
            return this.dbEngineDescription;
        }

        public final void setDbEngineDescription(String dbEngineDescription) {
            this.dbEngineDescription = dbEngineDescription;
        }

        @Override
        public final Builder dbEngineDescription(String dbEngineDescription) {
            this.dbEngineDescription = dbEngineDescription;
            return this;
        }

        public final String getDbEngineVersionArn() {
            return this.dbEngineVersionArn;
        }

        public final void setDbEngineVersionArn(String dbEngineVersionArn) {
            this.dbEngineVersionArn = dbEngineVersionArn;
        }

        @Override
        public final Builder dbEngineVersionArn(String dbEngineVersionArn) {
            this.dbEngineVersionArn = dbEngineVersionArn;
            return this;
        }

        public final String getDbEngineVersionDescription() {
            return this.dbEngineVersionDescription;
        }

        public final void setDbEngineVersionDescription(String dbEngineVersionDescription) {
            this.dbEngineVersionDescription = dbEngineVersionDescription;
        }

        @Override
        public final Builder dbEngineVersionDescription(String dbEngineVersionDescription) {
            this.dbEngineVersionDescription = dbEngineVersionDescription;
            return this;
        }

        public final CharacterSet.Builder getDefaultCharacterSet() {
            return this.defaultCharacterSet != null ? this.defaultCharacterSet.toBuilder() : null;
        }

        public final void setDefaultCharacterSet(CharacterSet.BuilderImpl defaultCharacterSet) {
            this.defaultCharacterSet = defaultCharacterSet != null ? defaultCharacterSet.build() : null;
        }

        @Override
        public final Builder defaultCharacterSet(CharacterSet defaultCharacterSet) {
            this.defaultCharacterSet = defaultCharacterSet;
            return this;
        }

        public final CustomDBEngineVersionAMI.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        public final void setImage(CustomDBEngineVersionAMI.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        @Override
        public final Builder image(CustomDBEngineVersionAMI image) {
            this.image = image;
            return this;
        }

        public final String getDbEngineMediaType() {
            return this.dbEngineMediaType;
        }

        public final void setDbEngineMediaType(String dbEngineMediaType) {
            this.dbEngineMediaType = dbEngineMediaType;
        }

        @Override
        public final Builder dbEngineMediaType(String dbEngineMediaType) {
            this.dbEngineMediaType = dbEngineMediaType;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final List<CharacterSet.Builder> getSupportedCharacterSets() {
            List<CharacterSet.Builder> result = SupportedCharacterSetsListCopier.copyToBuilder(this.supportedCharacterSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedCharacterSets(Collection<CharacterSet.BuilderImpl> supportedCharacterSets) {
            this.supportedCharacterSets = SupportedCharacterSetsListCopier.copyFromBuilder(supportedCharacterSets);
        }

        @Override
        public final Builder supportedCharacterSets(Collection<CharacterSet> supportedCharacterSets) {
            this.supportedCharacterSets = SupportedCharacterSetsListCopier.copy(supportedCharacterSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedCharacterSets(CharacterSet ... supportedCharacterSets) {
            this.supportedCharacterSets(Arrays.asList(supportedCharacterSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedCharacterSets(Consumer<CharacterSet.Builder> ... supportedCharacterSets) {
            this.supportedCharacterSets(Stream.of(supportedCharacterSets).map(c -> (CharacterSet)((CharacterSet.Builder)CharacterSet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CharacterSet.Builder> getSupportedNcharCharacterSets() {
            List<CharacterSet.Builder> result = SupportedCharacterSetsListCopier.copyToBuilder(this.supportedNcharCharacterSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedNcharCharacterSets(Collection<CharacterSet.BuilderImpl> supportedNcharCharacterSets) {
            this.supportedNcharCharacterSets = SupportedCharacterSetsListCopier.copyFromBuilder(supportedNcharCharacterSets);
        }

        @Override
        public final Builder supportedNcharCharacterSets(Collection<CharacterSet> supportedNcharCharacterSets) {
            this.supportedNcharCharacterSets = SupportedCharacterSetsListCopier.copy(supportedNcharCharacterSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedNcharCharacterSets(CharacterSet ... supportedNcharCharacterSets) {
            this.supportedNcharCharacterSets(Arrays.asList(supportedNcharCharacterSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedNcharCharacterSets(Consumer<CharacterSet.Builder> ... supportedNcharCharacterSets) {
            this.supportedNcharCharacterSets(Stream.of(supportedNcharCharacterSets).map(c -> (CharacterSet)((CharacterSet.Builder)CharacterSet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UpgradeTarget.Builder> getValidUpgradeTarget() {
            List<UpgradeTarget.Builder> result = ValidUpgradeTargetListCopier.copyToBuilder(this.validUpgradeTarget);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidUpgradeTarget(Collection<UpgradeTarget.BuilderImpl> validUpgradeTarget) {
            this.validUpgradeTarget = ValidUpgradeTargetListCopier.copyFromBuilder(validUpgradeTarget);
        }

        @Override
        public final Builder validUpgradeTarget(Collection<UpgradeTarget> validUpgradeTarget) {
            this.validUpgradeTarget = ValidUpgradeTargetListCopier.copy(validUpgradeTarget);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validUpgradeTarget(UpgradeTarget ... validUpgradeTarget) {
            this.validUpgradeTarget(Arrays.asList(validUpgradeTarget));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validUpgradeTarget(Consumer<UpgradeTarget.Builder> ... validUpgradeTarget) {
            this.validUpgradeTarget(Stream.of(validUpgradeTarget).map(c -> (UpgradeTarget)((UpgradeTarget.Builder)UpgradeTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Timezone.Builder> getSupportedTimezones() {
            List<Timezone.Builder> result = SupportedTimezonesListCopier.copyToBuilder(this.supportedTimezones);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedTimezones(Collection<Timezone.BuilderImpl> supportedTimezones) {
            this.supportedTimezones = SupportedTimezonesListCopier.copyFromBuilder(supportedTimezones);
        }

        @Override
        public final Builder supportedTimezones(Collection<Timezone> supportedTimezones) {
            this.supportedTimezones = SupportedTimezonesListCopier.copy(supportedTimezones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTimezones(Timezone ... supportedTimezones) {
            this.supportedTimezones(Arrays.asList(supportedTimezones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTimezones(Consumer<Timezone.Builder> ... supportedTimezones) {
            this.supportedTimezones(Stream.of(supportedTimezones).map(c -> (Timezone)((Timezone.Builder)Timezone.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getExportableLogTypes() {
            if (this.exportableLogTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exportableLogTypes;
        }

        public final void setExportableLogTypes(Collection<String> exportableLogTypes) {
            this.exportableLogTypes = LogTypeListCopier.copy(exportableLogTypes);
        }

        @Override
        public final Builder exportableLogTypes(Collection<String> exportableLogTypes) {
            this.exportableLogTypes = LogTypeListCopier.copy(exportableLogTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportableLogTypes(String ... exportableLogTypes) {
            this.exportableLogTypes(Arrays.asList(exportableLogTypes));
            return this;
        }

        public final Boolean getSupportsLogExportsToCloudwatchLogs() {
            return this.supportsLogExportsToCloudwatchLogs;
        }

        public final void setSupportsLogExportsToCloudwatchLogs(Boolean supportsLogExportsToCloudwatchLogs) {
            this.supportsLogExportsToCloudwatchLogs = supportsLogExportsToCloudwatchLogs;
        }

        @Override
        public final Builder supportsLogExportsToCloudwatchLogs(Boolean supportsLogExportsToCloudwatchLogs) {
            this.supportsLogExportsToCloudwatchLogs = supportsLogExportsToCloudwatchLogs;
            return this;
        }

        public final Boolean getSupportsReadReplica() {
            return this.supportsReadReplica;
        }

        public final void setSupportsReadReplica(Boolean supportsReadReplica) {
            this.supportsReadReplica = supportsReadReplica;
        }

        @Override
        public final Builder supportsReadReplica(Boolean supportsReadReplica) {
            this.supportsReadReplica = supportsReadReplica;
            return this;
        }

        public final Collection<String> getSupportedEngineModes() {
            if (this.supportedEngineModes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedEngineModes;
        }

        public final void setSupportedEngineModes(Collection<String> supportedEngineModes) {
            this.supportedEngineModes = EngineModeListCopier.copy(supportedEngineModes);
        }

        @Override
        public final Builder supportedEngineModes(Collection<String> supportedEngineModes) {
            this.supportedEngineModes = EngineModeListCopier.copy(supportedEngineModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedEngineModes(String ... supportedEngineModes) {
            this.supportedEngineModes(Arrays.asList(supportedEngineModes));
            return this;
        }

        public final Collection<String> getSupportedFeatureNames() {
            if (this.supportedFeatureNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedFeatureNames;
        }

        public final void setSupportedFeatureNames(Collection<String> supportedFeatureNames) {
            this.supportedFeatureNames = FeatureNameListCopier.copy(supportedFeatureNames);
        }

        @Override
        public final Builder supportedFeatureNames(Collection<String> supportedFeatureNames) {
            this.supportedFeatureNames = FeatureNameListCopier.copy(supportedFeatureNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedFeatureNames(String ... supportedFeatureNames) {
            this.supportedFeatureNames(Arrays.asList(supportedFeatureNames));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Boolean getSupportsParallelQuery() {
            return this.supportsParallelQuery;
        }

        public final void setSupportsParallelQuery(Boolean supportsParallelQuery) {
            this.supportsParallelQuery = supportsParallelQuery;
        }

        @Override
        public final Builder supportsParallelQuery(Boolean supportsParallelQuery) {
            this.supportsParallelQuery = supportsParallelQuery;
            return this;
        }

        public final Boolean getSupportsGlobalDatabases() {
            return this.supportsGlobalDatabases;
        }

        public final void setSupportsGlobalDatabases(Boolean supportsGlobalDatabases) {
            this.supportsGlobalDatabases = supportsGlobalDatabases;
        }

        @Override
        public final Builder supportsGlobalDatabases(Boolean supportsGlobalDatabases) {
            this.supportsGlobalDatabases = supportsGlobalDatabases;
            return this;
        }

        public final List<Tag.Builder> getTagList() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag ... tagList) {
            this.tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder> ... tagList) {
            this.tagList(Stream.of(tagList).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getSupportsBabelfish() {
            return this.supportsBabelfish;
        }

        public final void setSupportsBabelfish(Boolean supportsBabelfish) {
            this.supportsBabelfish = supportsBabelfish;
        }

        @Override
        public final Builder supportsBabelfish(Boolean supportsBabelfish) {
            this.supportsBabelfish = supportsBabelfish;
            return this;
        }

        public final Boolean getSupportsLimitlessDatabase() {
            return this.supportsLimitlessDatabase;
        }

        public final void setSupportsLimitlessDatabase(Boolean supportsLimitlessDatabase) {
            this.supportsLimitlessDatabase = supportsLimitlessDatabase;
        }

        @Override
        public final Builder supportsLimitlessDatabase(Boolean supportsLimitlessDatabase) {
            this.supportsLimitlessDatabase = supportsLimitlessDatabase;
            return this;
        }

        public final Boolean getSupportsCertificateRotationWithoutRestart() {
            return this.supportsCertificateRotationWithoutRestart;
        }

        public final void setSupportsCertificateRotationWithoutRestart(Boolean supportsCertificateRotationWithoutRestart) {
            this.supportsCertificateRotationWithoutRestart = supportsCertificateRotationWithoutRestart;
        }

        @Override
        public final Builder supportsCertificateRotationWithoutRestart(Boolean supportsCertificateRotationWithoutRestart) {
            this.supportsCertificateRotationWithoutRestart = supportsCertificateRotationWithoutRestart;
            return this;
        }

        public final Collection<String> getSupportedCACertificateIdentifiers() {
            if (this.supportedCACertificateIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedCACertificateIdentifiers;
        }

        public final void setSupportedCACertificateIdentifiers(Collection<String> supportedCACertificateIdentifiers) {
            this.supportedCACertificateIdentifiers = CACertificateIdentifiersListCopier.copy(supportedCACertificateIdentifiers);
        }

        @Override
        public final Builder supportedCACertificateIdentifiers(Collection<String> supportedCACertificateIdentifiers) {
            this.supportedCACertificateIdentifiers = CACertificateIdentifiersListCopier.copy(supportedCACertificateIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedCACertificateIdentifiers(String ... supportedCACertificateIdentifiers) {
            this.supportedCACertificateIdentifiers(Arrays.asList(supportedCACertificateIdentifiers));
            return this;
        }

        public final Boolean getSupportsLocalWriteForwarding() {
            return this.supportsLocalWriteForwarding;
        }

        public final void setSupportsLocalWriteForwarding(Boolean supportsLocalWriteForwarding) {
            this.supportsLocalWriteForwarding = supportsLocalWriteForwarding;
        }

        @Override
        public final Builder supportsLocalWriteForwarding(Boolean supportsLocalWriteForwarding) {
            this.supportsLocalWriteForwarding = supportsLocalWriteForwarding;
            return this;
        }

        public final Boolean getSupportsIntegrations() {
            return this.supportsIntegrations;
        }

        public final void setSupportsIntegrations(Boolean supportsIntegrations) {
            this.supportsIntegrations = supportsIntegrations;
        }

        @Override
        public final Builder supportsIntegrations(Boolean supportsIntegrations) {
            this.supportsIntegrations = supportsIntegrations;
            return this;
        }

        public final ServerlessV2FeaturesSupport.Builder getServerlessV2FeaturesSupport() {
            return this.serverlessV2FeaturesSupport != null ? this.serverlessV2FeaturesSupport.toBuilder() : null;
        }

        public final void setServerlessV2FeaturesSupport(ServerlessV2FeaturesSupport.BuilderImpl serverlessV2FeaturesSupport) {
            this.serverlessV2FeaturesSupport = serverlessV2FeaturesSupport != null ? serverlessV2FeaturesSupport.build() : null;
        }

        @Override
        public final Builder serverlessV2FeaturesSupport(ServerlessV2FeaturesSupport serverlessV2FeaturesSupport) {
            this.serverlessV2FeaturesSupport = serverlessV2FeaturesSupport;
            return this;
        }

        public DBEngineVersion build() {
            return new DBEngineVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBEngineVersion> {
        public Builder engine(String var1);

        public Builder majorEngineVersion(String var1);

        public Builder engineVersion(String var1);

        public Builder databaseInstallationFilesS3BucketName(String var1);

        public Builder databaseInstallationFilesS3Prefix(String var1);

        public Builder customDBEngineVersionManifest(String var1);

        public Builder dbParameterGroupFamily(String var1);

        public Builder dbEngineDescription(String var1);

        public Builder dbEngineVersionArn(String var1);

        public Builder dbEngineVersionDescription(String var1);

        public Builder defaultCharacterSet(CharacterSet var1);

        default public Builder defaultCharacterSet(Consumer<CharacterSet.Builder> defaultCharacterSet) {
            return this.defaultCharacterSet((CharacterSet)((CharacterSet.Builder)CharacterSet.builder().applyMutation(defaultCharacterSet)).build());
        }

        public Builder image(CustomDBEngineVersionAMI var1);

        default public Builder image(Consumer<CustomDBEngineVersionAMI.Builder> image) {
            return this.image((CustomDBEngineVersionAMI)((CustomDBEngineVersionAMI.Builder)CustomDBEngineVersionAMI.builder().applyMutation(image)).build());
        }

        public Builder dbEngineMediaType(String var1);

        public Builder kmsKeyId(String var1);

        public Builder createTime(Instant var1);

        public Builder supportedCharacterSets(Collection<CharacterSet> var1);

        public Builder supportedCharacterSets(CharacterSet ... var1);

        public Builder supportedCharacterSets(Consumer<CharacterSet.Builder> ... var1);

        public Builder supportedNcharCharacterSets(Collection<CharacterSet> var1);

        public Builder supportedNcharCharacterSets(CharacterSet ... var1);

        public Builder supportedNcharCharacterSets(Consumer<CharacterSet.Builder> ... var1);

        public Builder validUpgradeTarget(Collection<UpgradeTarget> var1);

        public Builder validUpgradeTarget(UpgradeTarget ... var1);

        public Builder validUpgradeTarget(Consumer<UpgradeTarget.Builder> ... var1);

        public Builder supportedTimezones(Collection<Timezone> var1);

        public Builder supportedTimezones(Timezone ... var1);

        public Builder supportedTimezones(Consumer<Timezone.Builder> ... var1);

        public Builder exportableLogTypes(Collection<String> var1);

        public Builder exportableLogTypes(String ... var1);

        public Builder supportsLogExportsToCloudwatchLogs(Boolean var1);

        public Builder supportsReadReplica(Boolean var1);

        public Builder supportedEngineModes(Collection<String> var1);

        public Builder supportedEngineModes(String ... var1);

        public Builder supportedFeatureNames(Collection<String> var1);

        public Builder supportedFeatureNames(String ... var1);

        public Builder status(String var1);

        public Builder supportsParallelQuery(Boolean var1);

        public Builder supportsGlobalDatabases(Boolean var1);

        public Builder tagList(Collection<Tag> var1);

        public Builder tagList(Tag ... var1);

        public Builder tagList(Consumer<Tag.Builder> ... var1);

        public Builder supportsBabelfish(Boolean var1);

        public Builder supportsLimitlessDatabase(Boolean var1);

        public Builder supportsCertificateRotationWithoutRestart(Boolean var1);

        public Builder supportedCACertificateIdentifiers(Collection<String> var1);

        public Builder supportedCACertificateIdentifiers(String ... var1);

        public Builder supportsLocalWriteForwarding(Boolean var1);

        public Builder supportsIntegrations(Boolean var1);

        public Builder serverlessV2FeaturesSupport(ServerlessV2FeaturesSupport var1);

        default public Builder serverlessV2FeaturesSupport(Consumer<ServerlessV2FeaturesSupport.Builder> serverlessV2FeaturesSupport) {
            return this.serverlessV2FeaturesSupport((ServerlessV2FeaturesSupport)((ServerlessV2FeaturesSupport.Builder)ServerlessV2FeaturesSupport.builder().applyMutation(serverlessV2FeaturesSupport)).build());
        }
    }
}

