/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.internal.UserAgentUtils;
import software.amazon.awssdk.services.rds.model.DBClusterBacktrack;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksResponse;

public class DescribeDBClusterBacktracksPublisher
implements SdkPublisher<DescribeDbClusterBacktracksResponse> {
    private final RdsAsyncClient client;
    private final DescribeDbClusterBacktracksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBClusterBacktracksPublisher(RdsAsyncClient client, DescribeDbClusterBacktracksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBClusterBacktracksPublisher(RdsAsyncClient client, DescribeDbClusterBacktracksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDbClusterBacktracksResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDbClusterBacktracksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DBClusterBacktrack> dbClusterBacktracks() {
        Function<DescribeDbClusterBacktracksResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbClusterBacktracks() != null) {
                return response.dbClusterBacktracks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDbClusterBacktracksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDbClusterBacktracksResponseFetcher
    implements AsyncPageFetcher<DescribeDbClusterBacktracksResponse> {
        private DescribeDbClusterBacktracksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbClusterBacktracksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeDbClusterBacktracksResponse> nextPage(DescribeDbClusterBacktracksResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBClusterBacktracksPublisher.this.client.describeDBClusterBacktracks(DescribeDBClusterBacktracksPublisher.this.firstRequest);
            }
            return DescribeDBClusterBacktracksPublisher.this.client.describeDBClusterBacktracks((DescribeDbClusterBacktracksRequest)((Object)DescribeDBClusterBacktracksPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

