/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.internal.UserAgentUtils;
import software.amazon.awssdk.services.rds.model.DBRecommendation;
import software.amazon.awssdk.services.rds.model.DescribeDbRecommendationsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbRecommendationsResponse;

public class DescribeDBRecommendationsIterable
implements SdkIterable<DescribeDbRecommendationsResponse> {
    private final RdsClient client;
    private final DescribeDbRecommendationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBRecommendationsIterable(RdsClient client, DescribeDbRecommendationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeDbRecommendationsResponseFetcher();
    }

    public Iterator<DescribeDbRecommendationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DBRecommendation> dbRecommendations() {
        Function<DescribeDbRecommendationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbRecommendations() != null) {
                return response.dbRecommendations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDbRecommendationsResponseFetcher
    implements SyncPageFetcher<DescribeDbRecommendationsResponse> {
        private DescribeDbRecommendationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbRecommendationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbRecommendationsResponse nextPage(DescribeDbRecommendationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBRecommendationsIterable.this.client.describeDBRecommendations(DescribeDBRecommendationsIterable.this.firstRequest);
            }
            return DescribeDBRecommendationsIterable.this.client.describeDBRecommendations((DescribeDbRecommendationsRequest)((Object)DescribeDBRecommendationsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

