/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.CredentialUtils;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.params.Aws4PresignerParams;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rds.RdsUtilities;
import software.amazon.awssdk.services.rds.model.GenerateAuthenticationTokenRequest;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.StringUtils;

@Immutable
@SdkInternalApi
final class DefaultRdsUtilities
implements RdsUtilities {
    private static final Logger log = Logger.loggerFor(RdsUtilities.class);
    private static final Duration EXPIRATION_DURATION = Duration.ofMinutes(15L);
    private final Aws4Signer signer = Aws4Signer.create();
    private final Region region;
    private final IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider;
    private final Clock clock;

    DefaultRdsUtilities(DefaultBuilder builder) {
        this(builder, Clock.systemUTC());
    }

    DefaultRdsUtilities(DefaultBuilder builder, Clock clock) {
        this.credentialsProvider = builder.credentialsProvider;
        this.region = builder.region;
        this.clock = clock;
    }

    @SdkInternalApi
    static RdsUtilities create(SdkClientConfiguration clientConfiguration) {
        return new DefaultBuilder().clientConfiguration(clientConfiguration).build();
    }

    @Override
    public String generateAuthenticationToken(GenerateAuthenticationTokenRequest request) {
        SdkHttpFullRequest httpRequest = SdkHttpFullRequest.builder().method(SdkHttpMethod.GET).protocol("https").host(request.hostname()).port(Integer.valueOf(request.port())).encodedPath("/").putRawQueryParameter("DBUser", request.username()).putRawQueryParameter("Action", "connect").build();
        Instant expirationTime = Instant.now(this.clock).plus(EXPIRATION_DURATION);
        Aws4PresignerParams presignRequest = ((Aws4PresignerParams.Builder)((Aws4PresignerParams.Builder)((Aws4PresignerParams.Builder)((Aws4PresignerParams.Builder)Aws4PresignerParams.builder().signingClockOverride(this.clock)).expirationTime(expirationTime).awsCredentials(this.resolveCredentials(request))).signingName("rds-db")).signingRegion(this.resolveRegion(request))).build();
        SdkHttpFullRequest fullRequest = this.signer.presign(httpRequest, presignRequest);
        String signedUrl = fullRequest.getUri().toString();
        String result = StringUtils.replacePrefixIgnoreCase((String)signedUrl, (String)"https://", (String)"");
        log.debug(() -> "Generated RDS authentication token with expiration of " + expirationTime);
        return result;
    }

    private Region resolveRegion(GenerateAuthenticationTokenRequest request) {
        if (request.region() != null) {
            return request.region();
        }
        if (this.region != null) {
            return this.region;
        }
        throw new IllegalArgumentException("Region should be provided either in GenerateAuthenticationTokenRequest object or RdsUtilities object");
    }

    private AwsCredentials resolveCredentials(GenerateAuthenticationTokenRequest request) {
        if (request.credentialsIdentityProvider() != null) {
            return CredentialUtils.toCredentials((AwsCredentialsIdentity)((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)request.credentialsIdentityProvider().resolveIdentity())));
        }
        if (this.credentialsProvider != null) {
            return CredentialUtils.toCredentials((AwsCredentialsIdentity)((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)this.credentialsProvider.resolveIdentity())));
        }
        throw new IllegalArgumentException("CredentialProvider should be provided either in GenerateAuthenticationTokenRequest object or RdsUtilities object");
    }

    @SdkInternalApi
    static final class DefaultBuilder
    implements RdsUtilities.Builder {
        private Region region;
        private IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider;

        DefaultBuilder() {
        }

        RdsUtilities.Builder clientConfiguration(SdkClientConfiguration clientConfiguration) {
            this.credentialsProvider = (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER);
            this.region = (Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION);
            return this;
        }

        @Override
        public RdsUtilities.Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public RdsUtilities.Builder credentialsProvider(IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        @Override
        public RdsUtilities build() {
            return new DefaultRdsUtilities(this);
        }
    }
}

