/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.Metric;
import software.amazon.awssdk.services.rds.model.MetricListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PerformanceIssueDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PerformanceIssueDetails> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(PerformanceIssueDetails.getter(PerformanceIssueDetails::startTime)).setter(PerformanceIssueDetails.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(PerformanceIssueDetails.getter(PerformanceIssueDetails::endTime)).setter(PerformanceIssueDetails.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<List<Metric>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Metrics").getter(PerformanceIssueDetails.getter(PerformanceIssueDetails::metrics)).setter(PerformanceIssueDetails.setter(Builder::metrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Metric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ANALYSIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Analysis").getter(PerformanceIssueDetails.getter(PerformanceIssueDetails::analysis)).setter(PerformanceIssueDetails.setter(Builder::analysis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Analysis").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD, END_TIME_FIELD, METRICS_FIELD, ANALYSIS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PerformanceIssueDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant startTime;
    private final Instant endTime;
    private final List<Metric> metrics;
    private final String analysis;

    private PerformanceIssueDetails(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.metrics = builder.metrics;
        this.analysis = builder.analysis;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructList);
    }

    public final List<Metric> metrics() {
        return this.metrics;
    }

    public final String analysis() {
        return this.analysis;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetrics() ? this.metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.analysis());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PerformanceIssueDetails)) {
            return false;
        }
        PerformanceIssueDetails other = (PerformanceIssueDetails)obj;
        return Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && this.hasMetrics() == other.hasMetrics() && Objects.equals(this.metrics(), other.metrics()) && Objects.equals(this.analysis(), other.analysis());
    }

    public final String toString() {
        return ToString.builder((String)"PerformanceIssueDetails").add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Metrics", this.hasMetrics() ? this.metrics() : null).add("Analysis", (Object)this.analysis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "Analysis": {
                return Optional.ofNullable(clazz.cast(this.analysis()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Metrics", METRICS_FIELD);
        map.put("Analysis", ANALYSIS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PerformanceIssueDetails, T> g) {
        return obj -> g.apply((PerformanceIssueDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant startTime;
        private Instant endTime;
        private List<Metric> metrics = DefaultSdkAutoConstructList.getInstance();
        private String analysis;

        private BuilderImpl() {
        }

        private BuilderImpl(PerformanceIssueDetails model) {
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.metrics(model.metrics);
            this.analysis(model.analysis);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final List<Metric.Builder> getMetrics() {
            List<Metric.Builder> result = MetricListCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Collection<Metric.BuilderImpl> metrics) {
            this.metrics = MetricListCopier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Collection<Metric> metrics) {
            this.metrics = MetricListCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Metric ... metrics) {
            this.metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<Metric.Builder> ... metrics) {
            this.metrics(Stream.of(metrics).map(c -> (Metric)((Metric.Builder)Metric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAnalysis() {
            return this.analysis;
        }

        public final void setAnalysis(String analysis) {
            this.analysis = analysis;
        }

        @Override
        public final Builder analysis(String analysis) {
            this.analysis = analysis;
            return this;
        }

        public PerformanceIssueDetails build() {
            return new PerformanceIssueDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PerformanceIssueDetails> {
        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder metrics(Collection<Metric> var1);

        public Builder metrics(Metric ... var1);

        public Builder metrics(Consumer<Metric.Builder> ... var1);

        public Builder analysis(String var1);
    }
}

