/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.MetricQuery;
import software.amazon.awssdk.services.rds.model.MetricReference;
import software.amazon.awssdk.services.rds.model.MetricReferenceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Metric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Metric> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Metric.getter(Metric::name)).setter(Metric.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<MetricReference>> REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("References").getter(Metric.getter(Metric::references)).setter(Metric.setter(Builder::references)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("References").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATISTICS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatisticsDetails").getter(Metric.getter(Metric::statisticsDetails)).setter(Metric.setter(Builder::statisticsDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatisticsDetails").build()}).build();
    private static final SdkField<MetricQuery> METRIC_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetricQuery").getter(Metric.getter(Metric::metricQuery)).setter(Metric.setter(Builder::metricQuery)).constructor(MetricQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricQuery").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, REFERENCES_FIELD, STATISTICS_DETAILS_FIELD, METRIC_QUERY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Metric.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<MetricReference> references;
    private final String statisticsDetails;
    private final MetricQuery metricQuery;

    private Metric(BuilderImpl builder) {
        this.name = builder.name;
        this.references = builder.references;
        this.statisticsDetails = builder.statisticsDetails;
        this.metricQuery = builder.metricQuery;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasReferences() {
        return this.references != null && !(this.references instanceof SdkAutoConstructList);
    }

    public final List<MetricReference> references() {
        return this.references;
    }

    public final String statisticsDetails() {
        return this.statisticsDetails;
    }

    public final MetricQuery metricQuery() {
        return this.metricQuery;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferences() ? this.references() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticsDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricQuery());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Metric)) {
            return false;
        }
        Metric other = (Metric)obj;
        return Objects.equals(this.name(), other.name()) && this.hasReferences() == other.hasReferences() && Objects.equals(this.references(), other.references()) && Objects.equals(this.statisticsDetails(), other.statisticsDetails()) && Objects.equals(this.metricQuery(), other.metricQuery());
    }

    public final String toString() {
        return ToString.builder((String)"Metric").add("Name", (Object)this.name()).add("References", this.hasReferences() ? this.references() : null).add("StatisticsDetails", (Object)this.statisticsDetails()).add("MetricQuery", (Object)this.metricQuery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "References": {
                return Optional.ofNullable(clazz.cast(this.references()));
            }
            case "StatisticsDetails": {
                return Optional.ofNullable(clazz.cast(this.statisticsDetails()));
            }
            case "MetricQuery": {
                return Optional.ofNullable(clazz.cast(this.metricQuery()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("References", REFERENCES_FIELD);
        map.put("StatisticsDetails", STATISTICS_DETAILS_FIELD);
        map.put("MetricQuery", METRIC_QUERY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Metric, T> g) {
        return obj -> g.apply((Metric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<MetricReference> references = DefaultSdkAutoConstructList.getInstance();
        private String statisticsDetails;
        private MetricQuery metricQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(Metric model) {
            this.name(model.name);
            this.references(model.references);
            this.statisticsDetails(model.statisticsDetails);
            this.metricQuery(model.metricQuery);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<MetricReference.Builder> getReferences() {
            List<MetricReference.Builder> result = MetricReferenceListCopier.copyToBuilder(this.references);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferences(Collection<MetricReference.BuilderImpl> references) {
            this.references = MetricReferenceListCopier.copyFromBuilder(references);
        }

        @Override
        public final Builder references(Collection<MetricReference> references) {
            this.references = MetricReferenceListCopier.copy(references);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder references(MetricReference ... references) {
            this.references(Arrays.asList(references));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder references(Consumer<MetricReference.Builder> ... references) {
            this.references(Stream.of(references).map(c -> (MetricReference)((MetricReference.Builder)MetricReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatisticsDetails() {
            return this.statisticsDetails;
        }

        public final void setStatisticsDetails(String statisticsDetails) {
            this.statisticsDetails = statisticsDetails;
        }

        @Override
        public final Builder statisticsDetails(String statisticsDetails) {
            this.statisticsDetails = statisticsDetails;
            return this;
        }

        public final MetricQuery.Builder getMetricQuery() {
            return this.metricQuery != null ? this.metricQuery.toBuilder() : null;
        }

        public final void setMetricQuery(MetricQuery.BuilderImpl metricQuery) {
            this.metricQuery = metricQuery != null ? metricQuery.build() : null;
        }

        @Override
        public final Builder metricQuery(MetricQuery metricQuery) {
            this.metricQuery = metricQuery;
            return this;
        }

        public Metric build() {
            return new Metric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Metric> {
        public Builder name(String var1);

        public Builder references(Collection<MetricReference> var1);

        public Builder references(MetricReference ... var1);

        public Builder references(Consumer<MetricReference.Builder> ... var1);

        public Builder statisticsDetails(String var1);

        public Builder metricQuery(MetricQuery var1);

        default public Builder metricQuery(Consumer<MetricQuery.Builder> metricQuery) {
            return this.metricQuery((MetricQuery)((MetricQuery.Builder)MetricQuery.builder().applyMutation(metricQuery)).build());
        }
    }
}

