/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SwitchoverGlobalClusterRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, SwitchoverGlobalClusterRequest> {
    private static final SdkField<String> GLOBAL_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalClusterIdentifier").getter(SwitchoverGlobalClusterRequest.getter(SwitchoverGlobalClusterRequest::globalClusterIdentifier)).setter(SwitchoverGlobalClusterRequest.setter(Builder::globalClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalClusterIdentifier").build()}).build();
    private static final SdkField<String> TARGET_DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetDbClusterIdentifier").getter(SwitchoverGlobalClusterRequest.getter(SwitchoverGlobalClusterRequest::targetDbClusterIdentifier)).setter(SwitchoverGlobalClusterRequest.setter(Builder::targetDbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDbClusterIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_CLUSTER_IDENTIFIER_FIELD, TARGET_DB_CLUSTER_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SwitchoverGlobalClusterRequest.memberNameToFieldInitializer();
    private final String globalClusterIdentifier;
    private final String targetDbClusterIdentifier;

    private SwitchoverGlobalClusterRequest(BuilderImpl builder) {
        super(builder);
        this.globalClusterIdentifier = builder.globalClusterIdentifier;
        this.targetDbClusterIdentifier = builder.targetDbClusterIdentifier;
    }

    public final String globalClusterIdentifier() {
        return this.globalClusterIdentifier;
    }

    public final String targetDbClusterIdentifier() {
        return this.targetDbClusterIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.globalClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDbClusterIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SwitchoverGlobalClusterRequest)) {
            return false;
        }
        SwitchoverGlobalClusterRequest other = (SwitchoverGlobalClusterRequest)((Object)obj);
        return Objects.equals(this.globalClusterIdentifier(), other.globalClusterIdentifier()) && Objects.equals(this.targetDbClusterIdentifier(), other.targetDbClusterIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"SwitchoverGlobalClusterRequest").add("GlobalClusterIdentifier", (Object)this.globalClusterIdentifier()).add("TargetDbClusterIdentifier", (Object)this.targetDbClusterIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.globalClusterIdentifier()));
            }
            case "TargetDbClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.targetDbClusterIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("GlobalClusterIdentifier", GLOBAL_CLUSTER_IDENTIFIER_FIELD);
        map.put("TargetDbClusterIdentifier", TARGET_DB_CLUSTER_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SwitchoverGlobalClusterRequest, T> g) {
        return obj -> g.apply((SwitchoverGlobalClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String globalClusterIdentifier;
        private String targetDbClusterIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(SwitchoverGlobalClusterRequest model) {
            super(model);
            this.globalClusterIdentifier(model.globalClusterIdentifier);
            this.targetDbClusterIdentifier(model.targetDbClusterIdentifier);
        }

        public final String getGlobalClusterIdentifier() {
            return this.globalClusterIdentifier;
        }

        public final void setGlobalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
        }

        @Override
        public final Builder globalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
            return this;
        }

        public final String getTargetDbClusterIdentifier() {
            return this.targetDbClusterIdentifier;
        }

        public final void setTargetDbClusterIdentifier(String targetDbClusterIdentifier) {
            this.targetDbClusterIdentifier = targetDbClusterIdentifier;
        }

        @Override
        public final Builder targetDbClusterIdentifier(String targetDbClusterIdentifier) {
            this.targetDbClusterIdentifier = targetDbClusterIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SwitchoverGlobalClusterRequest build() {
            return new SwitchoverGlobalClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SwitchoverGlobalClusterRequest> {
        public Builder globalClusterIdentifier(String var1);

        public Builder targetDbClusterIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

