/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DownloadDbLogFilePortionRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, DownloadDbLogFilePortionRequest> {
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBInstanceIdentifier").getter(DownloadDbLogFilePortionRequest.getter(DownloadDbLogFilePortionRequest::dbInstanceIdentifier)).setter(DownloadDbLogFilePortionRequest.setter(Builder::dbInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build()}).build();
    private static final SdkField<String> LOG_FILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogFileName").getter(DownloadDbLogFilePortionRequest.getter(DownloadDbLogFilePortionRequest::logFileName)).setter(DownloadDbLogFilePortionRequest.setter(Builder::logFileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFileName").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DownloadDbLogFilePortionRequest.getter(DownloadDbLogFilePortionRequest::marker)).setter(DownloadDbLogFilePortionRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_LINES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfLines").getter(DownloadDbLogFilePortionRequest.getter(DownloadDbLogFilePortionRequest::numberOfLines)).setter(DownloadDbLogFilePortionRequest.setter(Builder::numberOfLines)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfLines").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_IDENTIFIER_FIELD, LOG_FILE_NAME_FIELD, MARKER_FIELD, NUMBER_OF_LINES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DownloadDbLogFilePortionRequest.memberNameToFieldInitializer();
    private final String dbInstanceIdentifier;
    private final String logFileName;
    private final String marker;
    private final Integer numberOfLines;

    private DownloadDbLogFilePortionRequest(BuilderImpl builder) {
        super(builder);
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.logFileName = builder.logFileName;
        this.marker = builder.marker;
        this.numberOfLines = builder.numberOfLines;
    }

    public final String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public final String logFileName() {
        return this.logFileName;
    }

    public final String marker() {
        return this.marker;
    }

    public final Integer numberOfLines() {
        return this.numberOfLines;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.logFileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfLines());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DownloadDbLogFilePortionRequest)) {
            return false;
        }
        DownloadDbLogFilePortionRequest other = (DownloadDbLogFilePortionRequest)((Object)obj);
        return Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.logFileName(), other.logFileName()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.numberOfLines(), other.numberOfLines());
    }

    public final String toString() {
        return ToString.builder((String)"DownloadDbLogFilePortionRequest").add("DBInstanceIdentifier", (Object)this.dbInstanceIdentifier()).add("LogFileName", (Object)this.logFileName()).add("Marker", (Object)this.marker()).add("NumberOfLines", (Object)this.numberOfLines()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "LogFileName": {
                return Optional.ofNullable(clazz.cast(this.logFileName()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "NumberOfLines": {
                return Optional.ofNullable(clazz.cast(this.numberOfLines()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DBInstanceIdentifier", DB_INSTANCE_IDENTIFIER_FIELD);
        map.put("LogFileName", LOG_FILE_NAME_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("NumberOfLines", NUMBER_OF_LINES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DownloadDbLogFilePortionRequest, T> g) {
        return obj -> g.apply((DownloadDbLogFilePortionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbInstanceIdentifier;
        private String logFileName;
        private String marker;
        private Integer numberOfLines;

        private BuilderImpl() {
        }

        private BuilderImpl(DownloadDbLogFilePortionRequest model) {
            super(model);
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.logFileName(model.logFileName);
            this.marker(model.marker);
            this.numberOfLines(model.numberOfLines);
        }

        public final String getDbInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final String getLogFileName() {
            return this.logFileName;
        }

        public final void setLogFileName(String logFileName) {
            this.logFileName = logFileName;
        }

        @Override
        public final Builder logFileName(String logFileName) {
            this.logFileName = logFileName;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getNumberOfLines() {
            return this.numberOfLines;
        }

        public final void setNumberOfLines(Integer numberOfLines) {
            this.numberOfLines = numberOfLines;
        }

        @Override
        public final Builder numberOfLines(Integer numberOfLines) {
            this.numberOfLines = numberOfLines;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DownloadDbLogFilePortionRequest build() {
            return new DownloadDbLogFilePortionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DownloadDbLogFilePortionRequest> {
        public Builder dbInstanceIdentifier(String var1);

        public Builder logFileName(String var1);

        public Builder marker(String var1);

        public Builder numberOfLines(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

