/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.model.DBSecurityGroup;
import software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsResponse;

public class DescribeDBSecurityGroupsPublisher
implements SdkPublisher<DescribeDbSecurityGroupsResponse> {
    private final RdsAsyncClient client;
    private final DescribeDbSecurityGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBSecurityGroupsPublisher(RdsAsyncClient client, DescribeDbSecurityGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBSecurityGroupsPublisher(RdsAsyncClient client, DescribeDbSecurityGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDbSecurityGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDbSecurityGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DBSecurityGroup> dbSecurityGroups() {
        Function<DescribeDbSecurityGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbSecurityGroups() != null) {
                return response.dbSecurityGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDbSecurityGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeDBSecurityGroupsPublisher resume(DescribeDbSecurityGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDBSecurityGroupsPublisher(this.client, (DescribeDbSecurityGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDBSecurityGroupsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeDbSecurityGroupsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeDbSecurityGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeDbSecurityGroupsResponse> {
        private DescribeDbSecurityGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbSecurityGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeDbSecurityGroupsResponse> nextPage(DescribeDbSecurityGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBSecurityGroupsPublisher.this.client.describeDBSecurityGroups(DescribeDBSecurityGroupsPublisher.this.firstRequest);
            }
            return DescribeDBSecurityGroupsPublisher.this.client.describeDBSecurityGroups((DescribeDbSecurityGroupsRequest)((Object)DescribeDBSecurityGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

