/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteDbInstanceAutomatedBackupRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, DeleteDbInstanceAutomatedBackupRequest> {
    private static final SdkField<String> DBI_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbiResourceId").getter(DeleteDbInstanceAutomatedBackupRequest.getter(DeleteDbInstanceAutomatedBackupRequest::dbiResourceId)).setter(DeleteDbInstanceAutomatedBackupRequest.setter(Builder::dbiResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbiResourceId").build()}).build();
    private static final SdkField<String> DB_INSTANCE_AUTOMATED_BACKUPS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBInstanceAutomatedBackupsArn").getter(DeleteDbInstanceAutomatedBackupRequest.getter(DeleteDbInstanceAutomatedBackupRequest::dbInstanceAutomatedBackupsArn)).setter(DeleteDbInstanceAutomatedBackupRequest.setter(Builder::dbInstanceAutomatedBackupsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceAutomatedBackupsArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DBI_RESOURCE_ID_FIELD, DB_INSTANCE_AUTOMATED_BACKUPS_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteDbInstanceAutomatedBackupRequest.memberNameToFieldInitializer();
    private final String dbiResourceId;
    private final String dbInstanceAutomatedBackupsArn;

    private DeleteDbInstanceAutomatedBackupRequest(BuilderImpl builder) {
        super(builder);
        this.dbiResourceId = builder.dbiResourceId;
        this.dbInstanceAutomatedBackupsArn = builder.dbInstanceAutomatedBackupsArn;
    }

    public final String dbiResourceId() {
        return this.dbiResourceId;
    }

    public final String dbInstanceAutomatedBackupsArn() {
        return this.dbInstanceAutomatedBackupsArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbiResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceAutomatedBackupsArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDbInstanceAutomatedBackupRequest)) {
            return false;
        }
        DeleteDbInstanceAutomatedBackupRequest other = (DeleteDbInstanceAutomatedBackupRequest)((Object)obj);
        return Objects.equals(this.dbiResourceId(), other.dbiResourceId()) && Objects.equals(this.dbInstanceAutomatedBackupsArn(), other.dbInstanceAutomatedBackupsArn());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteDbInstanceAutomatedBackupRequest").add("DbiResourceId", (Object)this.dbiResourceId()).add("DBInstanceAutomatedBackupsArn", (Object)this.dbInstanceAutomatedBackupsArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DbiResourceId": {
                return Optional.ofNullable(clazz.cast(this.dbiResourceId()));
            }
            case "DBInstanceAutomatedBackupsArn": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceAutomatedBackupsArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DbiResourceId", DBI_RESOURCE_ID_FIELD);
        map.put("DBInstanceAutomatedBackupsArn", DB_INSTANCE_AUTOMATED_BACKUPS_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteDbInstanceAutomatedBackupRequest, T> g) {
        return obj -> g.apply((DeleteDbInstanceAutomatedBackupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbiResourceId;
        private String dbInstanceAutomatedBackupsArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDbInstanceAutomatedBackupRequest model) {
            super(model);
            this.dbiResourceId(model.dbiResourceId);
            this.dbInstanceAutomatedBackupsArn(model.dbInstanceAutomatedBackupsArn);
        }

        public final String getDbiResourceId() {
            return this.dbiResourceId;
        }

        public final void setDbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
        }

        @Override
        public final Builder dbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
            return this;
        }

        public final String getDbInstanceAutomatedBackupsArn() {
            return this.dbInstanceAutomatedBackupsArn;
        }

        public final void setDbInstanceAutomatedBackupsArn(String dbInstanceAutomatedBackupsArn) {
            this.dbInstanceAutomatedBackupsArn = dbInstanceAutomatedBackupsArn;
        }

        @Override
        public final Builder dbInstanceAutomatedBackupsArn(String dbInstanceAutomatedBackupsArn) {
            this.dbInstanceAutomatedBackupsArn = dbInstanceAutomatedBackupsArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDbInstanceAutomatedBackupRequest build() {
            return new DeleteDbInstanceAutomatedBackupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteDbInstanceAutomatedBackupRequest> {
        public Builder dbiResourceId(String var1);

        public Builder dbInstanceAutomatedBackupsArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

