/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ActivityStreamStatus {
    STOPPED("stopped"),
    STARTING("starting"),
    STARTED("started"),
    STOPPING("stopping"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ActivityStreamStatus> VALUE_MAP;
    private final String value;

    private ActivityStreamStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActivityStreamStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActivityStreamStatus> knownValues() {
        EnumSet<ActivityStreamStatus> knownValues = EnumSet.allOf(ActivityStreamStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ActivityStreamStatus.class, ActivityStreamStatus::toString);
    }
}

