/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBClusterMember
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBClusterMember> {
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBInstanceIdentifier").getter(DBClusterMember.getter(DBClusterMember::dbInstanceIdentifier)).setter(DBClusterMember.setter(Builder::dbInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build()}).build();
    private static final SdkField<Boolean> IS_CLUSTER_WRITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsClusterWriter").getter(DBClusterMember.getter(DBClusterMember::isClusterWriter)).setter(DBClusterMember.setter(Builder::isClusterWriter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsClusterWriter").build()}).build();
    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterParameterGroupStatus").getter(DBClusterMember.getter(DBClusterMember::dbClusterParameterGroupStatus)).setter(DBClusterMember.setter(Builder::dbClusterParameterGroupStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroupStatus").build()}).build();
    private static final SdkField<Integer> PROMOTION_TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PromotionTier").getter(DBClusterMember.getter(DBClusterMember::promotionTier)).setter(DBClusterMember.setter(Builder::promotionTier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromotionTier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_IDENTIFIER_FIELD, IS_CLUSTER_WRITER_FIELD, DB_CLUSTER_PARAMETER_GROUP_STATUS_FIELD, PROMOTION_TIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DBInstanceIdentifier", DB_INSTANCE_IDENTIFIER_FIELD);
            this.put("IsClusterWriter", IS_CLUSTER_WRITER_FIELD);
            this.put("DBClusterParameterGroupStatus", DB_CLUSTER_PARAMETER_GROUP_STATUS_FIELD);
            this.put("PromotionTier", PROMOTION_TIER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String dbInstanceIdentifier;
    private final Boolean isClusterWriter;
    private final String dbClusterParameterGroupStatus;
    private final Integer promotionTier;

    private DBClusterMember(BuilderImpl builder) {
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.isClusterWriter = builder.isClusterWriter;
        this.dbClusterParameterGroupStatus = builder.dbClusterParameterGroupStatus;
        this.promotionTier = builder.promotionTier;
    }

    public final String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public final Boolean isClusterWriter() {
        return this.isClusterWriter;
    }

    public final String dbClusterParameterGroupStatus() {
        return this.dbClusterParameterGroupStatus;
    }

    public final Integer promotionTier() {
        return this.promotionTier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.isClusterWriter());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterParameterGroupStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.promotionTier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBClusterMember)) {
            return false;
        }
        DBClusterMember other = (DBClusterMember)obj;
        return Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.isClusterWriter(), other.isClusterWriter()) && Objects.equals(this.dbClusterParameterGroupStatus(), other.dbClusterParameterGroupStatus()) && Objects.equals(this.promotionTier(), other.promotionTier());
    }

    public final String toString() {
        return ToString.builder((String)"DBClusterMember").add("DBInstanceIdentifier", (Object)this.dbInstanceIdentifier()).add("IsClusterWriter", (Object)this.isClusterWriter()).add("DBClusterParameterGroupStatus", (Object)this.dbClusterParameterGroupStatus()).add("PromotionTier", (Object)this.promotionTier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "IsClusterWriter": {
                return Optional.ofNullable(clazz.cast(this.isClusterWriter()));
            }
            case "DBClusterParameterGroupStatus": {
                return Optional.ofNullable(clazz.cast(this.dbClusterParameterGroupStatus()));
            }
            case "PromotionTier": {
                return Optional.ofNullable(clazz.cast(this.promotionTier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DBClusterMember, T> g) {
        return obj -> g.apply((DBClusterMember)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dbInstanceIdentifier;
        private Boolean isClusterWriter;
        private String dbClusterParameterGroupStatus;
        private Integer promotionTier;

        private BuilderImpl() {
        }

        private BuilderImpl(DBClusterMember model) {
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.isClusterWriter(model.isClusterWriter);
            this.dbClusterParameterGroupStatus(model.dbClusterParameterGroupStatus);
            this.promotionTier(model.promotionTier);
        }

        public final String getDbInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final Boolean getIsClusterWriter() {
            return this.isClusterWriter;
        }

        public final void setIsClusterWriter(Boolean isClusterWriter) {
            this.isClusterWriter = isClusterWriter;
        }

        @Override
        public final Builder isClusterWriter(Boolean isClusterWriter) {
            this.isClusterWriter = isClusterWriter;
            return this;
        }

        public final String getDbClusterParameterGroupStatus() {
            return this.dbClusterParameterGroupStatus;
        }

        public final void setDbClusterParameterGroupStatus(String dbClusterParameterGroupStatus) {
            this.dbClusterParameterGroupStatus = dbClusterParameterGroupStatus;
        }

        @Override
        public final Builder dbClusterParameterGroupStatus(String dbClusterParameterGroupStatus) {
            this.dbClusterParameterGroupStatus = dbClusterParameterGroupStatus;
            return this;
        }

        public final Integer getPromotionTier() {
            return this.promotionTier;
        }

        public final void setPromotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
        }

        @Override
        public final Builder promotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
            return this;
        }

        public DBClusterMember build() {
            return new DBClusterMember(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBClusterMember> {
        public Builder dbInstanceIdentifier(String var1);

        public Builder isClusterWriter(Boolean var1);

        public Builder dbClusterParameterGroupStatus(String var1);

        public Builder promotionTier(Integer var1);
    }
}

