/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.internal.UserAgentUtils;
import software.amazon.awssdk.services.rds.model.DBClusterAutomatedBackup;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterAutomatedBackupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterAutomatedBackupsResponse;

public class DescribeDBClusterAutomatedBackupsIterable
implements SdkIterable<DescribeDbClusterAutomatedBackupsResponse> {
    private final RdsClient client;
    private final DescribeDbClusterAutomatedBackupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBClusterAutomatedBackupsIterable(RdsClient client, DescribeDbClusterAutomatedBackupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeDbClusterAutomatedBackupsResponseFetcher();
    }

    public Iterator<DescribeDbClusterAutomatedBackupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DBClusterAutomatedBackup> dbClusterAutomatedBackups() {
        Function<DescribeDbClusterAutomatedBackupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbClusterAutomatedBackups() != null) {
                return response.dbClusterAutomatedBackups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDbClusterAutomatedBackupsResponseFetcher
    implements SyncPageFetcher<DescribeDbClusterAutomatedBackupsResponse> {
        private DescribeDbClusterAutomatedBackupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbClusterAutomatedBackupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbClusterAutomatedBackupsResponse nextPage(DescribeDbClusterAutomatedBackupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBClusterAutomatedBackupsIterable.this.client.describeDBClusterAutomatedBackups(DescribeDBClusterAutomatedBackupsIterable.this.firstRequest);
            }
            return DescribeDBClusterAutomatedBackupsIterable.this.client.describeDBClusterAutomatedBackups((DescribeDbClusterAutomatedBackupsRequest)((Object)DescribeDBClusterAutomatedBackupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

