/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteDbClusterRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, DeleteDbClusterRequest> {
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterIdentifier").getter(DeleteDbClusterRequest.getter(DeleteDbClusterRequest::dbClusterIdentifier)).setter(DeleteDbClusterRequest.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build()}).build();
    private static final SdkField<Boolean> SKIP_FINAL_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SkipFinalSnapshot").getter(DeleteDbClusterRequest.getter(DeleteDbClusterRequest::skipFinalSnapshot)).setter(DeleteDbClusterRequest.setter(Builder::skipFinalSnapshot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkipFinalSnapshot").build()}).build();
    private static final SdkField<String> FINAL_DB_SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FinalDBSnapshotIdentifier").getter(DeleteDbClusterRequest.getter(DeleteDbClusterRequest::finalDBSnapshotIdentifier)).setter(DeleteDbClusterRequest.setter(Builder::finalDBSnapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalDBSnapshotIdentifier").build()}).build();
    private static final SdkField<Boolean> DELETE_AUTOMATED_BACKUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteAutomatedBackups").getter(DeleteDbClusterRequest.getter(DeleteDbClusterRequest::deleteAutomatedBackups)).setter(DeleteDbClusterRequest.setter(Builder::deleteAutomatedBackups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteAutomatedBackups").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_IDENTIFIER_FIELD, SKIP_FINAL_SNAPSHOT_FIELD, FINAL_DB_SNAPSHOT_IDENTIFIER_FIELD, DELETE_AUTOMATED_BACKUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DBClusterIdentifier", DB_CLUSTER_IDENTIFIER_FIELD);
            this.put("SkipFinalSnapshot", SKIP_FINAL_SNAPSHOT_FIELD);
            this.put("FinalDBSnapshotIdentifier", FINAL_DB_SNAPSHOT_IDENTIFIER_FIELD);
            this.put("DeleteAutomatedBackups", DELETE_AUTOMATED_BACKUPS_FIELD);
        }
    });
    private final String dbClusterIdentifier;
    private final Boolean skipFinalSnapshot;
    private final String finalDBSnapshotIdentifier;
    private final Boolean deleteAutomatedBackups;

    private DeleteDbClusterRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.skipFinalSnapshot = builder.skipFinalSnapshot;
        this.finalDBSnapshotIdentifier = builder.finalDBSnapshotIdentifier;
        this.deleteAutomatedBackups = builder.deleteAutomatedBackups;
    }

    public final String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public final Boolean skipFinalSnapshot() {
        return this.skipFinalSnapshot;
    }

    public final String finalDBSnapshotIdentifier() {
        return this.finalDBSnapshotIdentifier;
    }

    public final Boolean deleteAutomatedBackups() {
        return this.deleteAutomatedBackups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.skipFinalSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.finalDBSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteAutomatedBackups());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDbClusterRequest)) {
            return false;
        }
        DeleteDbClusterRequest other = (DeleteDbClusterRequest)((Object)obj);
        return Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.skipFinalSnapshot(), other.skipFinalSnapshot()) && Objects.equals(this.finalDBSnapshotIdentifier(), other.finalDBSnapshotIdentifier()) && Objects.equals(this.deleteAutomatedBackups(), other.deleteAutomatedBackups());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteDbClusterRequest").add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("SkipFinalSnapshot", (Object)this.skipFinalSnapshot()).add("FinalDBSnapshotIdentifier", (Object)this.finalDBSnapshotIdentifier()).add("DeleteAutomatedBackups", (Object)this.deleteAutomatedBackups()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "SkipFinalSnapshot": {
                return Optional.ofNullable(clazz.cast(this.skipFinalSnapshot()));
            }
            case "FinalDBSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.finalDBSnapshotIdentifier()));
            }
            case "DeleteAutomatedBackups": {
                return Optional.ofNullable(clazz.cast(this.deleteAutomatedBackups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDbClusterRequest, T> g) {
        return obj -> g.apply((DeleteDbClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbClusterIdentifier;
        private Boolean skipFinalSnapshot;
        private String finalDBSnapshotIdentifier;
        private Boolean deleteAutomatedBackups;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDbClusterRequest model) {
            super(model);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.skipFinalSnapshot(model.skipFinalSnapshot);
            this.finalDBSnapshotIdentifier(model.finalDBSnapshotIdentifier);
            this.deleteAutomatedBackups(model.deleteAutomatedBackups);
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final Boolean getSkipFinalSnapshot() {
            return this.skipFinalSnapshot;
        }

        public final void setSkipFinalSnapshot(Boolean skipFinalSnapshot) {
            this.skipFinalSnapshot = skipFinalSnapshot;
        }

        @Override
        public final Builder skipFinalSnapshot(Boolean skipFinalSnapshot) {
            this.skipFinalSnapshot = skipFinalSnapshot;
            return this;
        }

        public final String getFinalDBSnapshotIdentifier() {
            return this.finalDBSnapshotIdentifier;
        }

        public final void setFinalDBSnapshotIdentifier(String finalDBSnapshotIdentifier) {
            this.finalDBSnapshotIdentifier = finalDBSnapshotIdentifier;
        }

        @Override
        public final Builder finalDBSnapshotIdentifier(String finalDBSnapshotIdentifier) {
            this.finalDBSnapshotIdentifier = finalDBSnapshotIdentifier;
            return this;
        }

        public final Boolean getDeleteAutomatedBackups() {
            return this.deleteAutomatedBackups;
        }

        public final void setDeleteAutomatedBackups(Boolean deleteAutomatedBackups) {
            this.deleteAutomatedBackups = deleteAutomatedBackups;
        }

        @Override
        public final Builder deleteAutomatedBackups(Boolean deleteAutomatedBackups) {
            this.deleteAutomatedBackups = deleteAutomatedBackups;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDbClusterRequest build() {
            return new DeleteDbClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteDbClusterRequest> {
        public Builder dbClusterIdentifier(String var1);

        public Builder skipFinalSnapshot(Boolean var1);

        public Builder finalDBSnapshotIdentifier(String var1);

        public Builder deleteAutomatedBackups(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

