/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBShardGroup;
import software.amazon.awssdk.services.rds.model.DBShardGroupsListCopier;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbShardGroupsResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeDbShardGroupsResponse> {
    private static final SdkField<List<DBShardGroup>> DB_SHARD_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBShardGroups").getter(DescribeDbShardGroupsResponse.getter(DescribeDbShardGroupsResponse::dbShardGroups)).setter(DescribeDbShardGroupsResponse.setter(Builder::dbShardGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBShardGroups").build(), ListTrait.builder().memberLocationName("DBShardGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBShardGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBShardGroup").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeDbShardGroupsResponse.getter(DescribeDbShardGroupsResponse::marker)).setter(DescribeDbShardGroupsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SHARD_GROUPS_FIELD, MARKER_FIELD));
    private final List<DBShardGroup> dbShardGroups;
    private final String marker;

    private DescribeDbShardGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.dbShardGroups = builder.dbShardGroups;
        this.marker = builder.marker;
    }

    public final boolean hasDbShardGroups() {
        return this.dbShardGroups != null && !(this.dbShardGroups instanceof SdkAutoConstructList);
    }

    public final List<DBShardGroup> dbShardGroups() {
        return this.dbShardGroups;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbShardGroups() ? this.dbShardGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbShardGroupsResponse)) {
            return false;
        }
        DescribeDbShardGroupsResponse other = (DescribeDbShardGroupsResponse)((Object)obj);
        return this.hasDbShardGroups() == other.hasDbShardGroups() && Objects.equals(this.dbShardGroups(), other.dbShardGroups()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDbShardGroupsResponse").add("DBShardGroups", this.hasDbShardGroups() ? this.dbShardGroups() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBShardGroups": {
                return Optional.ofNullable(clazz.cast(this.dbShardGroups()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbShardGroupsResponse, T> g) {
        return obj -> g.apply((DescribeDbShardGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private List<DBShardGroup> dbShardGroups = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbShardGroupsResponse model) {
            super(model);
            this.dbShardGroups(model.dbShardGroups);
            this.marker(model.marker);
        }

        public final List<DBShardGroup.Builder> getDbShardGroups() {
            List<DBShardGroup.Builder> result = DBShardGroupsListCopier.copyToBuilder(this.dbShardGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbShardGroups(Collection<DBShardGroup.BuilderImpl> dbShardGroups) {
            this.dbShardGroups = DBShardGroupsListCopier.copyFromBuilder(dbShardGroups);
        }

        @Override
        public final Builder dbShardGroups(Collection<DBShardGroup> dbShardGroups) {
            this.dbShardGroups = DBShardGroupsListCopier.copy(dbShardGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbShardGroups(DBShardGroup ... dbShardGroups) {
            this.dbShardGroups(Arrays.asList(dbShardGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbShardGroups(Consumer<DBShardGroup.Builder> ... dbShardGroups) {
            this.dbShardGroups(Stream.of(dbShardGroups).map(c -> (DBShardGroup)((DBShardGroup.Builder)DBShardGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeDbShardGroupsResponse build() {
            return new DescribeDbShardGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbShardGroupsResponse> {
        public Builder dbShardGroups(Collection<DBShardGroup> var1);

        public Builder dbShardGroups(DBShardGroup ... var1);

        public Builder dbShardGroups(Consumer<DBShardGroup.Builder> ... var1);

        public Builder marker(String var1);
    }
}

