/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.internal.UserAgentUtils;
import software.amazon.awssdk.services.rds.model.DescribeDBLogFilesDetails;
import software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbLogFilesResponse;

public class DescribeDBLogFilesIterable
implements SdkIterable<DescribeDbLogFilesResponse> {
    private final RdsClient client;
    private final DescribeDbLogFilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBLogFilesIterable(RdsClient client, DescribeDbLogFilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeDbLogFilesResponseFetcher();
    }

    public Iterator<DescribeDbLogFilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DescribeDBLogFilesDetails> describeDBLogFiles() {
        Function<DescribeDbLogFilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.describeDBLogFiles() != null) {
                return response.describeDBLogFiles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDbLogFilesResponseFetcher
    implements SyncPageFetcher<DescribeDbLogFilesResponse> {
        private DescribeDbLogFilesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbLogFilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbLogFilesResponse nextPage(DescribeDbLogFilesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBLogFilesIterable.this.client.describeDBLogFiles(DescribeDBLogFilesIterable.this.firstRequest);
            }
            return DescribeDBLogFilesIterable.this.client.describeDBLogFiles((DescribeDbLogFilesRequest)((Object)DescribeDBLogFilesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

