/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClustersResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse;
import software.amazon.awssdk.services.rds.model.DescribeTenantDatabasesRequest;
import software.amazon.awssdk.services.rds.model.DescribeTenantDatabasesResponse;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.waiters.RdsWaiter;
import software.amazon.awssdk.services.rds.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultRdsWaiter
implements RdsWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final RdsClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeDbInstancesResponse> dBInstanceAvailableWaiter;
    private final Waiter<DescribeDbInstancesResponse> dBInstanceDeletedWaiter;
    private final Waiter<DescribeDbSnapshotsResponse> dBSnapshotAvailableWaiter;
    private final Waiter<DescribeDbSnapshotsResponse> dBSnapshotDeletedWaiter;
    private final Waiter<DescribeDbClusterSnapshotsResponse> dBClusterSnapshotAvailableWaiter;
    private final Waiter<DescribeDbClusterSnapshotsResponse> dBClusterSnapshotDeletedWaiter;
    private final Waiter<DescribeDbClustersResponse> dBClusterAvailableWaiter;
    private final Waiter<DescribeDbClustersResponse> dBClusterDeletedWaiter;
    private final Waiter<DescribeTenantDatabasesResponse> tenantDatabaseAvailableWaiter;
    private final Waiter<DescribeTenantDatabasesResponse> tenantDatabaseDeletedWaiter;

    private DefaultRdsWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (RdsClient)RdsClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.dBInstanceAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeDbInstancesResponse.class).acceptors(DefaultRdsWaiter.dBInstanceAvailableWaiterAcceptors())).overrideConfiguration(DefaultRdsWaiter.dBInstanceAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.dBInstanceDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeDbInstancesResponse.class).acceptors(DefaultRdsWaiter.dBInstanceDeletedWaiterAcceptors())).overrideConfiguration(DefaultRdsWaiter.dBInstanceDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.dBSnapshotAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeDbSnapshotsResponse.class).acceptors(DefaultRdsWaiter.dBSnapshotAvailableWaiterAcceptors())).overrideConfiguration(DefaultRdsWaiter.dBSnapshotAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.dBSnapshotDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeDbSnapshotsResponse.class).acceptors(DefaultRdsWaiter.dBSnapshotDeletedWaiterAcceptors())).overrideConfiguration(DefaultRdsWaiter.dBSnapshotDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.dBClusterSnapshotAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeDbClusterSnapshotsResponse.class).acceptors(DefaultRdsWaiter.dBClusterSnapshotAvailableWaiterAcceptors())).overrideConfiguration(DefaultRdsWaiter.dBClusterSnapshotAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.dBClusterSnapshotDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeDbClusterSnapshotsResponse.class).acceptors(DefaultRdsWaiter.dBClusterSnapshotDeletedWaiterAcceptors())).overrideConfiguration(DefaultRdsWaiter.dBClusterSnapshotDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.dBClusterAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeDbClustersResponse.class).acceptors(DefaultRdsWaiter.dBClusterAvailableWaiterAcceptors())).overrideConfiguration(DefaultRdsWaiter.dBClusterAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.dBClusterDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeDbClustersResponse.class).acceptors(DefaultRdsWaiter.dBClusterDeletedWaiterAcceptors())).overrideConfiguration(DefaultRdsWaiter.dBClusterDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.tenantDatabaseAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeTenantDatabasesResponse.class).acceptors(DefaultRdsWaiter.tenantDatabaseAvailableWaiterAcceptors())).overrideConfiguration(DefaultRdsWaiter.tenantDatabaseAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.tenantDatabaseDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeTenantDatabasesResponse.class).acceptors(DefaultRdsWaiter.tenantDatabaseDeletedWaiterAcceptors())).overrideConfiguration(DefaultRdsWaiter.tenantDatabaseDeletedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeDbClustersResponse> waitUntilDBClusterAvailable(DescribeDbClustersRequest describeDbClustersRequest) {
        return this.dBClusterAvailableWaiter.run(() -> this.client.describeDBClusters(this.applyWaitersUserAgent(describeDbClustersRequest)));
    }

    @Override
    public WaiterResponse<DescribeDbClustersResponse> waitUntilDBClusterAvailable(DescribeDbClustersRequest describeDbClustersRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.dBClusterAvailableWaiter.run(() -> this.client.describeDBClusters(this.applyWaitersUserAgent(describeDbClustersRequest)), DefaultRdsWaiter.dBClusterAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeDbClustersResponse> waitUntilDBClusterDeleted(DescribeDbClustersRequest describeDbClustersRequest) {
        return this.dBClusterDeletedWaiter.run(() -> this.client.describeDBClusters(this.applyWaitersUserAgent(describeDbClustersRequest)));
    }

    @Override
    public WaiterResponse<DescribeDbClustersResponse> waitUntilDBClusterDeleted(DescribeDbClustersRequest describeDbClustersRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.dBClusterDeletedWaiter.run(() -> this.client.describeDBClusters(this.applyWaitersUserAgent(describeDbClustersRequest)), DefaultRdsWaiter.dBClusterDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeDbClusterSnapshotsResponse> waitUntilDBClusterSnapshotAvailable(DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest) {
        return this.dBClusterSnapshotAvailableWaiter.run(() -> this.client.describeDBClusterSnapshots(this.applyWaitersUserAgent(describeDbClusterSnapshotsRequest)));
    }

    @Override
    public WaiterResponse<DescribeDbClusterSnapshotsResponse> waitUntilDBClusterSnapshotAvailable(DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.dBClusterSnapshotAvailableWaiter.run(() -> this.client.describeDBClusterSnapshots(this.applyWaitersUserAgent(describeDbClusterSnapshotsRequest)), DefaultRdsWaiter.dBClusterSnapshotAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeDbClusterSnapshotsResponse> waitUntilDBClusterSnapshotDeleted(DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest) {
        return this.dBClusterSnapshotDeletedWaiter.run(() -> this.client.describeDBClusterSnapshots(this.applyWaitersUserAgent(describeDbClusterSnapshotsRequest)));
    }

    @Override
    public WaiterResponse<DescribeDbClusterSnapshotsResponse> waitUntilDBClusterSnapshotDeleted(DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.dBClusterSnapshotDeletedWaiter.run(() -> this.client.describeDBClusterSnapshots(this.applyWaitersUserAgent(describeDbClusterSnapshotsRequest)), DefaultRdsWaiter.dBClusterSnapshotDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeDbInstancesResponse> waitUntilDBInstanceAvailable(DescribeDbInstancesRequest describeDbInstancesRequest) {
        return this.dBInstanceAvailableWaiter.run(() -> this.client.describeDBInstances(this.applyWaitersUserAgent(describeDbInstancesRequest)));
    }

    @Override
    public WaiterResponse<DescribeDbInstancesResponse> waitUntilDBInstanceAvailable(DescribeDbInstancesRequest describeDbInstancesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.dBInstanceAvailableWaiter.run(() -> this.client.describeDBInstances(this.applyWaitersUserAgent(describeDbInstancesRequest)), DefaultRdsWaiter.dBInstanceAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeDbInstancesResponse> waitUntilDBInstanceDeleted(DescribeDbInstancesRequest describeDbInstancesRequest) {
        return this.dBInstanceDeletedWaiter.run(() -> this.client.describeDBInstances(this.applyWaitersUserAgent(describeDbInstancesRequest)));
    }

    @Override
    public WaiterResponse<DescribeDbInstancesResponse> waitUntilDBInstanceDeleted(DescribeDbInstancesRequest describeDbInstancesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.dBInstanceDeletedWaiter.run(() -> this.client.describeDBInstances(this.applyWaitersUserAgent(describeDbInstancesRequest)), DefaultRdsWaiter.dBInstanceDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeDbSnapshotsResponse> waitUntilDBSnapshotAvailable(DescribeDbSnapshotsRequest describeDbSnapshotsRequest) {
        return this.dBSnapshotAvailableWaiter.run(() -> this.client.describeDBSnapshots(this.applyWaitersUserAgent(describeDbSnapshotsRequest)));
    }

    @Override
    public WaiterResponse<DescribeDbSnapshotsResponse> waitUntilDBSnapshotAvailable(DescribeDbSnapshotsRequest describeDbSnapshotsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.dBSnapshotAvailableWaiter.run(() -> this.client.describeDBSnapshots(this.applyWaitersUserAgent(describeDbSnapshotsRequest)), DefaultRdsWaiter.dBSnapshotAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeDbSnapshotsResponse> waitUntilDBSnapshotDeleted(DescribeDbSnapshotsRequest describeDbSnapshotsRequest) {
        return this.dBSnapshotDeletedWaiter.run(() -> this.client.describeDBSnapshots(this.applyWaitersUserAgent(describeDbSnapshotsRequest)));
    }

    @Override
    public WaiterResponse<DescribeDbSnapshotsResponse> waitUntilDBSnapshotDeleted(DescribeDbSnapshotsRequest describeDbSnapshotsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.dBSnapshotDeletedWaiter.run(() -> this.client.describeDBSnapshots(this.applyWaitersUserAgent(describeDbSnapshotsRequest)), DefaultRdsWaiter.dBSnapshotDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeTenantDatabasesResponse> waitUntilTenantDatabaseAvailable(DescribeTenantDatabasesRequest describeTenantDatabasesRequest) {
        return this.tenantDatabaseAvailableWaiter.run(() -> this.client.describeTenantDatabases(this.applyWaitersUserAgent(describeTenantDatabasesRequest)));
    }

    @Override
    public WaiterResponse<DescribeTenantDatabasesResponse> waitUntilTenantDatabaseAvailable(DescribeTenantDatabasesRequest describeTenantDatabasesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.tenantDatabaseAvailableWaiter.run(() -> this.client.describeTenantDatabases(this.applyWaitersUserAgent(describeTenantDatabasesRequest)), DefaultRdsWaiter.tenantDatabaseAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeTenantDatabasesResponse> waitUntilTenantDatabaseDeleted(DescribeTenantDatabasesRequest describeTenantDatabasesRequest) {
        return this.tenantDatabaseDeletedWaiter.run(() -> this.client.describeTenantDatabases(this.applyWaitersUserAgent(describeTenantDatabasesRequest)));
    }

    @Override
    public WaiterResponse<DescribeTenantDatabasesResponse> waitUntilTenantDatabaseDeleted(DescribeTenantDatabasesRequest describeTenantDatabasesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.tenantDatabaseDeletedWaiter.run(() -> this.client.describeTenantDatabases(this.applyWaitersUserAgent(describeTenantDatabasesRequest)), DefaultRdsWaiter.tenantDatabaseDeletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeDbInstancesResponse>> dBInstanceAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeDbInstancesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeDbInstancesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBInstances").flatten().field("DBInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBInstances").flatten().field("DBInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBInstances").flatten().field("DBInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBInstances").flatten().field("DBInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBInstances").flatten().field("DBInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-restore"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBInstances").flatten().field("DBInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-parameters"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeDbInstancesResponse>> dBInstanceDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeDbInstancesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeDbInstancesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("DBInstances").length().compare("==", input.constant(0)).value(), true);
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultRdsWaiter.errorCode(error), "DBInstanceNotFound")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBInstances").flatten().field("DBInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "creating"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBInstances").flatten().field("DBInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "modifying"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBInstances").flatten().field("DBInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "rebooting"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBInstances").flatten().field("DBInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "resetting-master-credentials"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeDbSnapshotsResponse>> dBSnapshotAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeDbSnapshotsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeDbSnapshotsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-restore"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-parameters"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeDbSnapshotsResponse>> dBSnapshotDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeDbSnapshotsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeDbSnapshotsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("DBSnapshots").length().compare("==", input.constant(0)).value(), true);
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultRdsWaiter.errorCode(error), "DBSnapshotNotFound")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "creating"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "modifying"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "rebooting"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "resetting-master-credentials"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeDbClusterSnapshotsResponse>> dBClusterSnapshotAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeDbClusterSnapshotsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeDbClusterSnapshotsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusterSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusterSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusterSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusterSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusterSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-restore"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusterSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-parameters"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeDbClusterSnapshotsResponse>> dBClusterSnapshotDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeDbClusterSnapshotsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeDbClusterSnapshotsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("DBClusterSnapshots").length().compare("==", input.constant(0)).value(), true);
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultRdsWaiter.errorCode(error), "DBClusterSnapshotNotFoundFault")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusterSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "creating"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusterSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "modifying"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusterSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "rebooting"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusterSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "resetting-master-credentials"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeDbClustersResponse>> dBClusterAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeDbClustersResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeDbClustersResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusters").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusters").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusters").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusters").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusters").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-restore"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusters").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-parameters"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeDbClustersResponse>> dBClusterDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeDbClustersResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeDbClustersResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("DBClusters").length().compare("==", input.constant(0)).value(), true);
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultRdsWaiter.errorCode(error), "DBClusterNotFoundFault")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusters").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "creating"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusters").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "modifying"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusters").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "rebooting"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusters").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "resetting-master-credentials"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeTenantDatabasesResponse>> tenantDatabaseAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeTenantDatabasesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeTenantDatabasesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("TenantDatabases").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("TenantDatabases").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("TenantDatabases").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-parameters"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("TenantDatabases").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-restore"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeTenantDatabasesResponse>> tenantDatabaseDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeTenantDatabasesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeTenantDatabasesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("TenantDatabases").length().compare("==", input.constant(0)).value(), true);
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultRdsWaiter.errorCode(error), "DBInstanceNotFoundFault")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration dBInstanceAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration dBInstanceDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration dBSnapshotAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration dBSnapshotDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration dBClusterSnapshotAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration dBClusterSnapshotDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration dBClusterAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration dBClusterDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration tenantDatabaseAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration tenantDatabaseDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static RdsWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends RdsRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((RdsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements RdsWaiter.Builder {
        private RdsClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public RdsWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public RdsWaiter.Builder client(RdsClient client) {
            this.client = client;
            return this;
        }

        @Override
        public RdsWaiter build() {
            return new DefaultRdsWaiter(this);
        }
    }
}

