/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.protocols.query.interceptor.QueryParametersToBodyInterceptor;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rds.DefaultRdsAsyncClient;
import software.amazon.awssdk.services.rds.DefaultRdsBaseClientBuilder;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.RdsAsyncClientBuilder;
import software.amazon.awssdk.services.rds.RdsServiceClientConfiguration;
import software.amazon.awssdk.services.rds.endpoints.RdsEndpointProvider;
import software.amazon.awssdk.services.rds.internal.CopyDbClusterSnapshotPresignInterceptor;
import software.amazon.awssdk.services.rds.internal.CopyDbSnapshotPresignInterceptor;
import software.amazon.awssdk.services.rds.internal.CreateDbClusterPresignInterceptor;
import software.amazon.awssdk.services.rds.internal.CreateDbInstanceReadReplicaPresignInterceptor;
import software.amazon.awssdk.services.rds.internal.RdsPresignInterceptor;
import software.amazon.awssdk.services.rds.internal.StartDbInstanceAutomatedBackupsReplicationPresignInterceptor;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
final class DefaultRdsAsyncClientBuilder
extends DefaultRdsBaseClientBuilder<RdsAsyncClientBuilder, RdsAsyncClient>
implements RdsAsyncClientBuilder {
    DefaultRdsAsyncClientBuilder() {
    }

    @Override
    public DefaultRdsAsyncClientBuilder endpointProvider(RdsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final RdsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        List interceptors = (List)clientConfiguration.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS);
        List<QueryParametersToBodyInterceptor> queryParamsToBodyInterceptor = Collections.singletonList(new QueryParametersToBodyInterceptor());
        ArrayList<RdsPresignInterceptor> customizationInterceptors = new ArrayList<RdsPresignInterceptor>();
        customizationInterceptors.add(new CopyDbClusterSnapshotPresignInterceptor());
        customizationInterceptors.add(new CopyDbSnapshotPresignInterceptor());
        customizationInterceptors.add(new CreateDbClusterPresignInterceptor());
        customizationInterceptors.add(new CreateDbInstanceReadReplicaPresignInterceptor());
        customizationInterceptors.add(new StartDbInstanceAutomatedBackupsReplicationPresignInterceptor());
        interceptors = CollectionUtils.mergeLists(queryParamsToBodyInterceptor, (List)interceptors);
        interceptors = CollectionUtils.mergeLists(customizationInterceptors, (List)interceptors);
        clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS, (Object)interceptors).build();
        DefaultRdsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        RdsServiceClientConfiguration serviceClientConfiguration = RdsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultRdsAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

