/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rds.DefaultRdsBaseClientBuilder;
import software.amazon.awssdk.services.rds.DefaultRdsClient;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.RdsClientBuilder;
import software.amazon.awssdk.services.rds.RdsServiceClientConfiguration;
import software.amazon.awssdk.services.rds.endpoints.RdsEndpointProvider;

@SdkInternalApi
final class DefaultRdsClientBuilder
extends DefaultRdsBaseClientBuilder<RdsClientBuilder, RdsClient>
implements RdsClientBuilder {
    DefaultRdsClientBuilder() {
    }

    @Override
    public DefaultRdsClientBuilder endpointProvider(RdsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final RdsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultRdsClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        RdsServiceClientConfiguration serviceClientConfiguration = RdsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultRdsClient(serviceClientConfiguration, clientConfiguration);
    }
}

