/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBSnapshotAttribute;
import software.amazon.awssdk.services.rds.model.DBSnapshotAttributeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBSnapshotAttributesResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBSnapshotAttributesResult> {
    private static final SdkField<String> DB_SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSnapshotIdentifier").getter(DBSnapshotAttributesResult.getter(DBSnapshotAttributesResult::dbSnapshotIdentifier)).setter(DBSnapshotAttributesResult.setter(Builder::dbSnapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSnapshotIdentifier").build()}).build();
    private static final SdkField<List<DBSnapshotAttribute>> DB_SNAPSHOT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBSnapshotAttributes").getter(DBSnapshotAttributesResult.getter(DBSnapshotAttributesResult::dbSnapshotAttributes)).setter(DBSnapshotAttributesResult.setter(Builder::dbSnapshotAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSnapshotAttributes").build(), ListTrait.builder().memberLocationName("DBSnapshotAttribute").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBSnapshotAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSnapshotAttribute").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SNAPSHOT_IDENTIFIER_FIELD, DB_SNAPSHOT_ATTRIBUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dbSnapshotIdentifier;
    private final List<DBSnapshotAttribute> dbSnapshotAttributes;

    private DBSnapshotAttributesResult(BuilderImpl builder) {
        this.dbSnapshotIdentifier = builder.dbSnapshotIdentifier;
        this.dbSnapshotAttributes = builder.dbSnapshotAttributes;
    }

    public final String dbSnapshotIdentifier() {
        return this.dbSnapshotIdentifier;
    }

    public final boolean hasDbSnapshotAttributes() {
        return this.dbSnapshotAttributes != null && !(this.dbSnapshotAttributes instanceof SdkAutoConstructList);
    }

    public final List<DBSnapshotAttribute> dbSnapshotAttributes() {
        return this.dbSnapshotAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbSnapshotAttributes() ? this.dbSnapshotAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBSnapshotAttributesResult)) {
            return false;
        }
        DBSnapshotAttributesResult other = (DBSnapshotAttributesResult)obj;
        return Objects.equals(this.dbSnapshotIdentifier(), other.dbSnapshotIdentifier()) && this.hasDbSnapshotAttributes() == other.hasDbSnapshotAttributes() && Objects.equals(this.dbSnapshotAttributes(), other.dbSnapshotAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"DBSnapshotAttributesResult").add("DBSnapshotIdentifier", (Object)this.dbSnapshotIdentifier()).add("DBSnapshotAttributes", this.hasDbSnapshotAttributes() ? this.dbSnapshotAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbSnapshotIdentifier()));
            }
            case "DBSnapshotAttributes": {
                return Optional.ofNullable(clazz.cast(this.dbSnapshotAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBSnapshotAttributesResult, T> g) {
        return obj -> g.apply((DBSnapshotAttributesResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dbSnapshotIdentifier;
        private List<DBSnapshotAttribute> dbSnapshotAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DBSnapshotAttributesResult model) {
            this.dbSnapshotIdentifier(model.dbSnapshotIdentifier);
            this.dbSnapshotAttributes(model.dbSnapshotAttributes);
        }

        public final String getDbSnapshotIdentifier() {
            return this.dbSnapshotIdentifier;
        }

        public final void setDbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
        }

        @Override
        public final Builder dbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
            return this;
        }

        public final List<DBSnapshotAttribute.Builder> getDbSnapshotAttributes() {
            List<DBSnapshotAttribute.Builder> result = DBSnapshotAttributeListCopier.copyToBuilder(this.dbSnapshotAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbSnapshotAttributes(Collection<DBSnapshotAttribute.BuilderImpl> dbSnapshotAttributes) {
            this.dbSnapshotAttributes = DBSnapshotAttributeListCopier.copyFromBuilder(dbSnapshotAttributes);
        }

        @Override
        public final Builder dbSnapshotAttributes(Collection<DBSnapshotAttribute> dbSnapshotAttributes) {
            this.dbSnapshotAttributes = DBSnapshotAttributeListCopier.copy(dbSnapshotAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSnapshotAttributes(DBSnapshotAttribute ... dbSnapshotAttributes) {
            this.dbSnapshotAttributes(Arrays.asList(dbSnapshotAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSnapshotAttributes(Consumer<DBSnapshotAttribute.Builder> ... dbSnapshotAttributes) {
            this.dbSnapshotAttributes(Stream.of(dbSnapshotAttributes).map(c -> (DBSnapshotAttribute)((DBSnapshotAttribute.Builder)DBSnapshotAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DBSnapshotAttributesResult build() {
            return new DBSnapshotAttributesResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBSnapshotAttributesResult> {
        public Builder dbSnapshotIdentifier(String var1);

        public Builder dbSnapshotAttributes(Collection<DBSnapshotAttribute> var1);

        public Builder dbSnapshotAttributes(DBSnapshotAttribute ... var1);

        public Builder dbSnapshotAttributes(Consumer<DBSnapshotAttribute.Builder> ... var1);
    }
}

