/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.model.BlueGreenDeployment;
import software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsRequest;
import software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsResponse;

public class DescribeBlueGreenDeploymentsPublisher
implements SdkPublisher<DescribeBlueGreenDeploymentsResponse> {
    private final RdsAsyncClient client;
    private final DescribeBlueGreenDeploymentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeBlueGreenDeploymentsPublisher(RdsAsyncClient client, DescribeBlueGreenDeploymentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeBlueGreenDeploymentsPublisher(RdsAsyncClient client, DescribeBlueGreenDeploymentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeBlueGreenDeploymentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeBlueGreenDeploymentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BlueGreenDeployment> blueGreenDeployments() {
        Function<DescribeBlueGreenDeploymentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.blueGreenDeployments() != null) {
                return response.blueGreenDeployments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeBlueGreenDeploymentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeBlueGreenDeploymentsResponseFetcher
    implements AsyncPageFetcher<DescribeBlueGreenDeploymentsResponse> {
        private DescribeBlueGreenDeploymentsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeBlueGreenDeploymentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeBlueGreenDeploymentsResponse> nextPage(DescribeBlueGreenDeploymentsResponse previousPage) {
            if (previousPage == null) {
                return DescribeBlueGreenDeploymentsPublisher.this.client.describeBlueGreenDeployments(DescribeBlueGreenDeploymentsPublisher.this.firstRequest);
            }
            return DescribeBlueGreenDeploymentsPublisher.this.client.describeBlueGreenDeployments((DescribeBlueGreenDeploymentsRequest)((Object)DescribeBlueGreenDeploymentsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

