/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class GenerateAuthenticationTokenRequest
implements ToCopyableBuilder<Builder, GenerateAuthenticationTokenRequest> {
    private final String hostname;
    private final int port;
    private final String username;
    private final Region region;
    private final AwsCredentialsProvider credentialsProvider;

    private GenerateAuthenticationTokenRequest(BuilderImpl builder) {
        this.hostname = (String)Validate.notEmpty((CharSequence)builder.hostname, (String)"hostname", (Object[])new Object[0]);
        this.port = Validate.isPositive((int)builder.port, (String)"port");
        this.username = (String)Validate.notEmpty((CharSequence)builder.username, (String)"username", (Object[])new Object[0]);
        this.region = builder.region;
        this.credentialsProvider = builder.credentialsProvider;
    }

    public String hostname() {
        return this.hostname;
    }

    public int port() {
        return this.port;
    }

    public String username() {
        return this.username;
    }

    public Region region() {
        return this.region;
    }

    public AwsCredentialsProvider credentialsProvider() {
        return this.credentialsProvider;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    private static final class BuilderImpl
    implements Builder {
        private String hostname;
        private int port;
        private String username;
        private Region region;
        private AwsCredentialsProvider credentialsProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateAuthenticationTokenRequest request) {
            this.hostname = request.hostname;
            this.port = request.port;
            this.username = request.username;
            this.region = request.region;
            this.credentialsProvider = request.credentialsProvider;
        }

        @Override
        public Builder hostname(String endpoint) {
            this.hostname = endpoint;
            return this;
        }

        @Override
        public Builder port(int port) {
            this.port = port;
            return this;
        }

        @Override
        public Builder username(String userName) {
            this.username = userName;
            return this;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public Builder credentialsProvider(AwsCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        @Override
        public GenerateAuthenticationTokenRequest build() {
            return new GenerateAuthenticationTokenRequest(this);
        }
    }

    @SdkPublicApi
    @NotThreadSafe
    public static interface Builder
    extends CopyableBuilder<Builder, GenerateAuthenticationTokenRequest> {
        public Builder hostname(String var1);

        public Builder port(int var1);

        public Builder username(String var1);

        public Builder region(Region var1);

        public Builder credentialsProvider(AwsCredentialsProvider var1);

        public GenerateAuthenticationTokenRequest build();
    }
}

