/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCustomAvailabilityZoneRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, CreateCustomAvailabilityZoneRequest> {
    private static final SdkField<String> CUSTOM_AVAILABILITY_ZONE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomAvailabilityZoneName").getter(CreateCustomAvailabilityZoneRequest.getter(CreateCustomAvailabilityZoneRequest::customAvailabilityZoneName)).setter(CreateCustomAvailabilityZoneRequest.setter(Builder::customAvailabilityZoneName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAvailabilityZoneName").build()}).build();
    private static final SdkField<String> EXISTING_VPN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExistingVpnId").getter(CreateCustomAvailabilityZoneRequest.getter(CreateCustomAvailabilityZoneRequest::existingVpnId)).setter(CreateCustomAvailabilityZoneRequest.setter(Builder::existingVpnId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExistingVpnId").build()}).build();
    private static final SdkField<String> NEW_VPN_TUNNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NewVpnTunnelName").getter(CreateCustomAvailabilityZoneRequest.getter(CreateCustomAvailabilityZoneRequest::newVpnTunnelName)).setter(CreateCustomAvailabilityZoneRequest.setter(Builder::newVpnTunnelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewVpnTunnelName").build()}).build();
    private static final SdkField<String> VPN_TUNNEL_ORIGINATOR_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpnTunnelOriginatorIP").getter(CreateCustomAvailabilityZoneRequest.getter(CreateCustomAvailabilityZoneRequest::vpnTunnelOriginatorIP)).setter(CreateCustomAvailabilityZoneRequest.setter(Builder::vpnTunnelOriginatorIP)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnTunnelOriginatorIP").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_AVAILABILITY_ZONE_NAME_FIELD, EXISTING_VPN_ID_FIELD, NEW_VPN_TUNNEL_NAME_FIELD, VPN_TUNNEL_ORIGINATOR_IP_FIELD));
    private final String customAvailabilityZoneName;
    private final String existingVpnId;
    private final String newVpnTunnelName;
    private final String vpnTunnelOriginatorIP;

    private CreateCustomAvailabilityZoneRequest(BuilderImpl builder) {
        super(builder);
        this.customAvailabilityZoneName = builder.customAvailabilityZoneName;
        this.existingVpnId = builder.existingVpnId;
        this.newVpnTunnelName = builder.newVpnTunnelName;
        this.vpnTunnelOriginatorIP = builder.vpnTunnelOriginatorIP;
    }

    public final String customAvailabilityZoneName() {
        return this.customAvailabilityZoneName;
    }

    public final String existingVpnId() {
        return this.existingVpnId;
    }

    public final String newVpnTunnelName() {
        return this.newVpnTunnelName;
    }

    public final String vpnTunnelOriginatorIP() {
        return this.vpnTunnelOriginatorIP;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.customAvailabilityZoneName());
        hashCode = 31 * hashCode + Objects.hashCode(this.existingVpnId());
        hashCode = 31 * hashCode + Objects.hashCode(this.newVpnTunnelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnTunnelOriginatorIP());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomAvailabilityZoneRequest)) {
            return false;
        }
        CreateCustomAvailabilityZoneRequest other = (CreateCustomAvailabilityZoneRequest)((Object)obj);
        return Objects.equals(this.customAvailabilityZoneName(), other.customAvailabilityZoneName()) && Objects.equals(this.existingVpnId(), other.existingVpnId()) && Objects.equals(this.newVpnTunnelName(), other.newVpnTunnelName()) && Objects.equals(this.vpnTunnelOriginatorIP(), other.vpnTunnelOriginatorIP());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCustomAvailabilityZoneRequest").add("CustomAvailabilityZoneName", (Object)this.customAvailabilityZoneName()).add("ExistingVpnId", (Object)this.existingVpnId()).add("NewVpnTunnelName", (Object)this.newVpnTunnelName()).add("VpnTunnelOriginatorIP", (Object)this.vpnTunnelOriginatorIP()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomAvailabilityZoneName": {
                return Optional.ofNullable(clazz.cast(this.customAvailabilityZoneName()));
            }
            case "ExistingVpnId": {
                return Optional.ofNullable(clazz.cast(this.existingVpnId()));
            }
            case "NewVpnTunnelName": {
                return Optional.ofNullable(clazz.cast(this.newVpnTunnelName()));
            }
            case "VpnTunnelOriginatorIP": {
                return Optional.ofNullable(clazz.cast(this.vpnTunnelOriginatorIP()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomAvailabilityZoneRequest, T> g) {
        return obj -> g.apply((CreateCustomAvailabilityZoneRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String customAvailabilityZoneName;
        private String existingVpnId;
        private String newVpnTunnelName;
        private String vpnTunnelOriginatorIP;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomAvailabilityZoneRequest model) {
            super(model);
            this.customAvailabilityZoneName(model.customAvailabilityZoneName);
            this.existingVpnId(model.existingVpnId);
            this.newVpnTunnelName(model.newVpnTunnelName);
            this.vpnTunnelOriginatorIP(model.vpnTunnelOriginatorIP);
        }

        public final String getCustomAvailabilityZoneName() {
            return this.customAvailabilityZoneName;
        }

        @Override
        public final Builder customAvailabilityZoneName(String customAvailabilityZoneName) {
            this.customAvailabilityZoneName = customAvailabilityZoneName;
            return this;
        }

        public final void setCustomAvailabilityZoneName(String customAvailabilityZoneName) {
            this.customAvailabilityZoneName = customAvailabilityZoneName;
        }

        public final String getExistingVpnId() {
            return this.existingVpnId;
        }

        @Override
        public final Builder existingVpnId(String existingVpnId) {
            this.existingVpnId = existingVpnId;
            return this;
        }

        public final void setExistingVpnId(String existingVpnId) {
            this.existingVpnId = existingVpnId;
        }

        public final String getNewVpnTunnelName() {
            return this.newVpnTunnelName;
        }

        @Override
        public final Builder newVpnTunnelName(String newVpnTunnelName) {
            this.newVpnTunnelName = newVpnTunnelName;
            return this;
        }

        public final void setNewVpnTunnelName(String newVpnTunnelName) {
            this.newVpnTunnelName = newVpnTunnelName;
        }

        public final String getVpnTunnelOriginatorIP() {
            return this.vpnTunnelOriginatorIP;
        }

        @Override
        public final Builder vpnTunnelOriginatorIP(String vpnTunnelOriginatorIP) {
            this.vpnTunnelOriginatorIP = vpnTunnelOriginatorIP;
            return this;
        }

        public final void setVpnTunnelOriginatorIP(String vpnTunnelOriginatorIP) {
            this.vpnTunnelOriginatorIP = vpnTunnelOriginatorIP;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomAvailabilityZoneRequest build() {
            return new CreateCustomAvailabilityZoneRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCustomAvailabilityZoneRequest> {
        public Builder customAvailabilityZoneName(String var1);

        public Builder existingVpnId(String var1);

        public Builder newVpnTunnelName(String var1);

        public Builder vpnTunnelOriginatorIP(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

