/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.OptionGroup;
import software.amazon.awssdk.services.rds.model.OptionGroupsListCopier;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOptionGroupsResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeOptionGroupsResponse> {
    private static final SdkField<List<OptionGroup>> OPTION_GROUPS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OptionGroupsList").getter(DescribeOptionGroupsResponse.getter(DescribeOptionGroupsResponse::optionGroupsList)).setter(DescribeOptionGroupsResponse.setter(Builder::optionGroupsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupsList").build(), ListTrait.builder().memberLocationName("OptionGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OptionGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroup").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeOptionGroupsResponse.getter(DescribeOptionGroupsResponse::marker)).setter(DescribeOptionGroupsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTION_GROUPS_LIST_FIELD, MARKER_FIELD));
    private final List<OptionGroup> optionGroupsList;
    private final String marker;

    private DescribeOptionGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.optionGroupsList = builder.optionGroupsList;
        this.marker = builder.marker;
    }

    public final boolean hasOptionGroupsList() {
        return this.optionGroupsList != null && !(this.optionGroupsList instanceof SdkAutoConstructList);
    }

    public final List<OptionGroup> optionGroupsList() {
        return this.optionGroupsList;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptionGroupsList() ? this.optionGroupsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOptionGroupsResponse)) {
            return false;
        }
        DescribeOptionGroupsResponse other = (DescribeOptionGroupsResponse)((Object)obj);
        return this.hasOptionGroupsList() == other.hasOptionGroupsList() && Objects.equals(this.optionGroupsList(), other.optionGroupsList()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeOptionGroupsResponse").add("OptionGroupsList", this.hasOptionGroupsList() ? this.optionGroupsList() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OptionGroupsList": {
                return Optional.ofNullable(clazz.cast(this.optionGroupsList()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOptionGroupsResponse, T> g) {
        return obj -> g.apply((DescribeOptionGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private List<OptionGroup> optionGroupsList = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOptionGroupsResponse model) {
            super(model);
            this.optionGroupsList(model.optionGroupsList);
            this.marker(model.marker);
        }

        public final List<OptionGroup.Builder> getOptionGroupsList() {
            List<OptionGroup.Builder> result = OptionGroupsListCopier.copyToBuilder(this.optionGroupsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder optionGroupsList(Collection<OptionGroup> optionGroupsList) {
            this.optionGroupsList = OptionGroupsListCopier.copy(optionGroupsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupsList(OptionGroup ... optionGroupsList) {
            this.optionGroupsList(Arrays.asList(optionGroupsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupsList(Consumer<OptionGroup.Builder> ... optionGroupsList) {
            this.optionGroupsList(Stream.of(optionGroupsList).map(c -> (OptionGroup)((OptionGroup.Builder)OptionGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOptionGroupsList(Collection<OptionGroup.BuilderImpl> optionGroupsList) {
            this.optionGroupsList = OptionGroupsListCopier.copyFromBuilder(optionGroupsList);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeOptionGroupsResponse build() {
            return new DescribeOptionGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOptionGroupsResponse> {
        public Builder optionGroupsList(Collection<OptionGroup> var1);

        public Builder optionGroupsList(OptionGroup ... var1);

        public Builder optionGroupsList(Consumer<OptionGroup.Builder> ... var1);

        public Builder marker(String var1);
    }
}

