/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionRequest;
import software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionResponse;

public class DownloadDBLogFilePortionPublisher
implements SdkPublisher<DownloadDbLogFilePortionResponse> {
    private final RdsAsyncClient client;
    private final DownloadDbLogFilePortionRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DownloadDBLogFilePortionPublisher(RdsAsyncClient client, DownloadDbLogFilePortionRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DownloadDBLogFilePortionPublisher(RdsAsyncClient client, DownloadDbLogFilePortionRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DownloadDbLogFilePortionResponseFetcher();
    }

    public void subscribe(Subscriber<? super DownloadDbLogFilePortionResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DownloadDbLogFilePortionResponseFetcher
    implements AsyncPageFetcher<DownloadDbLogFilePortionResponse> {
        private DownloadDbLogFilePortionResponseFetcher() {
        }

        public boolean hasNextPage(DownloadDbLogFilePortionResponse previousPage) {
            return previousPage.additionalDataPending();
        }

        public CompletableFuture<DownloadDbLogFilePortionResponse> nextPage(DownloadDbLogFilePortionResponse previousPage) {
            if (previousPage == null) {
                return DownloadDBLogFilePortionPublisher.this.client.downloadDBLogFilePortion(DownloadDBLogFilePortionPublisher.this.firstRequest);
            }
            return DownloadDBLogFilePortionPublisher.this.client.downloadDBLogFilePortion((DownloadDbLogFilePortionRequest)((Object)DownloadDBLogFilePortionPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

