/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DBProxy;
import software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse;

public class DescribeDBProxiesIterable
implements SdkIterable<DescribeDbProxiesResponse> {
    private final RdsClient client;
    private final DescribeDbProxiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBProxiesIterable(RdsClient client, DescribeDbProxiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDbProxiesResponseFetcher();
    }

    public Iterator<DescribeDbProxiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DBProxy> dbProxies() {
        Function<DescribeDbProxiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbProxies() != null) {
                return response.dbProxies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDbProxiesResponseFetcher
    implements SyncPageFetcher<DescribeDbProxiesResponse> {
        private DescribeDbProxiesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbProxiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbProxiesResponse nextPage(DescribeDbProxiesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBProxiesIterable.this.client.describeDBProxies(DescribeDBProxiesIterable.this.firstRequest);
            }
            return DescribeDBProxiesIterable.this.client.describeDBProxies((DescribeDbProxiesRequest)((Object)DescribeDBProxiesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

