/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBClusterEndpoint;
import software.amazon.awssdk.services.rds.model.DBClusterEndpointListCopier;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbClusterEndpointsResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeDbClusterEndpointsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeDbClusterEndpointsResponse.getter(DescribeDbClusterEndpointsResponse::marker)).setter(DescribeDbClusterEndpointsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<DBClusterEndpoint>> DB_CLUSTER_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBClusterEndpoints").getter(DescribeDbClusterEndpointsResponse.getter(DescribeDbClusterEndpointsResponse::dbClusterEndpoints)).setter(DescribeDbClusterEndpointsResponse.setter(Builder::dbClusterEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterEndpoints").build(), ListTrait.builder().memberLocationName("DBClusterEndpointList").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBClusterEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterEndpointList").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, DB_CLUSTER_ENDPOINTS_FIELD));
    private final String marker;
    private final List<DBClusterEndpoint> dbClusterEndpoints;

    private DescribeDbClusterEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbClusterEndpoints = builder.dbClusterEndpoints;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasDbClusterEndpoints() {
        return this.dbClusterEndpoints != null && !(this.dbClusterEndpoints instanceof SdkAutoConstructList);
    }

    public final List<DBClusterEndpoint> dbClusterEndpoints() {
        return this.dbClusterEndpoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbClusterEndpoints() ? this.dbClusterEndpoints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbClusterEndpointsResponse)) {
            return false;
        }
        DescribeDbClusterEndpointsResponse other = (DescribeDbClusterEndpointsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasDbClusterEndpoints() == other.hasDbClusterEndpoints() && Objects.equals(this.dbClusterEndpoints(), other.dbClusterEndpoints());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDbClusterEndpointsResponse").add("Marker", (Object)this.marker()).add("DBClusterEndpoints", this.hasDbClusterEndpoints() ? this.dbClusterEndpoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "DBClusterEndpoints": {
                return Optional.ofNullable(clazz.cast(this.dbClusterEndpoints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbClusterEndpointsResponse, T> g) {
        return obj -> g.apply((DescribeDbClusterEndpointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<DBClusterEndpoint> dbClusterEndpoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbClusterEndpointsResponse model) {
            super(model);
            this.marker(model.marker);
            this.dbClusterEndpoints(model.dbClusterEndpoints);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBClusterEndpoint.Builder> getDbClusterEndpoints() {
            if (this.dbClusterEndpoints instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dbClusterEndpoints != null ? (Collection)this.dbClusterEndpoints.stream().map(DBClusterEndpoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbClusterEndpoints(Collection<DBClusterEndpoint> dbClusterEndpoints) {
            this.dbClusterEndpoints = DBClusterEndpointListCopier.copy(dbClusterEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterEndpoints(DBClusterEndpoint ... dbClusterEndpoints) {
            this.dbClusterEndpoints(Arrays.asList(dbClusterEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterEndpoints(Consumer<DBClusterEndpoint.Builder> ... dbClusterEndpoints) {
            this.dbClusterEndpoints(Stream.of(dbClusterEndpoints).map(c -> (DBClusterEndpoint)((DBClusterEndpoint.Builder)DBClusterEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDbClusterEndpoints(Collection<DBClusterEndpoint.BuilderImpl> dbClusterEndpoints) {
            this.dbClusterEndpoints = DBClusterEndpointListCopier.copyFromBuilder(dbClusterEndpoints);
        }

        @Override
        public DescribeDbClusterEndpointsResponse build() {
            return new DescribeDbClusterEndpointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbClusterEndpointsResponse> {
        public Builder marker(String var1);

        public Builder dbClusterEndpoints(Collection<DBClusterEndpoint> var1);

        public Builder dbClusterEndpoints(DBClusterEndpoint ... var1);

        public Builder dbClusterEndpoints(Consumer<DBClusterEndpoint.Builder> ... var1);
    }
}

