/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackupsReplication;
import software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackupsReplicationListCopier;
import software.amazon.awssdk.services.rds.model.DBInstanceRole;
import software.amazon.awssdk.services.rds.model.DBInstanceRolesCopier;
import software.amazon.awssdk.services.rds.model.DBInstanceStatusInfo;
import software.amazon.awssdk.services.rds.model.DBInstanceStatusInfoListCopier;
import software.amazon.awssdk.services.rds.model.DBParameterGroupStatus;
import software.amazon.awssdk.services.rds.model.DBParameterGroupStatusListCopier;
import software.amazon.awssdk.services.rds.model.DBSecurityGroupMembership;
import software.amazon.awssdk.services.rds.model.DBSecurityGroupMembershipListCopier;
import software.amazon.awssdk.services.rds.model.DBSubnetGroup;
import software.amazon.awssdk.services.rds.model.DomainMembership;
import software.amazon.awssdk.services.rds.model.DomainMembershipListCopier;
import software.amazon.awssdk.services.rds.model.Endpoint;
import software.amazon.awssdk.services.rds.model.LogTypeListCopier;
import software.amazon.awssdk.services.rds.model.OptionGroupMembership;
import software.amazon.awssdk.services.rds.model.OptionGroupMembershipListCopier;
import software.amazon.awssdk.services.rds.model.PendingModifiedValues;
import software.amazon.awssdk.services.rds.model.ProcessorFeature;
import software.amazon.awssdk.services.rds.model.ProcessorFeatureListCopier;
import software.amazon.awssdk.services.rds.model.ReadReplicaDBClusterIdentifierListCopier;
import software.amazon.awssdk.services.rds.model.ReadReplicaDBInstanceIdentifierListCopier;
import software.amazon.awssdk.services.rds.model.ReplicaMode;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembership;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembershipListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBInstance> {
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBInstanceIdentifier").getter(DBInstance.getter(DBInstance::dbInstanceIdentifier)).setter(DBInstance.setter(Builder::dbInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build()}).build();
    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBInstanceClass").getter(DBInstance.getter(DBInstance::dbInstanceClass)).setter(DBInstance.setter(Builder::dbInstanceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(DBInstance.getter(DBInstance::engine)).setter(DBInstance.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> DB_INSTANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBInstanceStatus").getter(DBInstance.getter(DBInstance::dbInstanceStatus)).setter(DBInstance.setter(Builder::dbInstanceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceStatus").build()}).build();
    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterUsername").getter(DBInstance.getter(DBInstance::masterUsername)).setter(DBInstance.setter(Builder::masterUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()}).build();
    private static final SdkField<String> DB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBName").getter(DBInstance.getter(DBInstance::dbName)).setter(DBInstance.setter(Builder::dbName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBName").build()}).build();
    private static final SdkField<Endpoint> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Endpoint").getter(DBInstance.getter(DBInstance::endpoint)).setter(DBInstance.setter(Builder::endpoint)).constructor(Endpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocatedStorage").getter(DBInstance.getter(DBInstance::allocatedStorage)).setter(DBInstance.setter(Builder::allocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()}).build();
    private static final SdkField<Instant> INSTANCE_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InstanceCreateTime").getter(DBInstance.getter(DBInstance::instanceCreateTime)).setter(DBInstance.setter(Builder::instanceCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCreateTime").build()}).build();
    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredBackupWindow").getter(DBInstance.getter(DBInstance::preferredBackupWindow)).setter(DBInstance.setter(Builder::preferredBackupWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build()}).build();
    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BackupRetentionPeriod").getter(DBInstance.getter(DBInstance::backupRetentionPeriod)).setter(DBInstance.setter(Builder::backupRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build()}).build();
    private static final SdkField<List<DBSecurityGroupMembership>> DB_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBSecurityGroups").getter(DBInstance.getter(DBInstance::dbSecurityGroups)).setter(DBInstance.setter(Builder::dbSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroups").build(), ListTrait.builder().memberLocationName("DBSecurityGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBSecurityGroupMembership::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroup").build()}).build()).build()}).build();
    private static final SdkField<List<VpcSecurityGroupMembership>> VPC_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroups").getter(DBInstance.getter(DBInstance::vpcSecurityGroups)).setter(DBInstance.setter(Builder::vpcSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroups").build(), ListTrait.builder().memberLocationName("VpcSecurityGroupMembership").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcSecurityGroupMembership::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupMembership").build()}).build()).build()}).build();
    private static final SdkField<List<DBParameterGroupStatus>> DB_PARAMETER_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBParameterGroups").getter(DBInstance.getter(DBInstance::dbParameterGroups)).setter(DBInstance.setter(Builder::dbParameterGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroups").build(), ListTrait.builder().memberLocationName("DBParameterGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBParameterGroupStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroup").build()}).build()).build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(DBInstance.getter(DBInstance::availabilityZone)).setter(DBInstance.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<DBSubnetGroup> DB_SUBNET_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DBSubnetGroup").getter(DBInstance.getter(DBInstance::dbSubnetGroup)).setter(DBInstance.setter(Builder::dbSubnetGroup)).constructor(DBSubnetGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroup").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMaintenanceWindow").getter(DBInstance.getter(DBInstance::preferredMaintenanceWindow)).setter(DBInstance.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<PendingModifiedValues> PENDING_MODIFIED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PendingModifiedValues").getter(DBInstance.getter(DBInstance::pendingModifiedValues)).setter(DBInstance.setter(Builder::pendingModifiedValues)).constructor(PendingModifiedValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingModifiedValues").build()}).build();
    private static final SdkField<Instant> LATEST_RESTORABLE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LatestRestorableTime").getter(DBInstance.getter(DBInstance::latestRestorableTime)).setter(DBInstance.setter(Builder::latestRestorableTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestRestorableTime").build()}).build();
    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MultiAZ").getter(DBInstance.getter(DBInstance::multiAZ)).setter(DBInstance.setter(Builder::multiAZ)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(DBInstance.getter(DBInstance::engineVersion)).setter(DBInstance.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoMinorVersionUpgrade").getter(DBInstance.getter(DBInstance::autoMinorVersionUpgrade)).setter(DBInstance.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build()}).build();
    private static final SdkField<String> READ_REPLICA_SOURCE_DB_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReadReplicaSourceDBInstanceIdentifier").getter(DBInstance.getter(DBInstance::readReplicaSourceDBInstanceIdentifier)).setter(DBInstance.setter(Builder::readReplicaSourceDBInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadReplicaSourceDBInstanceIdentifier").build()}).build();
    private static final SdkField<List<String>> READ_REPLICA_DB_INSTANCE_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReadReplicaDBInstanceIdentifiers").getter(DBInstance.getter(DBInstance::readReplicaDBInstanceIdentifiers)).setter(DBInstance.setter(Builder::readReplicaDBInstanceIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadReplicaDBInstanceIdentifiers").build(), ListTrait.builder().memberLocationName("ReadReplicaDBInstanceIdentifier").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadReplicaDBInstanceIdentifier").build()}).build()).build()}).build();
    private static final SdkField<List<String>> READ_REPLICA_DB_CLUSTER_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReadReplicaDBClusterIdentifiers").getter(DBInstance.getter(DBInstance::readReplicaDBClusterIdentifiers)).setter(DBInstance.setter(Builder::readReplicaDBClusterIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadReplicaDBClusterIdentifiers").build(), ListTrait.builder().memberLocationName("ReadReplicaDBClusterIdentifier").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadReplicaDBClusterIdentifier").build()}).build()).build()}).build();
    private static final SdkField<String> REPLICA_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicaMode").getter(DBInstance.getter(DBInstance::replicaModeAsString)).setter(DBInstance.setter(Builder::replicaMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaMode").build()}).build();
    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseModel").getter(DBInstance.getter(DBInstance::licenseModel)).setter(DBInstance.setter(Builder::licenseModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Iops").getter(DBInstance.getter(DBInstance::iops)).setter(DBInstance.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()}).build();
    private static final SdkField<List<OptionGroupMembership>> OPTION_GROUP_MEMBERSHIPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OptionGroupMemberships").getter(DBInstance.getter(DBInstance::optionGroupMemberships)).setter(DBInstance.setter(Builder::optionGroupMemberships)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupMemberships").build(), ListTrait.builder().memberLocationName("OptionGroupMembership").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OptionGroupMembership::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupMembership").build()}).build()).build()}).build();
    private static final SdkField<String> CHARACTER_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CharacterSetName").getter(DBInstance.getter(DBInstance::characterSetName)).setter(DBInstance.setter(Builder::characterSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterSetName").build()}).build();
    private static final SdkField<String> NCHAR_CHARACTER_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NcharCharacterSetName").getter(DBInstance.getter(DBInstance::ncharCharacterSetName)).setter(DBInstance.setter(Builder::ncharCharacterSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NcharCharacterSetName").build()}).build();
    private static final SdkField<String> SECONDARY_AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecondaryAvailabilityZone").getter(DBInstance.getter(DBInstance::secondaryAvailabilityZone)).setter(DBInstance.setter(Builder::secondaryAvailabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryAvailabilityZone").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PubliclyAccessible").getter(DBInstance.getter(DBInstance::publiclyAccessible)).setter(DBInstance.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build()}).build();
    private static final SdkField<List<DBInstanceStatusInfo>> STATUS_INFOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatusInfos").getter(DBInstance.getter(DBInstance::statusInfos)).setter(DBInstance.setter(Builder::statusInfos)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusInfos").build(), ListTrait.builder().memberLocationName("DBInstanceStatusInfo").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBInstanceStatusInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceStatusInfo").build()}).build()).build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(DBInstance.getter(DBInstance::storageType)).setter(DBInstance.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final SdkField<String> TDE_CREDENTIAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TdeCredentialArn").getter(DBInstance.getter(DBInstance::tdeCredentialArn)).setter(DBInstance.setter(Builder::tdeCredentialArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TdeCredentialArn").build()}).build();
    private static final SdkField<Integer> DB_INSTANCE_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DbInstancePort").getter(DBInstance.getter(DBInstance::dbInstancePort)).setter(DBInstance.setter(Builder::dbInstancePort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbInstancePort").build()}).build();
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterIdentifier").getter(DBInstance.getter(DBInstance::dbClusterIdentifier)).setter(DBInstance.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build()}).build();
    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("StorageEncrypted").getter(DBInstance.getter(DBInstance::storageEncrypted)).setter(DBInstance.setter(Builder::storageEncrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(DBInstance.getter(DBInstance::kmsKeyId)).setter(DBInstance.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> DBI_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbiResourceId").getter(DBInstance.getter(DBInstance::dbiResourceId)).setter(DBInstance.setter(Builder::dbiResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbiResourceId").build()}).build();
    private static final SdkField<String> CA_CERTIFICATE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CACertificateIdentifier").getter(DBInstance.getter(DBInstance::caCertificateIdentifier)).setter(DBInstance.setter(Builder::caCertificateIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CACertificateIdentifier").build()}).build();
    private static final SdkField<List<DomainMembership>> DOMAIN_MEMBERSHIPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DomainMemberships").getter(DBInstance.getter(DBInstance::domainMemberships)).setter(DBInstance.setter(Builder::domainMemberships)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainMemberships").build(), ListTrait.builder().memberLocationName("DomainMembership").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainMembership::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainMembership").build()}).build()).build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToSnapshot").getter(DBInstance.getter(DBInstance::copyTagsToSnapshot)).setter(DBInstance.setter(Builder::copyTagsToSnapshot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build()}).build();
    private static final SdkField<Integer> MONITORING_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MonitoringInterval").getter(DBInstance.getter(DBInstance::monitoringInterval)).setter(DBInstance.setter(Builder::monitoringInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringInterval").build()}).build();
    private static final SdkField<String> ENHANCED_MONITORING_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnhancedMonitoringResourceArn").getter(DBInstance.getter(DBInstance::enhancedMonitoringResourceArn)).setter(DBInstance.setter(Builder::enhancedMonitoringResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnhancedMonitoringResourceArn").build()}).build();
    private static final SdkField<String> MONITORING_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoringRoleArn").getter(DBInstance.getter(DBInstance::monitoringRoleArn)).setter(DBInstance.setter(Builder::monitoringRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringRoleArn").build()}).build();
    private static final SdkField<Integer> PROMOTION_TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PromotionTier").getter(DBInstance.getter(DBInstance::promotionTier)).setter(DBInstance.setter(Builder::promotionTier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromotionTier").build()}).build();
    private static final SdkField<String> DB_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBInstanceArn").getter(DBInstance.getter(DBInstance::dbInstanceArn)).setter(DBInstance.setter(Builder::dbInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceArn").build()}).build();
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Timezone").getter(DBInstance.getter(DBInstance::timezone)).setter(DBInstance.setter(Builder::timezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()}).build();
    private static final SdkField<Boolean> IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IAMDatabaseAuthenticationEnabled").getter(DBInstance.getter(DBInstance::iamDatabaseAuthenticationEnabled)).setter(DBInstance.setter(Builder::iamDatabaseAuthenticationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMDatabaseAuthenticationEnabled").build()}).build();
    private static final SdkField<Boolean> PERFORMANCE_INSIGHTS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PerformanceInsightsEnabled").getter(DBInstance.getter(DBInstance::performanceInsightsEnabled)).setter(DBInstance.setter(Builder::performanceInsightsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsEnabled").build()}).build();
    private static final SdkField<String> PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PerformanceInsightsKMSKeyId").getter(DBInstance.getter(DBInstance::performanceInsightsKMSKeyId)).setter(DBInstance.setter(Builder::performanceInsightsKMSKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsKMSKeyId").build()}).build();
    private static final SdkField<Integer> PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PerformanceInsightsRetentionPeriod").getter(DBInstance.getter(DBInstance::performanceInsightsRetentionPeriod)).setter(DBInstance.setter(Builder::performanceInsightsRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsRetentionPeriod").build()}).build();
    private static final SdkField<List<String>> ENABLED_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnabledCloudwatchLogsExports").getter(DBInstance.getter(DBInstance::enabledCloudwatchLogsExports)).setter(DBInstance.setter(Builder::enabledCloudwatchLogsExports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledCloudwatchLogsExports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ProcessorFeature>> PROCESSOR_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProcessorFeatures").getter(DBInstance.getter(DBInstance::processorFeatures)).setter(DBInstance.setter(Builder::processorFeatures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorFeatures").build(), ListTrait.builder().memberLocationName("ProcessorFeature").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProcessorFeature::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorFeature").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeletionProtection").getter(DBInstance.getter(DBInstance::deletionProtection)).setter(DBInstance.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build()}).build();
    private static final SdkField<List<DBInstanceRole>> ASSOCIATED_ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedRoles").getter(DBInstance.getter(DBInstance::associatedRoles)).setter(DBInstance.setter(Builder::associatedRoles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedRoles").build(), ListTrait.builder().memberLocationName("DBInstanceRole").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBInstanceRole::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceRole").build()}).build()).build()}).build();
    private static final SdkField<Endpoint> LISTENER_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ListenerEndpoint").getter(DBInstance.getter(DBInstance::listenerEndpoint)).setter(DBInstance.setter(Builder::listenerEndpoint)).constructor(Endpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerEndpoint").build()}).build();
    private static final SdkField<Integer> MAX_ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxAllocatedStorage").getter(DBInstance.getter(DBInstance::maxAllocatedStorage)).setter(DBInstance.setter(Builder::maxAllocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAllocatedStorage").build()}).build();
    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagList").getter(DBInstance.getter(DBInstance::tagList)).setter(DBInstance.setter(Builder::tagList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagList").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<List<DBInstanceAutomatedBackupsReplication>> DB_INSTANCE_AUTOMATED_BACKUPS_REPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBInstanceAutomatedBackupsReplications").getter(DBInstance.getter(DBInstance::dbInstanceAutomatedBackupsReplications)).setter(DBInstance.setter(Builder::dbInstanceAutomatedBackupsReplications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceAutomatedBackupsReplications").build(), ListTrait.builder().memberLocationName("DBInstanceAutomatedBackupsReplication").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBInstanceAutomatedBackupsReplication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceAutomatedBackupsReplication").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_IDENTIFIER_FIELD, DB_INSTANCE_CLASS_FIELD, ENGINE_FIELD, DB_INSTANCE_STATUS_FIELD, MASTER_USERNAME_FIELD, DB_NAME_FIELD, ENDPOINT_FIELD, ALLOCATED_STORAGE_FIELD, INSTANCE_CREATE_TIME_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, BACKUP_RETENTION_PERIOD_FIELD, DB_SECURITY_GROUPS_FIELD, VPC_SECURITY_GROUPS_FIELD, DB_PARAMETER_GROUPS_FIELD, AVAILABILITY_ZONE_FIELD, DB_SUBNET_GROUP_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, PENDING_MODIFIED_VALUES_FIELD, LATEST_RESTORABLE_TIME_FIELD, MULTI_AZ_FIELD, ENGINE_VERSION_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, READ_REPLICA_SOURCE_DB_INSTANCE_IDENTIFIER_FIELD, READ_REPLICA_DB_INSTANCE_IDENTIFIERS_FIELD, READ_REPLICA_DB_CLUSTER_IDENTIFIERS_FIELD, REPLICA_MODE_FIELD, LICENSE_MODEL_FIELD, IOPS_FIELD, OPTION_GROUP_MEMBERSHIPS_FIELD, CHARACTER_SET_NAME_FIELD, NCHAR_CHARACTER_SET_NAME_FIELD, SECONDARY_AVAILABILITY_ZONE_FIELD, PUBLICLY_ACCESSIBLE_FIELD, STATUS_INFOS_FIELD, STORAGE_TYPE_FIELD, TDE_CREDENTIAL_ARN_FIELD, DB_INSTANCE_PORT_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, STORAGE_ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, DBI_RESOURCE_ID_FIELD, CA_CERTIFICATE_IDENTIFIER_FIELD, DOMAIN_MEMBERSHIPS_FIELD, COPY_TAGS_TO_SNAPSHOT_FIELD, MONITORING_INTERVAL_FIELD, ENHANCED_MONITORING_RESOURCE_ARN_FIELD, MONITORING_ROLE_ARN_FIELD, PROMOTION_TIER_FIELD, DB_INSTANCE_ARN_FIELD, TIMEZONE_FIELD, IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD, PERFORMANCE_INSIGHTS_ENABLED_FIELD, PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD, PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD, ENABLED_CLOUDWATCH_LOGS_EXPORTS_FIELD, PROCESSOR_FEATURES_FIELD, DELETION_PROTECTION_FIELD, ASSOCIATED_ROLES_FIELD, LISTENER_ENDPOINT_FIELD, MAX_ALLOCATED_STORAGE_FIELD, TAG_LIST_FIELD, DB_INSTANCE_AUTOMATED_BACKUPS_REPLICATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dbInstanceIdentifier;
    private final String dbInstanceClass;
    private final String engine;
    private final String dbInstanceStatus;
    private final String masterUsername;
    private final String dbName;
    private final Endpoint endpoint;
    private final Integer allocatedStorage;
    private final Instant instanceCreateTime;
    private final String preferredBackupWindow;
    private final Integer backupRetentionPeriod;
    private final List<DBSecurityGroupMembership> dbSecurityGroups;
    private final List<VpcSecurityGroupMembership> vpcSecurityGroups;
    private final List<DBParameterGroupStatus> dbParameterGroups;
    private final String availabilityZone;
    private final DBSubnetGroup dbSubnetGroup;
    private final String preferredMaintenanceWindow;
    private final PendingModifiedValues pendingModifiedValues;
    private final Instant latestRestorableTime;
    private final Boolean multiAZ;
    private final String engineVersion;
    private final Boolean autoMinorVersionUpgrade;
    private final String readReplicaSourceDBInstanceIdentifier;
    private final List<String> readReplicaDBInstanceIdentifiers;
    private final List<String> readReplicaDBClusterIdentifiers;
    private final String replicaMode;
    private final String licenseModel;
    private final Integer iops;
    private final List<OptionGroupMembership> optionGroupMemberships;
    private final String characterSetName;
    private final String ncharCharacterSetName;
    private final String secondaryAvailabilityZone;
    private final Boolean publiclyAccessible;
    private final List<DBInstanceStatusInfo> statusInfos;
    private final String storageType;
    private final String tdeCredentialArn;
    private final Integer dbInstancePort;
    private final String dbClusterIdentifier;
    private final Boolean storageEncrypted;
    private final String kmsKeyId;
    private final String dbiResourceId;
    private final String caCertificateIdentifier;
    private final List<DomainMembership> domainMemberships;
    private final Boolean copyTagsToSnapshot;
    private final Integer monitoringInterval;
    private final String enhancedMonitoringResourceArn;
    private final String monitoringRoleArn;
    private final Integer promotionTier;
    private final String dbInstanceArn;
    private final String timezone;
    private final Boolean iamDatabaseAuthenticationEnabled;
    private final Boolean performanceInsightsEnabled;
    private final String performanceInsightsKMSKeyId;
    private final Integer performanceInsightsRetentionPeriod;
    private final List<String> enabledCloudwatchLogsExports;
    private final List<ProcessorFeature> processorFeatures;
    private final Boolean deletionProtection;
    private final List<DBInstanceRole> associatedRoles;
    private final Endpoint listenerEndpoint;
    private final Integer maxAllocatedStorage;
    private final List<Tag> tagList;
    private final List<DBInstanceAutomatedBackupsReplication> dbInstanceAutomatedBackupsReplications;

    private DBInstance(BuilderImpl builder) {
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.engine = builder.engine;
        this.dbInstanceStatus = builder.dbInstanceStatus;
        this.masterUsername = builder.masterUsername;
        this.dbName = builder.dbName;
        this.endpoint = builder.endpoint;
        this.allocatedStorage = builder.allocatedStorage;
        this.instanceCreateTime = builder.instanceCreateTime;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.dbSecurityGroups = builder.dbSecurityGroups;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
        this.dbParameterGroups = builder.dbParameterGroups;
        this.availabilityZone = builder.availabilityZone;
        this.dbSubnetGroup = builder.dbSubnetGroup;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.pendingModifiedValues = builder.pendingModifiedValues;
        this.latestRestorableTime = builder.latestRestorableTime;
        this.multiAZ = builder.multiAZ;
        this.engineVersion = builder.engineVersion;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.readReplicaSourceDBInstanceIdentifier = builder.readReplicaSourceDBInstanceIdentifier;
        this.readReplicaDBInstanceIdentifiers = builder.readReplicaDBInstanceIdentifiers;
        this.readReplicaDBClusterIdentifiers = builder.readReplicaDBClusterIdentifiers;
        this.replicaMode = builder.replicaMode;
        this.licenseModel = builder.licenseModel;
        this.iops = builder.iops;
        this.optionGroupMemberships = builder.optionGroupMemberships;
        this.characterSetName = builder.characterSetName;
        this.ncharCharacterSetName = builder.ncharCharacterSetName;
        this.secondaryAvailabilityZone = builder.secondaryAvailabilityZone;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.statusInfos = builder.statusInfos;
        this.storageType = builder.storageType;
        this.tdeCredentialArn = builder.tdeCredentialArn;
        this.dbInstancePort = builder.dbInstancePort;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.dbiResourceId = builder.dbiResourceId;
        this.caCertificateIdentifier = builder.caCertificateIdentifier;
        this.domainMemberships = builder.domainMemberships;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.monitoringInterval = builder.monitoringInterval;
        this.enhancedMonitoringResourceArn = builder.enhancedMonitoringResourceArn;
        this.monitoringRoleArn = builder.monitoringRoleArn;
        this.promotionTier = builder.promotionTier;
        this.dbInstanceArn = builder.dbInstanceArn;
        this.timezone = builder.timezone;
        this.iamDatabaseAuthenticationEnabled = builder.iamDatabaseAuthenticationEnabled;
        this.performanceInsightsEnabled = builder.performanceInsightsEnabled;
        this.performanceInsightsKMSKeyId = builder.performanceInsightsKMSKeyId;
        this.performanceInsightsRetentionPeriod = builder.performanceInsightsRetentionPeriod;
        this.enabledCloudwatchLogsExports = builder.enabledCloudwatchLogsExports;
        this.processorFeatures = builder.processorFeatures;
        this.deletionProtection = builder.deletionProtection;
        this.associatedRoles = builder.associatedRoles;
        this.listenerEndpoint = builder.listenerEndpoint;
        this.maxAllocatedStorage = builder.maxAllocatedStorage;
        this.tagList = builder.tagList;
        this.dbInstanceAutomatedBackupsReplications = builder.dbInstanceAutomatedBackupsReplications;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public String dbInstanceClass() {
        return this.dbInstanceClass;
    }

    public String engine() {
        return this.engine;
    }

    public String dbInstanceStatus() {
        return this.dbInstanceStatus;
    }

    public String masterUsername() {
        return this.masterUsername;
    }

    public String dbName() {
        return this.dbName;
    }

    public Endpoint endpoint() {
        return this.endpoint;
    }

    public Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public Instant instanceCreateTime() {
        return this.instanceCreateTime;
    }

    public String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public Integer backupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public boolean hasDbSecurityGroups() {
        return this.dbSecurityGroups != null && !(this.dbSecurityGroups instanceof SdkAutoConstructList);
    }

    public List<DBSecurityGroupMembership> dbSecurityGroups() {
        return this.dbSecurityGroups;
    }

    public boolean hasVpcSecurityGroups() {
        return this.vpcSecurityGroups != null && !(this.vpcSecurityGroups instanceof SdkAutoConstructList);
    }

    public List<VpcSecurityGroupMembership> vpcSecurityGroups() {
        return this.vpcSecurityGroups;
    }

    public boolean hasDbParameterGroups() {
        return this.dbParameterGroups != null && !(this.dbParameterGroups instanceof SdkAutoConstructList);
    }

    public List<DBParameterGroupStatus> dbParameterGroups() {
        return this.dbParameterGroups;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public DBSubnetGroup dbSubnetGroup() {
        return this.dbSubnetGroup;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public PendingModifiedValues pendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public Instant latestRestorableTime() {
        return this.latestRestorableTime;
    }

    public Boolean multiAZ() {
        return this.multiAZ;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public String readReplicaSourceDBInstanceIdentifier() {
        return this.readReplicaSourceDBInstanceIdentifier;
    }

    public boolean hasReadReplicaDBInstanceIdentifiers() {
        return this.readReplicaDBInstanceIdentifiers != null && !(this.readReplicaDBInstanceIdentifiers instanceof SdkAutoConstructList);
    }

    public List<String> readReplicaDBInstanceIdentifiers() {
        return this.readReplicaDBInstanceIdentifiers;
    }

    public boolean hasReadReplicaDBClusterIdentifiers() {
        return this.readReplicaDBClusterIdentifiers != null && !(this.readReplicaDBClusterIdentifiers instanceof SdkAutoConstructList);
    }

    public List<String> readReplicaDBClusterIdentifiers() {
        return this.readReplicaDBClusterIdentifiers;
    }

    public ReplicaMode replicaMode() {
        return ReplicaMode.fromValue(this.replicaMode);
    }

    public String replicaModeAsString() {
        return this.replicaMode;
    }

    public String licenseModel() {
        return this.licenseModel;
    }

    public Integer iops() {
        return this.iops;
    }

    public boolean hasOptionGroupMemberships() {
        return this.optionGroupMemberships != null && !(this.optionGroupMemberships instanceof SdkAutoConstructList);
    }

    public List<OptionGroupMembership> optionGroupMemberships() {
        return this.optionGroupMemberships;
    }

    public String characterSetName() {
        return this.characterSetName;
    }

    public String ncharCharacterSetName() {
        return this.ncharCharacterSetName;
    }

    public String secondaryAvailabilityZone() {
        return this.secondaryAvailabilityZone;
    }

    public Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public boolean hasStatusInfos() {
        return this.statusInfos != null && !(this.statusInfos instanceof SdkAutoConstructList);
    }

    public List<DBInstanceStatusInfo> statusInfos() {
        return this.statusInfos;
    }

    public String storageType() {
        return this.storageType;
    }

    public String tdeCredentialArn() {
        return this.tdeCredentialArn;
    }

    public Integer dbInstancePort() {
        return this.dbInstancePort;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public Boolean storageEncrypted() {
        return this.storageEncrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String dbiResourceId() {
        return this.dbiResourceId;
    }

    public String caCertificateIdentifier() {
        return this.caCertificateIdentifier;
    }

    public boolean hasDomainMemberships() {
        return this.domainMemberships != null && !(this.domainMemberships instanceof SdkAutoConstructList);
    }

    public List<DomainMembership> domainMemberships() {
        return this.domainMemberships;
    }

    public Boolean copyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public Integer monitoringInterval() {
        return this.monitoringInterval;
    }

    public String enhancedMonitoringResourceArn() {
        return this.enhancedMonitoringResourceArn;
    }

    public String monitoringRoleArn() {
        return this.monitoringRoleArn;
    }

    public Integer promotionTier() {
        return this.promotionTier;
    }

    public String dbInstanceArn() {
        return this.dbInstanceArn;
    }

    public String timezone() {
        return this.timezone;
    }

    public Boolean iamDatabaseAuthenticationEnabled() {
        return this.iamDatabaseAuthenticationEnabled;
    }

    public Boolean performanceInsightsEnabled() {
        return this.performanceInsightsEnabled;
    }

    public String performanceInsightsKMSKeyId() {
        return this.performanceInsightsKMSKeyId;
    }

    public Integer performanceInsightsRetentionPeriod() {
        return this.performanceInsightsRetentionPeriod;
    }

    public boolean hasEnabledCloudwatchLogsExports() {
        return this.enabledCloudwatchLogsExports != null && !(this.enabledCloudwatchLogsExports instanceof SdkAutoConstructList);
    }

    public List<String> enabledCloudwatchLogsExports() {
        return this.enabledCloudwatchLogsExports;
    }

    public boolean hasProcessorFeatures() {
        return this.processorFeatures != null && !(this.processorFeatures instanceof SdkAutoConstructList);
    }

    public List<ProcessorFeature> processorFeatures() {
        return this.processorFeatures;
    }

    public Boolean deletionProtection() {
        return this.deletionProtection;
    }

    public boolean hasAssociatedRoles() {
        return this.associatedRoles != null && !(this.associatedRoles instanceof SdkAutoConstructList);
    }

    public List<DBInstanceRole> associatedRoles() {
        return this.associatedRoles;
    }

    public Endpoint listenerEndpoint() {
        return this.listenerEndpoint;
    }

    public Integer maxAllocatedStorage() {
        return this.maxAllocatedStorage;
    }

    public boolean hasTagList() {
        return this.tagList != null && !(this.tagList instanceof SdkAutoConstructList);
    }

    public List<Tag> tagList() {
        return this.tagList;
    }

    public boolean hasDbInstanceAutomatedBackupsReplications() {
        return this.dbInstanceAutomatedBackupsReplications != null && !(this.dbInstanceAutomatedBackupsReplications instanceof SdkAutoConstructList);
    }

    public List<DBInstanceAutomatedBackupsReplication> dbInstanceAutomatedBackupsReplications() {
        return this.dbInstanceAutomatedBackupsReplications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbName());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbSecurityGroups() ? this.dbSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroups() ? this.vpcSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbParameterGroups() ? this.dbParameterGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingModifiedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.readReplicaSourceDBInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReadReplicaDBInstanceIdentifiers() ? this.readReplicaDBInstanceIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReadReplicaDBClusterIdentifiers() ? this.readReplicaDBClusterIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptionGroupMemberships() ? this.optionGroupMemberships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.characterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ncharCharacterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusInfos() ? this.statusInfos() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.tdeCredentialArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstancePort());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbiResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.caCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainMemberships() ? this.domainMemberships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedMonitoringResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.promotionTier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamDatabaseAuthenticationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceInsightsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceInsightsKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceInsightsRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnabledCloudwatchLogsExports() ? this.enabledCloudwatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProcessorFeatures() ? this.processorFeatures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedRoles() ? this.associatedRoles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.listenerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAllocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagList() ? this.tagList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbInstanceAutomatedBackupsReplications() ? this.dbInstanceAutomatedBackupsReplications() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBInstance)) {
            return false;
        }
        DBInstance other = (DBInstance)obj;
        return Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.dbInstanceStatus(), other.dbInstanceStatus()) && Objects.equals(this.masterUsername(), other.masterUsername()) && Objects.equals(this.dbName(), other.dbName()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && Objects.equals(this.instanceCreateTime(), other.instanceCreateTime()) && Objects.equals(this.preferredBackupWindow(), other.preferredBackupWindow()) && Objects.equals(this.backupRetentionPeriod(), other.backupRetentionPeriod()) && this.hasDbSecurityGroups() == other.hasDbSecurityGroups() && Objects.equals(this.dbSecurityGroups(), other.dbSecurityGroups()) && this.hasVpcSecurityGroups() == other.hasVpcSecurityGroups() && Objects.equals(this.vpcSecurityGroups(), other.vpcSecurityGroups()) && this.hasDbParameterGroups() == other.hasDbParameterGroups() && Objects.equals(this.dbParameterGroups(), other.dbParameterGroups()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.dbSubnetGroup(), other.dbSubnetGroup()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.pendingModifiedValues(), other.pendingModifiedValues()) && Objects.equals(this.latestRestorableTime(), other.latestRestorableTime()) && Objects.equals(this.multiAZ(), other.multiAZ()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.readReplicaSourceDBInstanceIdentifier(), other.readReplicaSourceDBInstanceIdentifier()) && this.hasReadReplicaDBInstanceIdentifiers() == other.hasReadReplicaDBInstanceIdentifiers() && Objects.equals(this.readReplicaDBInstanceIdentifiers(), other.readReplicaDBInstanceIdentifiers()) && this.hasReadReplicaDBClusterIdentifiers() == other.hasReadReplicaDBClusterIdentifiers() && Objects.equals(this.readReplicaDBClusterIdentifiers(), other.readReplicaDBClusterIdentifiers()) && Objects.equals(this.replicaModeAsString(), other.replicaModeAsString()) && Objects.equals(this.licenseModel(), other.licenseModel()) && Objects.equals(this.iops(), other.iops()) && this.hasOptionGroupMemberships() == other.hasOptionGroupMemberships() && Objects.equals(this.optionGroupMemberships(), other.optionGroupMemberships()) && Objects.equals(this.characterSetName(), other.characterSetName()) && Objects.equals(this.ncharCharacterSetName(), other.ncharCharacterSetName()) && Objects.equals(this.secondaryAvailabilityZone(), other.secondaryAvailabilityZone()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && this.hasStatusInfos() == other.hasStatusInfos() && Objects.equals(this.statusInfos(), other.statusInfos()) && Objects.equals(this.storageType(), other.storageType()) && Objects.equals(this.tdeCredentialArn(), other.tdeCredentialArn()) && Objects.equals(this.dbInstancePort(), other.dbInstancePort()) && Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.storageEncrypted(), other.storageEncrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.dbiResourceId(), other.dbiResourceId()) && Objects.equals(this.caCertificateIdentifier(), other.caCertificateIdentifier()) && this.hasDomainMemberships() == other.hasDomainMemberships() && Objects.equals(this.domainMemberships(), other.domainMemberships()) && Objects.equals(this.copyTagsToSnapshot(), other.copyTagsToSnapshot()) && Objects.equals(this.monitoringInterval(), other.monitoringInterval()) && Objects.equals(this.enhancedMonitoringResourceArn(), other.enhancedMonitoringResourceArn()) && Objects.equals(this.monitoringRoleArn(), other.monitoringRoleArn()) && Objects.equals(this.promotionTier(), other.promotionTier()) && Objects.equals(this.dbInstanceArn(), other.dbInstanceArn()) && Objects.equals(this.timezone(), other.timezone()) && Objects.equals(this.iamDatabaseAuthenticationEnabled(), other.iamDatabaseAuthenticationEnabled()) && Objects.equals(this.performanceInsightsEnabled(), other.performanceInsightsEnabled()) && Objects.equals(this.performanceInsightsKMSKeyId(), other.performanceInsightsKMSKeyId()) && Objects.equals(this.performanceInsightsRetentionPeriod(), other.performanceInsightsRetentionPeriod()) && this.hasEnabledCloudwatchLogsExports() == other.hasEnabledCloudwatchLogsExports() && Objects.equals(this.enabledCloudwatchLogsExports(), other.enabledCloudwatchLogsExports()) && this.hasProcessorFeatures() == other.hasProcessorFeatures() && Objects.equals(this.processorFeatures(), other.processorFeatures()) && Objects.equals(this.deletionProtection(), other.deletionProtection()) && this.hasAssociatedRoles() == other.hasAssociatedRoles() && Objects.equals(this.associatedRoles(), other.associatedRoles()) && Objects.equals(this.listenerEndpoint(), other.listenerEndpoint()) && Objects.equals(this.maxAllocatedStorage(), other.maxAllocatedStorage()) && this.hasTagList() == other.hasTagList() && Objects.equals(this.tagList(), other.tagList()) && this.hasDbInstanceAutomatedBackupsReplications() == other.hasDbInstanceAutomatedBackupsReplications() && Objects.equals(this.dbInstanceAutomatedBackupsReplications(), other.dbInstanceAutomatedBackupsReplications());
    }

    public String toString() {
        return ToString.builder((String)"DBInstance").add("DBInstanceIdentifier", (Object)this.dbInstanceIdentifier()).add("DBInstanceClass", (Object)this.dbInstanceClass()).add("Engine", (Object)this.engine()).add("DBInstanceStatus", (Object)this.dbInstanceStatus()).add("MasterUsername", (Object)this.masterUsername()).add("DBName", (Object)this.dbName()).add("Endpoint", (Object)this.endpoint()).add("AllocatedStorage", (Object)this.allocatedStorage()).add("InstanceCreateTime", (Object)this.instanceCreateTime()).add("PreferredBackupWindow", (Object)this.preferredBackupWindow()).add("BackupRetentionPeriod", (Object)this.backupRetentionPeriod()).add("DBSecurityGroups", this.hasDbSecurityGroups() ? this.dbSecurityGroups() : null).add("VpcSecurityGroups", this.hasVpcSecurityGroups() ? this.vpcSecurityGroups() : null).add("DBParameterGroups", this.hasDbParameterGroups() ? this.dbParameterGroups() : null).add("AvailabilityZone", (Object)this.availabilityZone()).add("DBSubnetGroup", (Object)this.dbSubnetGroup()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("PendingModifiedValues", (Object)this.pendingModifiedValues()).add("LatestRestorableTime", (Object)this.latestRestorableTime()).add("MultiAZ", (Object)this.multiAZ()).add("EngineVersion", (Object)this.engineVersion()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("ReadReplicaSourceDBInstanceIdentifier", (Object)this.readReplicaSourceDBInstanceIdentifier()).add("ReadReplicaDBInstanceIdentifiers", this.hasReadReplicaDBInstanceIdentifiers() ? this.readReplicaDBInstanceIdentifiers() : null).add("ReadReplicaDBClusterIdentifiers", this.hasReadReplicaDBClusterIdentifiers() ? this.readReplicaDBClusterIdentifiers() : null).add("ReplicaMode", (Object)this.replicaModeAsString()).add("LicenseModel", (Object)this.licenseModel()).add("Iops", (Object)this.iops()).add("OptionGroupMemberships", this.hasOptionGroupMemberships() ? this.optionGroupMemberships() : null).add("CharacterSetName", (Object)this.characterSetName()).add("NcharCharacterSetName", (Object)this.ncharCharacterSetName()).add("SecondaryAvailabilityZone", (Object)this.secondaryAvailabilityZone()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("StatusInfos", this.hasStatusInfos() ? this.statusInfos() : null).add("StorageType", (Object)this.storageType()).add("TdeCredentialArn", (Object)this.tdeCredentialArn()).add("DbInstancePort", (Object)this.dbInstancePort()).add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("StorageEncrypted", (Object)this.storageEncrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("DbiResourceId", (Object)this.dbiResourceId()).add("CACertificateIdentifier", (Object)this.caCertificateIdentifier()).add("DomainMemberships", this.hasDomainMemberships() ? this.domainMemberships() : null).add("CopyTagsToSnapshot", (Object)this.copyTagsToSnapshot()).add("MonitoringInterval", (Object)this.monitoringInterval()).add("EnhancedMonitoringResourceArn", (Object)this.enhancedMonitoringResourceArn()).add("MonitoringRoleArn", (Object)this.monitoringRoleArn()).add("PromotionTier", (Object)this.promotionTier()).add("DBInstanceArn", (Object)this.dbInstanceArn()).add("Timezone", (Object)this.timezone()).add("IAMDatabaseAuthenticationEnabled", (Object)this.iamDatabaseAuthenticationEnabled()).add("PerformanceInsightsEnabled", (Object)this.performanceInsightsEnabled()).add("PerformanceInsightsKMSKeyId", (Object)this.performanceInsightsKMSKeyId()).add("PerformanceInsightsRetentionPeriod", (Object)this.performanceInsightsRetentionPeriod()).add("EnabledCloudwatchLogsExports", this.hasEnabledCloudwatchLogsExports() ? this.enabledCloudwatchLogsExports() : null).add("ProcessorFeatures", this.hasProcessorFeatures() ? this.processorFeatures() : null).add("DeletionProtection", (Object)this.deletionProtection()).add("AssociatedRoles", this.hasAssociatedRoles() ? this.associatedRoles() : null).add("ListenerEndpoint", (Object)this.listenerEndpoint()).add("MaxAllocatedStorage", (Object)this.maxAllocatedStorage()).add("TagList", this.hasTagList() ? this.tagList() : null).add("DBInstanceAutomatedBackupsReplications", this.hasDbInstanceAutomatedBackupsReplications() ? this.dbInstanceAutomatedBackupsReplications() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "DBInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceClass()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "DBInstanceStatus": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceStatus()));
            }
            case "MasterUsername": {
                return Optional.ofNullable(clazz.cast(this.masterUsername()));
            }
            case "DBName": {
                return Optional.ofNullable(clazz.cast(this.dbName()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "AllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "InstanceCreateTime": {
                return Optional.ofNullable(clazz.cast(this.instanceCreateTime()));
            }
            case "PreferredBackupWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredBackupWindow()));
            }
            case "BackupRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.backupRetentionPeriod()));
            }
            case "DBSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.dbSecurityGroups()));
            }
            case "VpcSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroups()));
            }
            case "DBParameterGroups": {
                return Optional.ofNullable(clazz.cast(this.dbParameterGroups()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "DBSubnetGroup": {
                return Optional.ofNullable(clazz.cast(this.dbSubnetGroup()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "PendingModifiedValues": {
                return Optional.ofNullable(clazz.cast(this.pendingModifiedValues()));
            }
            case "LatestRestorableTime": {
                return Optional.ofNullable(clazz.cast(this.latestRestorableTime()));
            }
            case "MultiAZ": {
                return Optional.ofNullable(clazz.cast(this.multiAZ()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "ReadReplicaSourceDBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.readReplicaSourceDBInstanceIdentifier()));
            }
            case "ReadReplicaDBInstanceIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.readReplicaDBInstanceIdentifiers()));
            }
            case "ReadReplicaDBClusterIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.readReplicaDBClusterIdentifiers()));
            }
            case "ReplicaMode": {
                return Optional.ofNullable(clazz.cast(this.replicaModeAsString()));
            }
            case "LicenseModel": {
                return Optional.ofNullable(clazz.cast(this.licenseModel()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "OptionGroupMemberships": {
                return Optional.ofNullable(clazz.cast(this.optionGroupMemberships()));
            }
            case "CharacterSetName": {
                return Optional.ofNullable(clazz.cast(this.characterSetName()));
            }
            case "NcharCharacterSetName": {
                return Optional.ofNullable(clazz.cast(this.ncharCharacterSetName()));
            }
            case "SecondaryAvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.secondaryAvailabilityZone()));
            }
            case "PubliclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "StatusInfos": {
                return Optional.ofNullable(clazz.cast(this.statusInfos()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "TdeCredentialArn": {
                return Optional.ofNullable(clazz.cast(this.tdeCredentialArn()));
            }
            case "DbInstancePort": {
                return Optional.ofNullable(clazz.cast(this.dbInstancePort()));
            }
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "StorageEncrypted": {
                return Optional.ofNullable(clazz.cast(this.storageEncrypted()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "DbiResourceId": {
                return Optional.ofNullable(clazz.cast(this.dbiResourceId()));
            }
            case "CACertificateIdentifier": {
                return Optional.ofNullable(clazz.cast(this.caCertificateIdentifier()));
            }
            case "DomainMemberships": {
                return Optional.ofNullable(clazz.cast(this.domainMemberships()));
            }
            case "CopyTagsToSnapshot": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToSnapshot()));
            }
            case "MonitoringInterval": {
                return Optional.ofNullable(clazz.cast(this.monitoringInterval()));
            }
            case "EnhancedMonitoringResourceArn": {
                return Optional.ofNullable(clazz.cast(this.enhancedMonitoringResourceArn()));
            }
            case "MonitoringRoleArn": {
                return Optional.ofNullable(clazz.cast(this.monitoringRoleArn()));
            }
            case "PromotionTier": {
                return Optional.ofNullable(clazz.cast(this.promotionTier()));
            }
            case "DBInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceArn()));
            }
            case "Timezone": {
                return Optional.ofNullable(clazz.cast(this.timezone()));
            }
            case "IAMDatabaseAuthenticationEnabled": {
                return Optional.ofNullable(clazz.cast(this.iamDatabaseAuthenticationEnabled()));
            }
            case "PerformanceInsightsEnabled": {
                return Optional.ofNullable(clazz.cast(this.performanceInsightsEnabled()));
            }
            case "PerformanceInsightsKMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.performanceInsightsKMSKeyId()));
            }
            case "PerformanceInsightsRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.performanceInsightsRetentionPeriod()));
            }
            case "EnabledCloudwatchLogsExports": {
                return Optional.ofNullable(clazz.cast(this.enabledCloudwatchLogsExports()));
            }
            case "ProcessorFeatures": {
                return Optional.ofNullable(clazz.cast(this.processorFeatures()));
            }
            case "DeletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
            case "AssociatedRoles": {
                return Optional.ofNullable(clazz.cast(this.associatedRoles()));
            }
            case "ListenerEndpoint": {
                return Optional.ofNullable(clazz.cast(this.listenerEndpoint()));
            }
            case "MaxAllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.maxAllocatedStorage()));
            }
            case "TagList": {
                return Optional.ofNullable(clazz.cast(this.tagList()));
            }
            case "DBInstanceAutomatedBackupsReplications": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceAutomatedBackupsReplications()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBInstance, T> g) {
        return obj -> g.apply((DBInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dbInstanceIdentifier;
        private String dbInstanceClass;
        private String engine;
        private String dbInstanceStatus;
        private String masterUsername;
        private String dbName;
        private Endpoint endpoint;
        private Integer allocatedStorage;
        private Instant instanceCreateTime;
        private String preferredBackupWindow;
        private Integer backupRetentionPeriod;
        private List<DBSecurityGroupMembership> dbSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private List<VpcSecurityGroupMembership> vpcSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private List<DBParameterGroupStatus> dbParameterGroups = DefaultSdkAutoConstructList.getInstance();
        private String availabilityZone;
        private DBSubnetGroup dbSubnetGroup;
        private String preferredMaintenanceWindow;
        private PendingModifiedValues pendingModifiedValues;
        private Instant latestRestorableTime;
        private Boolean multiAZ;
        private String engineVersion;
        private Boolean autoMinorVersionUpgrade;
        private String readReplicaSourceDBInstanceIdentifier;
        private List<String> readReplicaDBInstanceIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private List<String> readReplicaDBClusterIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private String replicaMode;
        private String licenseModel;
        private Integer iops;
        private List<OptionGroupMembership> optionGroupMemberships = DefaultSdkAutoConstructList.getInstance();
        private String characterSetName;
        private String ncharCharacterSetName;
        private String secondaryAvailabilityZone;
        private Boolean publiclyAccessible;
        private List<DBInstanceStatusInfo> statusInfos = DefaultSdkAutoConstructList.getInstance();
        private String storageType;
        private String tdeCredentialArn;
        private Integer dbInstancePort;
        private String dbClusterIdentifier;
        private Boolean storageEncrypted;
        private String kmsKeyId;
        private String dbiResourceId;
        private String caCertificateIdentifier;
        private List<DomainMembership> domainMemberships = DefaultSdkAutoConstructList.getInstance();
        private Boolean copyTagsToSnapshot;
        private Integer monitoringInterval;
        private String enhancedMonitoringResourceArn;
        private String monitoringRoleArn;
        private Integer promotionTier;
        private String dbInstanceArn;
        private String timezone;
        private Boolean iamDatabaseAuthenticationEnabled;
        private Boolean performanceInsightsEnabled;
        private String performanceInsightsKMSKeyId;
        private Integer performanceInsightsRetentionPeriod;
        private List<String> enabledCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();
        private List<ProcessorFeature> processorFeatures = DefaultSdkAutoConstructList.getInstance();
        private Boolean deletionProtection;
        private List<DBInstanceRole> associatedRoles = DefaultSdkAutoConstructList.getInstance();
        private Endpoint listenerEndpoint;
        private Integer maxAllocatedStorage;
        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();
        private List<DBInstanceAutomatedBackupsReplication> dbInstanceAutomatedBackupsReplications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DBInstance model) {
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.dbInstanceClass(model.dbInstanceClass);
            this.engine(model.engine);
            this.dbInstanceStatus(model.dbInstanceStatus);
            this.masterUsername(model.masterUsername);
            this.dbName(model.dbName);
            this.endpoint(model.endpoint);
            this.allocatedStorage(model.allocatedStorage);
            this.instanceCreateTime(model.instanceCreateTime);
            this.preferredBackupWindow(model.preferredBackupWindow);
            this.backupRetentionPeriod(model.backupRetentionPeriod);
            this.dbSecurityGroups(model.dbSecurityGroups);
            this.vpcSecurityGroups(model.vpcSecurityGroups);
            this.dbParameterGroups(model.dbParameterGroups);
            this.availabilityZone(model.availabilityZone);
            this.dbSubnetGroup(model.dbSubnetGroup);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.pendingModifiedValues(model.pendingModifiedValues);
            this.latestRestorableTime(model.latestRestorableTime);
            this.multiAZ(model.multiAZ);
            this.engineVersion(model.engineVersion);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.readReplicaSourceDBInstanceIdentifier(model.readReplicaSourceDBInstanceIdentifier);
            this.readReplicaDBInstanceIdentifiers(model.readReplicaDBInstanceIdentifiers);
            this.readReplicaDBClusterIdentifiers(model.readReplicaDBClusterIdentifiers);
            this.replicaMode(model.replicaMode);
            this.licenseModel(model.licenseModel);
            this.iops(model.iops);
            this.optionGroupMemberships(model.optionGroupMemberships);
            this.characterSetName(model.characterSetName);
            this.ncharCharacterSetName(model.ncharCharacterSetName);
            this.secondaryAvailabilityZone(model.secondaryAvailabilityZone);
            this.publiclyAccessible(model.publiclyAccessible);
            this.statusInfos(model.statusInfos);
            this.storageType(model.storageType);
            this.tdeCredentialArn(model.tdeCredentialArn);
            this.dbInstancePort(model.dbInstancePort);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.storageEncrypted(model.storageEncrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.dbiResourceId(model.dbiResourceId);
            this.caCertificateIdentifier(model.caCertificateIdentifier);
            this.domainMemberships(model.domainMemberships);
            this.copyTagsToSnapshot(model.copyTagsToSnapshot);
            this.monitoringInterval(model.monitoringInterval);
            this.enhancedMonitoringResourceArn(model.enhancedMonitoringResourceArn);
            this.monitoringRoleArn(model.monitoringRoleArn);
            this.promotionTier(model.promotionTier);
            this.dbInstanceArn(model.dbInstanceArn);
            this.timezone(model.timezone);
            this.iamDatabaseAuthenticationEnabled(model.iamDatabaseAuthenticationEnabled);
            this.performanceInsightsEnabled(model.performanceInsightsEnabled);
            this.performanceInsightsKMSKeyId(model.performanceInsightsKMSKeyId);
            this.performanceInsightsRetentionPeriod(model.performanceInsightsRetentionPeriod);
            this.enabledCloudwatchLogsExports(model.enabledCloudwatchLogsExports);
            this.processorFeatures(model.processorFeatures);
            this.deletionProtection(model.deletionProtection);
            this.associatedRoles(model.associatedRoles);
            this.listenerEndpoint(model.listenerEndpoint);
            this.maxAllocatedStorage(model.maxAllocatedStorage);
            this.tagList(model.tagList);
            this.dbInstanceAutomatedBackupsReplications(model.dbInstanceAutomatedBackupsReplications);
        }

        public final String getDbInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final String getDbInstanceClass() {
            return this.dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getDbInstanceStatus() {
            return this.dbInstanceStatus;
        }

        @Override
        public final Builder dbInstanceStatus(String dbInstanceStatus) {
            this.dbInstanceStatus = dbInstanceStatus;
            return this;
        }

        public final void setDbInstanceStatus(String dbInstanceStatus) {
            this.dbInstanceStatus = dbInstanceStatus;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        public final String getDbName() {
            return this.dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final void setDbName(String dbName) {
            this.dbName = dbName;
        }

        public final Endpoint.Builder getEndpoint() {
            return this.endpoint != null ? this.endpoint.toBuilder() : null;
        }

        @Override
        public final Builder endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(Endpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        public final Instant getInstanceCreateTime() {
            return this.instanceCreateTime;
        }

        @Override
        public final Builder instanceCreateTime(Instant instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
            return this;
        }

        public final void setInstanceCreateTime(Instant instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final Integer getBackupRetentionPeriod() {
            return this.backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        public final Collection<DBSecurityGroupMembership.Builder> getDbSecurityGroups() {
            if (this.dbSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dbSecurityGroups != null ? (Collection)this.dbSecurityGroups.stream().map(DBSecurityGroupMembership::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbSecurityGroups(Collection<DBSecurityGroupMembership> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupMembershipListCopier.copy(dbSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroups(DBSecurityGroupMembership ... dbSecurityGroups) {
            this.dbSecurityGroups(Arrays.asList(dbSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroups(Consumer<DBSecurityGroupMembership.Builder> ... dbSecurityGroups) {
            this.dbSecurityGroups(Stream.of(dbSecurityGroups).map(c -> (DBSecurityGroupMembership)((DBSecurityGroupMembership.Builder)DBSecurityGroupMembership.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDbSecurityGroups(Collection<DBSecurityGroupMembership.BuilderImpl> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupMembershipListCopier.copyFromBuilder(dbSecurityGroups);
        }

        public final Collection<VpcSecurityGroupMembership.Builder> getVpcSecurityGroups() {
            if (this.vpcSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSecurityGroups != null ? (Collection)this.vpcSecurityGroups.stream().map(VpcSecurityGroupMembership::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(VpcSecurityGroupMembership ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder> ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Stream.of(vpcSecurityGroups).map(c -> (VpcSecurityGroupMembership)((VpcSecurityGroupMembership.Builder)VpcSecurityGroupMembership.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership.BuilderImpl> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copyFromBuilder(vpcSecurityGroups);
        }

        public final Collection<DBParameterGroupStatus.Builder> getDbParameterGroups() {
            if (this.dbParameterGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dbParameterGroups != null ? (Collection)this.dbParameterGroups.stream().map(DBParameterGroupStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbParameterGroups(Collection<DBParameterGroupStatus> dbParameterGroups) {
            this.dbParameterGroups = DBParameterGroupStatusListCopier.copy(dbParameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbParameterGroups(DBParameterGroupStatus ... dbParameterGroups) {
            this.dbParameterGroups(Arrays.asList(dbParameterGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbParameterGroups(Consumer<DBParameterGroupStatus.Builder> ... dbParameterGroups) {
            this.dbParameterGroups(Stream.of(dbParameterGroups).map(c -> (DBParameterGroupStatus)((DBParameterGroupStatus.Builder)DBParameterGroupStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDbParameterGroups(Collection<DBParameterGroupStatus.BuilderImpl> dbParameterGroups) {
            this.dbParameterGroups = DBParameterGroupStatusListCopier.copyFromBuilder(dbParameterGroups);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final DBSubnetGroup.Builder getDbSubnetGroup() {
            return this.dbSubnetGroup != null ? this.dbSubnetGroup.toBuilder() : null;
        }

        @Override
        public final Builder dbSubnetGroup(DBSubnetGroup dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup;
            return this;
        }

        public final void setDbSubnetGroup(DBSubnetGroup.BuilderImpl dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup != null ? dbSubnetGroup.build() : null;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final PendingModifiedValues.Builder getPendingModifiedValues() {
            return this.pendingModifiedValues != null ? this.pendingModifiedValues.toBuilder() : null;
        }

        @Override
        public final Builder pendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
            return this;
        }

        public final void setPendingModifiedValues(PendingModifiedValues.BuilderImpl pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues != null ? pendingModifiedValues.build() : null;
        }

        public final Instant getLatestRestorableTime() {
            return this.latestRestorableTime;
        }

        @Override
        public final Builder latestRestorableTime(Instant latestRestorableTime) {
            this.latestRestorableTime = latestRestorableTime;
            return this;
        }

        public final void setLatestRestorableTime(Instant latestRestorableTime) {
            this.latestRestorableTime = latestRestorableTime;
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final String getReadReplicaSourceDBInstanceIdentifier() {
            return this.readReplicaSourceDBInstanceIdentifier;
        }

        @Override
        public final Builder readReplicaSourceDBInstanceIdentifier(String readReplicaSourceDBInstanceIdentifier) {
            this.readReplicaSourceDBInstanceIdentifier = readReplicaSourceDBInstanceIdentifier;
            return this;
        }

        public final void setReadReplicaSourceDBInstanceIdentifier(String readReplicaSourceDBInstanceIdentifier) {
            this.readReplicaSourceDBInstanceIdentifier = readReplicaSourceDBInstanceIdentifier;
        }

        public final Collection<String> getReadReplicaDBInstanceIdentifiers() {
            if (this.readReplicaDBInstanceIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.readReplicaDBInstanceIdentifiers;
        }

        @Override
        public final Builder readReplicaDBInstanceIdentifiers(Collection<String> readReplicaDBInstanceIdentifiers) {
            this.readReplicaDBInstanceIdentifiers = ReadReplicaDBInstanceIdentifierListCopier.copy(readReplicaDBInstanceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readReplicaDBInstanceIdentifiers(String ... readReplicaDBInstanceIdentifiers) {
            this.readReplicaDBInstanceIdentifiers(Arrays.asList(readReplicaDBInstanceIdentifiers));
            return this;
        }

        public final void setReadReplicaDBInstanceIdentifiers(Collection<String> readReplicaDBInstanceIdentifiers) {
            this.readReplicaDBInstanceIdentifiers = ReadReplicaDBInstanceIdentifierListCopier.copy(readReplicaDBInstanceIdentifiers);
        }

        public final Collection<String> getReadReplicaDBClusterIdentifiers() {
            if (this.readReplicaDBClusterIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.readReplicaDBClusterIdentifiers;
        }

        @Override
        public final Builder readReplicaDBClusterIdentifiers(Collection<String> readReplicaDBClusterIdentifiers) {
            this.readReplicaDBClusterIdentifiers = ReadReplicaDBClusterIdentifierListCopier.copy(readReplicaDBClusterIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readReplicaDBClusterIdentifiers(String ... readReplicaDBClusterIdentifiers) {
            this.readReplicaDBClusterIdentifiers(Arrays.asList(readReplicaDBClusterIdentifiers));
            return this;
        }

        public final void setReadReplicaDBClusterIdentifiers(Collection<String> readReplicaDBClusterIdentifiers) {
            this.readReplicaDBClusterIdentifiers = ReadReplicaDBClusterIdentifierListCopier.copy(readReplicaDBClusterIdentifiers);
        }

        public final String getReplicaMode() {
            return this.replicaMode;
        }

        @Override
        public final Builder replicaMode(String replicaMode) {
            this.replicaMode = replicaMode;
            return this;
        }

        @Override
        public final Builder replicaMode(ReplicaMode replicaMode) {
            this.replicaMode(replicaMode == null ? null : replicaMode.toString());
            return this;
        }

        public final void setReplicaMode(String replicaMode) {
            this.replicaMode = replicaMode;
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final Collection<OptionGroupMembership.Builder> getOptionGroupMemberships() {
            if (this.optionGroupMemberships instanceof SdkAutoConstructList) {
                return null;
            }
            return this.optionGroupMemberships != null ? (Collection)this.optionGroupMemberships.stream().map(OptionGroupMembership::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder optionGroupMemberships(Collection<OptionGroupMembership> optionGroupMemberships) {
            this.optionGroupMemberships = OptionGroupMembershipListCopier.copy(optionGroupMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupMemberships(OptionGroupMembership ... optionGroupMemberships) {
            this.optionGroupMemberships(Arrays.asList(optionGroupMemberships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupMemberships(Consumer<OptionGroupMembership.Builder> ... optionGroupMemberships) {
            this.optionGroupMemberships(Stream.of(optionGroupMemberships).map(c -> (OptionGroupMembership)((OptionGroupMembership.Builder)OptionGroupMembership.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOptionGroupMemberships(Collection<OptionGroupMembership.BuilderImpl> optionGroupMemberships) {
            this.optionGroupMemberships = OptionGroupMembershipListCopier.copyFromBuilder(optionGroupMemberships);
        }

        public final String getCharacterSetName() {
            return this.characterSetName;
        }

        @Override
        public final Builder characterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
            return this;
        }

        public final void setCharacterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
        }

        public final String getNcharCharacterSetName() {
            return this.ncharCharacterSetName;
        }

        @Override
        public final Builder ncharCharacterSetName(String ncharCharacterSetName) {
            this.ncharCharacterSetName = ncharCharacterSetName;
            return this;
        }

        public final void setNcharCharacterSetName(String ncharCharacterSetName) {
            this.ncharCharacterSetName = ncharCharacterSetName;
        }

        public final String getSecondaryAvailabilityZone() {
            return this.secondaryAvailabilityZone;
        }

        @Override
        public final Builder secondaryAvailabilityZone(String secondaryAvailabilityZone) {
            this.secondaryAvailabilityZone = secondaryAvailabilityZone;
            return this;
        }

        public final void setSecondaryAvailabilityZone(String secondaryAvailabilityZone) {
            this.secondaryAvailabilityZone = secondaryAvailabilityZone;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final Collection<DBInstanceStatusInfo.Builder> getStatusInfos() {
            if (this.statusInfos instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statusInfos != null ? (Collection)this.statusInfos.stream().map(DBInstanceStatusInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder statusInfos(Collection<DBInstanceStatusInfo> statusInfos) {
            this.statusInfos = DBInstanceStatusInfoListCopier.copy(statusInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusInfos(DBInstanceStatusInfo ... statusInfos) {
            this.statusInfos(Arrays.asList(statusInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusInfos(Consumer<DBInstanceStatusInfo.Builder> ... statusInfos) {
            this.statusInfos(Stream.of(statusInfos).map(c -> (DBInstanceStatusInfo)((DBInstanceStatusInfo.Builder)DBInstanceStatusInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStatusInfos(Collection<DBInstanceStatusInfo.BuilderImpl> statusInfos) {
            this.statusInfos = DBInstanceStatusInfoListCopier.copyFromBuilder(statusInfos);
        }

        public final String getStorageType() {
            return this.storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final String getTdeCredentialArn() {
            return this.tdeCredentialArn;
        }

        @Override
        public final Builder tdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
            return this;
        }

        public final void setTdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
        }

        public final Integer getDbInstancePort() {
            return this.dbInstancePort;
        }

        @Override
        public final Builder dbInstancePort(Integer dbInstancePort) {
            this.dbInstancePort = dbInstancePort;
            return this;
        }

        public final void setDbInstancePort(Integer dbInstancePort) {
            this.dbInstancePort = dbInstancePort;
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final Boolean getStorageEncrypted() {
            return this.storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getDbiResourceId() {
            return this.dbiResourceId;
        }

        @Override
        public final Builder dbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
            return this;
        }

        public final void setDbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
        }

        public final String getCaCertificateIdentifier() {
            return this.caCertificateIdentifier;
        }

        @Override
        public final Builder caCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        public final void setCaCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
        }

        public final Collection<DomainMembership.Builder> getDomainMemberships() {
            if (this.domainMemberships instanceof SdkAutoConstructList) {
                return null;
            }
            return this.domainMemberships != null ? (Collection)this.domainMemberships.stream().map(DomainMembership::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainMemberships(Collection<DomainMembership> domainMemberships) {
            this.domainMemberships = DomainMembershipListCopier.copy(domainMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainMemberships(DomainMembership ... domainMemberships) {
            this.domainMemberships(Arrays.asList(domainMemberships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainMemberships(Consumer<DomainMembership.Builder> ... domainMemberships) {
            this.domainMemberships(Stream.of(domainMemberships).map(c -> (DomainMembership)((DomainMembership.Builder)DomainMembership.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDomainMemberships(Collection<DomainMembership.BuilderImpl> domainMemberships) {
            this.domainMemberships = DomainMembershipListCopier.copyFromBuilder(domainMemberships);
        }

        public final Boolean getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        public final Integer getMonitoringInterval() {
            return this.monitoringInterval;
        }

        @Override
        public final Builder monitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public final void setMonitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
        }

        public final String getEnhancedMonitoringResourceArn() {
            return this.enhancedMonitoringResourceArn;
        }

        @Override
        public final Builder enhancedMonitoringResourceArn(String enhancedMonitoringResourceArn) {
            this.enhancedMonitoringResourceArn = enhancedMonitoringResourceArn;
            return this;
        }

        public final void setEnhancedMonitoringResourceArn(String enhancedMonitoringResourceArn) {
            this.enhancedMonitoringResourceArn = enhancedMonitoringResourceArn;
        }

        public final String getMonitoringRoleArn() {
            return this.monitoringRoleArn;
        }

        @Override
        public final Builder monitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
            return this;
        }

        public final void setMonitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
        }

        public final Integer getPromotionTier() {
            return this.promotionTier;
        }

        @Override
        public final Builder promotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
            return this;
        }

        public final void setPromotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
        }

        public final String getDbInstanceArn() {
            return this.dbInstanceArn;
        }

        @Override
        public final Builder dbInstanceArn(String dbInstanceArn) {
            this.dbInstanceArn = dbInstanceArn;
            return this;
        }

        public final void setDbInstanceArn(String dbInstanceArn) {
            this.dbInstanceArn = dbInstanceArn;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public final Boolean getIamDatabaseAuthenticationEnabled() {
            return this.iamDatabaseAuthenticationEnabled;
        }

        @Override
        public final Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        public final void setIamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
        }

        public final Boolean getPerformanceInsightsEnabled() {
            return this.performanceInsightsEnabled;
        }

        @Override
        public final Builder performanceInsightsEnabled(Boolean performanceInsightsEnabled) {
            this.performanceInsightsEnabled = performanceInsightsEnabled;
            return this;
        }

        public final void setPerformanceInsightsEnabled(Boolean performanceInsightsEnabled) {
            this.performanceInsightsEnabled = performanceInsightsEnabled;
        }

        public final String getPerformanceInsightsKMSKeyId() {
            return this.performanceInsightsKMSKeyId;
        }

        @Override
        public final Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
            return this;
        }

        public final void setPerformanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
        }

        public final Integer getPerformanceInsightsRetentionPeriod() {
            return this.performanceInsightsRetentionPeriod;
        }

        @Override
        public final Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
            return this;
        }

        public final void setPerformanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
        }

        public final Collection<String> getEnabledCloudwatchLogsExports() {
            if (this.enabledCloudwatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enabledCloudwatchLogsExports;
        }

        @Override
        public final Builder enabledCloudwatchLogsExports(Collection<String> enabledCloudwatchLogsExports) {
            this.enabledCloudwatchLogsExports = LogTypeListCopier.copy(enabledCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledCloudwatchLogsExports(String ... enabledCloudwatchLogsExports) {
            this.enabledCloudwatchLogsExports(Arrays.asList(enabledCloudwatchLogsExports));
            return this;
        }

        public final void setEnabledCloudwatchLogsExports(Collection<String> enabledCloudwatchLogsExports) {
            this.enabledCloudwatchLogsExports = LogTypeListCopier.copy(enabledCloudwatchLogsExports);
        }

        public final Collection<ProcessorFeature.Builder> getProcessorFeatures() {
            if (this.processorFeatures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.processorFeatures != null ? (Collection)this.processorFeatures.stream().map(ProcessorFeature::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder processorFeatures(Collection<ProcessorFeature> processorFeatures) {
            this.processorFeatures = ProcessorFeatureListCopier.copy(processorFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processorFeatures(ProcessorFeature ... processorFeatures) {
            this.processorFeatures(Arrays.asList(processorFeatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processorFeatures(Consumer<ProcessorFeature.Builder> ... processorFeatures) {
            this.processorFeatures(Stream.of(processorFeatures).map(c -> (ProcessorFeature)((ProcessorFeature.Builder)ProcessorFeature.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProcessorFeatures(Collection<ProcessorFeature.BuilderImpl> processorFeatures) {
            this.processorFeatures = ProcessorFeatureListCopier.copyFromBuilder(processorFeatures);
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        public final Collection<DBInstanceRole.Builder> getAssociatedRoles() {
            if (this.associatedRoles instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedRoles != null ? (Collection)this.associatedRoles.stream().map(DBInstanceRole::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder associatedRoles(Collection<DBInstanceRole> associatedRoles) {
            this.associatedRoles = DBInstanceRolesCopier.copy(associatedRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRoles(DBInstanceRole ... associatedRoles) {
            this.associatedRoles(Arrays.asList(associatedRoles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRoles(Consumer<DBInstanceRole.Builder> ... associatedRoles) {
            this.associatedRoles(Stream.of(associatedRoles).map(c -> (DBInstanceRole)((DBInstanceRole.Builder)DBInstanceRole.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssociatedRoles(Collection<DBInstanceRole.BuilderImpl> associatedRoles) {
            this.associatedRoles = DBInstanceRolesCopier.copyFromBuilder(associatedRoles);
        }

        public final Endpoint.Builder getListenerEndpoint() {
            return this.listenerEndpoint != null ? this.listenerEndpoint.toBuilder() : null;
        }

        @Override
        public final Builder listenerEndpoint(Endpoint listenerEndpoint) {
            this.listenerEndpoint = listenerEndpoint;
            return this;
        }

        public final void setListenerEndpoint(Endpoint.BuilderImpl listenerEndpoint) {
            this.listenerEndpoint = listenerEndpoint != null ? listenerEndpoint.build() : null;
        }

        public final Integer getMaxAllocatedStorage() {
            return this.maxAllocatedStorage;
        }

        @Override
        public final Builder maxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
            return this;
        }

        public final void setMaxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
        }

        public final Collection<Tag.Builder> getTagList() {
            if (this.tagList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagList != null ? (Collection)this.tagList.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag ... tagList) {
            this.tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder> ... tagList) {
            this.tagList(Stream.of(tagList).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        public final Collection<DBInstanceAutomatedBackupsReplication.Builder> getDbInstanceAutomatedBackupsReplications() {
            if (this.dbInstanceAutomatedBackupsReplications instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dbInstanceAutomatedBackupsReplications != null ? (Collection)this.dbInstanceAutomatedBackupsReplications.stream().map(DBInstanceAutomatedBackupsReplication::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbInstanceAutomatedBackupsReplications(Collection<DBInstanceAutomatedBackupsReplication> dbInstanceAutomatedBackupsReplications) {
            this.dbInstanceAutomatedBackupsReplications = DBInstanceAutomatedBackupsReplicationListCopier.copy(dbInstanceAutomatedBackupsReplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbInstanceAutomatedBackupsReplications(DBInstanceAutomatedBackupsReplication ... dbInstanceAutomatedBackupsReplications) {
            this.dbInstanceAutomatedBackupsReplications(Arrays.asList(dbInstanceAutomatedBackupsReplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbInstanceAutomatedBackupsReplications(Consumer<DBInstanceAutomatedBackupsReplication.Builder> ... dbInstanceAutomatedBackupsReplications) {
            this.dbInstanceAutomatedBackupsReplications(Stream.of(dbInstanceAutomatedBackupsReplications).map(c -> (DBInstanceAutomatedBackupsReplication)((DBInstanceAutomatedBackupsReplication.Builder)DBInstanceAutomatedBackupsReplication.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDbInstanceAutomatedBackupsReplications(Collection<DBInstanceAutomatedBackupsReplication.BuilderImpl> dbInstanceAutomatedBackupsReplications) {
            this.dbInstanceAutomatedBackupsReplications = DBInstanceAutomatedBackupsReplicationListCopier.copyFromBuilder(dbInstanceAutomatedBackupsReplications);
        }

        public DBInstance build() {
            return new DBInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBInstance> {
        public Builder dbInstanceIdentifier(String var1);

        public Builder dbInstanceClass(String var1);

        public Builder engine(String var1);

        public Builder dbInstanceStatus(String var1);

        public Builder masterUsername(String var1);

        public Builder dbName(String var1);

        public Builder endpoint(Endpoint var1);

        default public Builder endpoint(Consumer<Endpoint.Builder> endpoint) {
            return this.endpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation(endpoint)).build());
        }

        public Builder allocatedStorage(Integer var1);

        public Builder instanceCreateTime(Instant var1);

        public Builder preferredBackupWindow(String var1);

        public Builder backupRetentionPeriod(Integer var1);

        public Builder dbSecurityGroups(Collection<DBSecurityGroupMembership> var1);

        public Builder dbSecurityGroups(DBSecurityGroupMembership ... var1);

        public Builder dbSecurityGroups(Consumer<DBSecurityGroupMembership.Builder> ... var1);

        public Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> var1);

        public Builder vpcSecurityGroups(VpcSecurityGroupMembership ... var1);

        public Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder> ... var1);

        public Builder dbParameterGroups(Collection<DBParameterGroupStatus> var1);

        public Builder dbParameterGroups(DBParameterGroupStatus ... var1);

        public Builder dbParameterGroups(Consumer<DBParameterGroupStatus.Builder> ... var1);

        public Builder availabilityZone(String var1);

        public Builder dbSubnetGroup(DBSubnetGroup var1);

        default public Builder dbSubnetGroup(Consumer<DBSubnetGroup.Builder> dbSubnetGroup) {
            return this.dbSubnetGroup((DBSubnetGroup)((DBSubnetGroup.Builder)DBSubnetGroup.builder().applyMutation(dbSubnetGroup)).build());
        }

        public Builder preferredMaintenanceWindow(String var1);

        public Builder pendingModifiedValues(PendingModifiedValues var1);

        default public Builder pendingModifiedValues(Consumer<PendingModifiedValues.Builder> pendingModifiedValues) {
            return this.pendingModifiedValues((PendingModifiedValues)((PendingModifiedValues.Builder)PendingModifiedValues.builder().applyMutation(pendingModifiedValues)).build());
        }

        public Builder latestRestorableTime(Instant var1);

        public Builder multiAZ(Boolean var1);

        public Builder engineVersion(String var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder readReplicaSourceDBInstanceIdentifier(String var1);

        public Builder readReplicaDBInstanceIdentifiers(Collection<String> var1);

        public Builder readReplicaDBInstanceIdentifiers(String ... var1);

        public Builder readReplicaDBClusterIdentifiers(Collection<String> var1);

        public Builder readReplicaDBClusterIdentifiers(String ... var1);

        public Builder replicaMode(String var1);

        public Builder replicaMode(ReplicaMode var1);

        public Builder licenseModel(String var1);

        public Builder iops(Integer var1);

        public Builder optionGroupMemberships(Collection<OptionGroupMembership> var1);

        public Builder optionGroupMemberships(OptionGroupMembership ... var1);

        public Builder optionGroupMemberships(Consumer<OptionGroupMembership.Builder> ... var1);

        public Builder characterSetName(String var1);

        public Builder ncharCharacterSetName(String var1);

        public Builder secondaryAvailabilityZone(String var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder statusInfos(Collection<DBInstanceStatusInfo> var1);

        public Builder statusInfos(DBInstanceStatusInfo ... var1);

        public Builder statusInfos(Consumer<DBInstanceStatusInfo.Builder> ... var1);

        public Builder storageType(String var1);

        public Builder tdeCredentialArn(String var1);

        public Builder dbInstancePort(Integer var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder storageEncrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder dbiResourceId(String var1);

        public Builder caCertificateIdentifier(String var1);

        public Builder domainMemberships(Collection<DomainMembership> var1);

        public Builder domainMemberships(DomainMembership ... var1);

        public Builder domainMemberships(Consumer<DomainMembership.Builder> ... var1);

        public Builder copyTagsToSnapshot(Boolean var1);

        public Builder monitoringInterval(Integer var1);

        public Builder enhancedMonitoringResourceArn(String var1);

        public Builder monitoringRoleArn(String var1);

        public Builder promotionTier(Integer var1);

        public Builder dbInstanceArn(String var1);

        public Builder timezone(String var1);

        public Builder iamDatabaseAuthenticationEnabled(Boolean var1);

        public Builder performanceInsightsEnabled(Boolean var1);

        public Builder performanceInsightsKMSKeyId(String var1);

        public Builder performanceInsightsRetentionPeriod(Integer var1);

        public Builder enabledCloudwatchLogsExports(Collection<String> var1);

        public Builder enabledCloudwatchLogsExports(String ... var1);

        public Builder processorFeatures(Collection<ProcessorFeature> var1);

        public Builder processorFeatures(ProcessorFeature ... var1);

        public Builder processorFeatures(Consumer<ProcessorFeature.Builder> ... var1);

        public Builder deletionProtection(Boolean var1);

        public Builder associatedRoles(Collection<DBInstanceRole> var1);

        public Builder associatedRoles(DBInstanceRole ... var1);

        public Builder associatedRoles(Consumer<DBInstanceRole.Builder> ... var1);

        public Builder listenerEndpoint(Endpoint var1);

        default public Builder listenerEndpoint(Consumer<Endpoint.Builder> listenerEndpoint) {
            return this.listenerEndpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation(listenerEndpoint)).build());
        }

        public Builder maxAllocatedStorage(Integer var1);

        public Builder tagList(Collection<Tag> var1);

        public Builder tagList(Tag ... var1);

        public Builder tagList(Consumer<Tag.Builder> ... var1);

        public Builder dbInstanceAutomatedBackupsReplications(Collection<DBInstanceAutomatedBackupsReplication> var1);

        public Builder dbInstanceAutomatedBackupsReplications(DBInstanceAutomatedBackupsReplication ... var1);

        public Builder dbInstanceAutomatedBackupsReplications(Consumer<DBInstanceAutomatedBackupsReplication.Builder> ... var1);
    }
}

