/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IPRange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IPRange> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IPRange.getter(IPRange::status)).setter(IPRange.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> CIDRIP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IPRange.getter(IPRange::cidrip)).setter(IPRange.setter(Builder::cidrip)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CIDRIP").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, CIDRIP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String cidrip;

    private IPRange(BuilderImpl builder) {
        this.status = builder.status;
        this.cidrip = builder.cidrip;
    }

    public String status() {
        return this.status;
    }

    public String cidrip() {
        return this.cidrip;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrip());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPRange)) {
            return false;
        }
        IPRange other = (IPRange)obj;
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.cidrip(), other.cidrip());
    }

    public String toString() {
        return ToString.builder((String)"IPRange").add("Status", (Object)this.status()).add("CIDRIP", (Object)this.cidrip()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "CIDRIP": {
                return Optional.ofNullable(clazz.cast(this.cidrip()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IPRange, T> g) {
        return obj -> g.apply((IPRange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String cidrip;

        private BuilderImpl() {
        }

        private BuilderImpl(IPRange model) {
            this.status(model.status);
            this.cidrip(model.cidrip);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getCidrip() {
            return this.cidrip;
        }

        @Override
        public final Builder cidrip(String cidrip) {
            this.cidrip = cidrip;
            return this;
        }

        public final void setCidrip(String cidrip) {
            this.cidrip = cidrip;
        }

        public IPRange build() {
            return new IPRange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IPRange> {
        public Builder status(String var1);

        public Builder cidrip(String var1);
    }
}

