/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.StringListCopier;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDbClusterEndpointRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, CreateDbClusterEndpointRequest> {
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDbClusterEndpointRequest.getter(CreateDbClusterEndpointRequest::dbClusterIdentifier)).setter(CreateDbClusterEndpointRequest.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build()}).build();
    private static final SdkField<String> DB_CLUSTER_ENDPOINT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDbClusterEndpointRequest.getter(CreateDbClusterEndpointRequest::dbClusterEndpointIdentifier)).setter(CreateDbClusterEndpointRequest.setter(Builder::dbClusterEndpointIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterEndpointIdentifier").build()}).build();
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDbClusterEndpointRequest.getter(CreateDbClusterEndpointRequest::endpointType)).setter(CreateDbClusterEndpointRequest.setter(Builder::endpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()}).build();
    private static final SdkField<List<String>> STATIC_MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateDbClusterEndpointRequest.getter(CreateDbClusterEndpointRequest::staticMembers)).setter(CreateDbClusterEndpointRequest.setter(Builder::staticMembers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticMembers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDED_MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateDbClusterEndpointRequest.getter(CreateDbClusterEndpointRequest::excludedMembers)).setter(CreateDbClusterEndpointRequest.setter(Builder::excludedMembers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedMembers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateDbClusterEndpointRequest.getter(CreateDbClusterEndpointRequest::tags)).setter(CreateDbClusterEndpointRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_IDENTIFIER_FIELD, DB_CLUSTER_ENDPOINT_IDENTIFIER_FIELD, ENDPOINT_TYPE_FIELD, STATIC_MEMBERS_FIELD, EXCLUDED_MEMBERS_FIELD, TAGS_FIELD));
    private final String dbClusterIdentifier;
    private final String dbClusterEndpointIdentifier;
    private final String endpointType;
    private final List<String> staticMembers;
    private final List<String> excludedMembers;
    private final List<Tag> tags;

    private CreateDbClusterEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.dbClusterEndpointIdentifier = builder.dbClusterEndpointIdentifier;
        this.endpointType = builder.endpointType;
        this.staticMembers = builder.staticMembers;
        this.excludedMembers = builder.excludedMembers;
        this.tags = builder.tags;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public String dbClusterEndpointIdentifier() {
        return this.dbClusterEndpointIdentifier;
    }

    public String endpointType() {
        return this.endpointType;
    }

    public List<String> staticMembers() {
        return this.staticMembers;
    }

    public List<String> excludedMembers() {
        return this.excludedMembers;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterEndpointIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointType());
        hashCode = 31 * hashCode + Objects.hashCode(this.staticMembers());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludedMembers());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDbClusterEndpointRequest)) {
            return false;
        }
        CreateDbClusterEndpointRequest other = (CreateDbClusterEndpointRequest)((Object)obj);
        return Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.dbClusterEndpointIdentifier(), other.dbClusterEndpointIdentifier()) && Objects.equals(this.endpointType(), other.endpointType()) && Objects.equals(this.staticMembers(), other.staticMembers()) && Objects.equals(this.excludedMembers(), other.excludedMembers()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateDbClusterEndpointRequest").add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("DBClusterEndpointIdentifier", (Object)this.dbClusterEndpointIdentifier()).add("EndpointType", (Object)this.endpointType()).add("StaticMembers", this.staticMembers()).add("ExcludedMembers", this.excludedMembers()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "DBClusterEndpointIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterEndpointIdentifier()));
            }
            case "EndpointType": {
                return Optional.ofNullable(clazz.cast(this.endpointType()));
            }
            case "StaticMembers": {
                return Optional.ofNullable(clazz.cast(this.staticMembers()));
            }
            case "ExcludedMembers": {
                return Optional.ofNullable(clazz.cast(this.excludedMembers()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDbClusterEndpointRequest, T> g) {
        return obj -> g.apply((CreateDbClusterEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbClusterIdentifier;
        private String dbClusterEndpointIdentifier;
        private String endpointType;
        private List<String> staticMembers = DefaultSdkAutoConstructList.getInstance();
        private List<String> excludedMembers = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDbClusterEndpointRequest model) {
            super(model);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.dbClusterEndpointIdentifier(model.dbClusterEndpointIdentifier);
            this.endpointType(model.endpointType);
            this.staticMembers(model.staticMembers);
            this.excludedMembers(model.excludedMembers);
            this.tags(model.tags);
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getDbClusterEndpointIdentifier() {
            return this.dbClusterEndpointIdentifier;
        }

        @Override
        public final Builder dbClusterEndpointIdentifier(String dbClusterEndpointIdentifier) {
            this.dbClusterEndpointIdentifier = dbClusterEndpointIdentifier;
            return this;
        }

        public final void setDbClusterEndpointIdentifier(String dbClusterEndpointIdentifier) {
            this.dbClusterEndpointIdentifier = dbClusterEndpointIdentifier;
        }

        public final String getEndpointType() {
            return this.endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        public final Collection<String> getStaticMembers() {
            return this.staticMembers;
        }

        @Override
        public final Builder staticMembers(Collection<String> staticMembers) {
            this.staticMembers = StringListCopier.copy(staticMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staticMembers(String ... staticMembers) {
            this.staticMembers(Arrays.asList(staticMembers));
            return this;
        }

        public final void setStaticMembers(Collection<String> staticMembers) {
            this.staticMembers = StringListCopier.copy(staticMembers);
        }

        public final Collection<String> getExcludedMembers() {
            return this.excludedMembers;
        }

        @Override
        public final Builder excludedMembers(Collection<String> excludedMembers) {
            this.excludedMembers = StringListCopier.copy(excludedMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedMembers(String ... excludedMembers) {
            this.excludedMembers(Arrays.asList(excludedMembers));
            return this;
        }

        public final void setExcludedMembers(Collection<String> excludedMembers) {
            this.excludedMembers = StringListCopier.copy(excludedMembers);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDbClusterEndpointRequest build() {
            return new CreateDbClusterEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDbClusterEndpointRequest> {
        public Builder dbClusterIdentifier(String var1);

        public Builder dbClusterEndpointIdentifier(String var1);

        public Builder endpointType(String var1);

        public Builder staticMembers(Collection<String> var1);

        public Builder staticMembers(String ... var1);

        public Builder excludedMembers(Collection<String> var1);

        public Builder excludedMembers(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

