/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.OptionConfiguration;
import software.amazon.awssdk.services.rds.model.OptionSetting;
import software.amazon.awssdk.services.rds.transform.OptionSettingUnmarshaller;

public class OptionConfigurationUnmarshaller
implements Unmarshaller<OptionConfiguration, StaxUnmarshallerContext> {
    private static final OptionConfigurationUnmarshaller INSTANCE = new OptionConfigurationUnmarshaller();

    public OptionConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        OptionConfiguration.Builder optionConfiguration;
        block12: {
            optionConfiguration = OptionConfiguration.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> dbSecurityGroupMemberships = null;
            ArrayList<String> vpcSecurityGroupMemberships = null;
            ArrayList<OptionSetting> optionSettings = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    optionConfiguration.dbSecurityGroupMemberships(dbSecurityGroupMemberships);
                    optionConfiguration.vpcSecurityGroupMemberships(vpcSecurityGroupMemberships);
                    optionConfiguration.optionSettings(optionSettings);
                    break block12;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("OptionName", targetDepth)) {
                        optionConfiguration.optionName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Port", targetDepth)) {
                        optionConfiguration.port(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("OptionVersion", targetDepth)) {
                        optionConfiguration.optionVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DBSecurityGroupMemberships", targetDepth)) {
                        dbSecurityGroupMemberships = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("DBSecurityGroupMemberships/DBSecurityGroupName", targetDepth)) {
                        dbSecurityGroupMemberships.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("VpcSecurityGroupMemberships", targetDepth)) {
                        vpcSecurityGroupMemberships = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("VpcSecurityGroupMemberships/VpcSecurityGroupId", targetDepth)) {
                        vpcSecurityGroupMemberships.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("OptionSettings", targetDepth)) {
                        optionSettings = new ArrayList<OptionSetting>();
                        continue;
                    }
                    if (!context.testExpression("OptionSettings/OptionSetting", targetDepth)) continue;
                    optionSettings.add(OptionSettingUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            optionConfiguration.dbSecurityGroupMemberships(dbSecurityGroupMemberships);
            optionConfiguration.vpcSecurityGroupMemberships(vpcSecurityGroupMemberships);
            optionConfiguration.optionSettings(optionSettings);
        }
        return (OptionConfiguration)optionConfiguration.build();
    }

    public static OptionConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

