/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DescribeReservedDBInstancesOfferingsRequest;
import software.amazon.awssdk.services.rds.model.DescribeReservedDBInstancesOfferingsResponse;
import software.amazon.awssdk.services.rds.model.ReservedDBInstancesOffering;

public class DescribeReservedDBInstancesOfferingsIterable
implements SdkIterable<DescribeReservedDBInstancesOfferingsResponse> {
    private final RDSClient client;
    private final DescribeReservedDBInstancesOfferingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReservedDBInstancesOfferingsIterable(RDSClient client, DescribeReservedDBInstancesOfferingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReservedDBInstancesOfferingsResponseFetcher();
    }

    public Iterator<DescribeReservedDBInstancesOfferingsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<ReservedDBInstancesOffering> reservedDBInstancesOfferings() {
        Function<DescribeReservedDBInstancesOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedDBInstancesOfferings() != null) {
                return response.reservedDBInstancesOfferings().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeReservedDBInstancesOfferingsIterable resume(DescribeReservedDBInstancesOfferingsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReservedDBInstancesOfferingsIterable(this.client, (DescribeReservedDBInstancesOfferingsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeReservedDBInstancesOfferingsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeReservedDBInstancesOfferingsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeReservedDBInstancesOfferingsResponseFetcher
    implements SyncPageFetcher<DescribeReservedDBInstancesOfferingsResponse> {
        private DescribeReservedDBInstancesOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedDBInstancesOfferingsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeReservedDBInstancesOfferingsResponse nextPage(DescribeReservedDBInstancesOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedDBInstancesOfferingsIterable.this.client.describeReservedDBInstancesOfferings(DescribeReservedDBInstancesOfferingsIterable.this.firstRequest);
            }
            return DescribeReservedDBInstancesOfferingsIterable.this.client.describeReservedDBInstancesOfferings((DescribeReservedDBInstancesOfferingsRequest)((Object)DescribeReservedDBInstancesOfferingsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

