/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SourceRegion
implements ToCopyableBuilder<Builder, SourceRegion> {
    private final String regionName;
    private final String endpoint;
    private final String status;

    private SourceRegion(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.endpoint = builder.endpoint;
        this.status = builder.status;
    }

    public String regionName() {
        return this.regionName;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceRegion)) {
            return false;
        }
        SourceRegion other = (SourceRegion)obj;
        return Objects.equals(this.regionName(), other.regionName()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"SourceRegion").add("RegionName", (Object)this.regionName()).add("Endpoint", (Object)this.endpoint()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegionName": {
                return Optional.of(clazz.cast(this.regionName()));
            }
            case "Endpoint": {
                return Optional.of(clazz.cast(this.endpoint()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String regionName;
        private String endpoint;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceRegion model) {
            this.regionName(model.regionName);
            this.endpoint(model.endpoint);
            this.status(model.status);
        }

        public final String getRegionName() {
            return this.regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public SourceRegion build() {
            return new SourceRegion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SourceRegion> {
        public Builder regionName(String var1);

        public Builder endpoint(String var1);

        public Builder status(String var1);
    }
}

