/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.RestoreDBInstanceFromDBSnapshotRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class RestoreDBInstanceFromDBSnapshotRequestMarshaller
implements Marshaller<Request<RestoreDBInstanceFromDBSnapshotRequest>, RestoreDBInstanceFromDBSnapshotRequest> {
    public Request<RestoreDBInstanceFromDBSnapshotRequest> marshall(RestoreDBInstanceFromDBSnapshotRequest restoreDBInstanceFromDBSnapshotRequest) {
        List<Tag> tagsList;
        if (restoreDBInstanceFromDBSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)restoreDBInstanceFromDBSnapshotRequest, "RDSClient");
        request.addParameter("Action", "RestoreDBInstanceFromDBSnapshot");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (restoreDBInstanceFromDBSnapshotRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString((String)restoreDBInstanceFromDBSnapshotRequest.dbInstanceIdentifier()));
        }
        if (restoreDBInstanceFromDBSnapshotRequest.dbSnapshotIdentifier() != null) {
            request.addParameter("DBSnapshotIdentifier", StringUtils.fromString((String)restoreDBInstanceFromDBSnapshotRequest.dbSnapshotIdentifier()));
        }
        if (restoreDBInstanceFromDBSnapshotRequest.dbInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringUtils.fromString((String)restoreDBInstanceFromDBSnapshotRequest.dbInstanceClass()));
        }
        if (restoreDBInstanceFromDBSnapshotRequest.port() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)restoreDBInstanceFromDBSnapshotRequest.port()));
        }
        if (restoreDBInstanceFromDBSnapshotRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)restoreDBInstanceFromDBSnapshotRequest.availabilityZone()));
        }
        if (restoreDBInstanceFromDBSnapshotRequest.dbSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString((String)restoreDBInstanceFromDBSnapshotRequest.dbSubnetGroupName()));
        }
        if (restoreDBInstanceFromDBSnapshotRequest.multiAZ() != null) {
            request.addParameter("MultiAZ", StringUtils.fromBoolean((Boolean)restoreDBInstanceFromDBSnapshotRequest.multiAZ()));
        }
        if (restoreDBInstanceFromDBSnapshotRequest.publiclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringUtils.fromBoolean((Boolean)restoreDBInstanceFromDBSnapshotRequest.publiclyAccessible()));
        }
        if (restoreDBInstanceFromDBSnapshotRequest.autoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean((Boolean)restoreDBInstanceFromDBSnapshotRequest.autoMinorVersionUpgrade()));
        }
        if (restoreDBInstanceFromDBSnapshotRequest.licenseModel() != null) {
            request.addParameter("LicenseModel", StringUtils.fromString((String)restoreDBInstanceFromDBSnapshotRequest.licenseModel()));
        }
        if (restoreDBInstanceFromDBSnapshotRequest.dbName() != null) {
            request.addParameter("DBName", StringUtils.fromString((String)restoreDBInstanceFromDBSnapshotRequest.dbName()));
        }
        if (restoreDBInstanceFromDBSnapshotRequest.engine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)restoreDBInstanceFromDBSnapshotRequest.engine()));
        }
        if (restoreDBInstanceFromDBSnapshotRequest.iops() != null) {
            request.addParameter("Iops", StringUtils.fromInteger((Integer)restoreDBInstanceFromDBSnapshotRequest.iops()));
        }
        if (restoreDBInstanceFromDBSnapshotRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)restoreDBInstanceFromDBSnapshotRequest.optionGroupName()));
        }
        if ((tagsList = restoreDBInstanceFromDBSnapshotRequest.tags()) != null) {
            if (!tagsList.isEmpty()) {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++tagsListIndex;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        if (restoreDBInstanceFromDBSnapshotRequest.storageType() != null) {
            request.addParameter("StorageType", StringUtils.fromString((String)restoreDBInstanceFromDBSnapshotRequest.storageType()));
        }
        if (restoreDBInstanceFromDBSnapshotRequest.tdeCredentialArn() != null) {
            request.addParameter("TdeCredentialArn", StringUtils.fromString((String)restoreDBInstanceFromDBSnapshotRequest.tdeCredentialArn()));
        }
        if (restoreDBInstanceFromDBSnapshotRequest.tdeCredentialPassword() != null) {
            request.addParameter("TdeCredentialPassword", StringUtils.fromString((String)restoreDBInstanceFromDBSnapshotRequest.tdeCredentialPassword()));
        }
        if (restoreDBInstanceFromDBSnapshotRequest.domain() != null) {
            request.addParameter("Domain", StringUtils.fromString((String)restoreDBInstanceFromDBSnapshotRequest.domain()));
        }
        if (restoreDBInstanceFromDBSnapshotRequest.copyTagsToSnapshot() != null) {
            request.addParameter("CopyTagsToSnapshot", StringUtils.fromBoolean((Boolean)restoreDBInstanceFromDBSnapshotRequest.copyTagsToSnapshot()));
        }
        if (restoreDBInstanceFromDBSnapshotRequest.domainIAMRoleName() != null) {
            request.addParameter("DomainIAMRoleName", StringUtils.fromString((String)restoreDBInstanceFromDBSnapshotRequest.domainIAMRoleName()));
        }
        if (restoreDBInstanceFromDBSnapshotRequest.enableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean((Boolean)restoreDBInstanceFromDBSnapshotRequest.enableIAMDatabaseAuthentication()));
        }
        return request;
    }
}

