/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.RestoreDBClusterFromSnapshotRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class RestoreDBClusterFromSnapshotRequestMarshaller
implements Marshaller<Request<RestoreDBClusterFromSnapshotRequest>, RestoreDBClusterFromSnapshotRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<RestoreDBClusterFromSnapshotRequest> marshall(RestoreDBClusterFromSnapshotRequest restoreDBClusterFromSnapshotRequest) {
        List<Tag> tagsList;
        List<String> vpcSecurityGroupIdsList;
        if (restoreDBClusterFromSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)restoreDBClusterFromSnapshotRequest, "RDSClient");
        request.addParameter("Action", "RestoreDBClusterFromSnapshot");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> availabilityZonesList = restoreDBClusterFromSnapshotRequest.availabilityZones();
        if (availabilityZonesList != null) {
            if (!availabilityZonesList.isEmpty()) {
                int availabilityZonesListIndex = 1;
                for (String string : availabilityZonesList) {
                    if (string != null) {
                        request.addParameter("AvailabilityZones.AvailabilityZone." + availabilityZonesListIndex, StringUtils.fromString((String)string));
                    }
                    ++availabilityZonesListIndex;
                }
            } else {
                request.addParameter("AvailabilityZones", "");
            }
        }
        if (restoreDBClusterFromSnapshotRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.dbClusterIdentifier()));
        }
        if (restoreDBClusterFromSnapshotRequest.snapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.snapshotIdentifier()));
        }
        if (restoreDBClusterFromSnapshotRequest.engine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.engine()));
        }
        if (restoreDBClusterFromSnapshotRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.engineVersion()));
        }
        if (restoreDBClusterFromSnapshotRequest.port() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)restoreDBClusterFromSnapshotRequest.port()));
        }
        if (restoreDBClusterFromSnapshotRequest.dbSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.dbSubnetGroupName()));
        }
        if (restoreDBClusterFromSnapshotRequest.databaseName() != null) {
            request.addParameter("DatabaseName", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.databaseName()));
        }
        if (restoreDBClusterFromSnapshotRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.optionGroupName()));
        }
        if ((vpcSecurityGroupIdsList = restoreDBClusterFromSnapshotRequest.vpcSecurityGroupIds()) != null) {
            if (!vpcSecurityGroupIdsList.isEmpty()) {
                int vpcSecurityGroupIdsListIndex = 1;
                for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                    if (vpcSecurityGroupIdsListValue != null) {
                        request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                    }
                    ++vpcSecurityGroupIdsListIndex;
                }
            } else {
                request.addParameter("VpcSecurityGroupIds", "");
            }
        }
        if ((tagsList = restoreDBClusterFromSnapshotRequest.tags()) != null) {
            if (!tagsList.isEmpty()) {
                boolean bl = true;
                for (Tag tagsListValue : tagsList) {
                    void var6_12;
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.Tag." + (int)var6_12 + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.Tag." + (int)var6_12 + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++var6_12;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        if (restoreDBClusterFromSnapshotRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.kmsKeyId()));
        }
        if (restoreDBClusterFromSnapshotRequest.enableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean((Boolean)restoreDBClusterFromSnapshotRequest.enableIAMDatabaseAuthentication()));
        }
        return request;
    }
}

