/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.rds.model.OptionGroup;
import software.amazon.awssdk.services.rds.model.OptionGroupsListCopier;
import software.amazon.awssdk.services.rds.model.RDSResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeOptionGroupsResponse
extends RDSResponse
implements ToCopyableBuilder<Builder, DescribeOptionGroupsResponse> {
    private final List<OptionGroup> optionGroupsList;
    private final String marker;

    private DescribeOptionGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.optionGroupsList = builder.optionGroupsList;
        this.marker = builder.marker;
    }

    public List<OptionGroup> optionGroupsList() {
        return this.optionGroupsList;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupsList());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOptionGroupsResponse)) {
            return false;
        }
        DescribeOptionGroupsResponse other = (DescribeOptionGroupsResponse)((Object)obj);
        return Objects.equals(this.optionGroupsList(), other.optionGroupsList()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeOptionGroupsResponse").add("OptionGroupsList", this.optionGroupsList()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OptionGroupsList": {
                return Optional.of(clazz.cast(this.optionGroupsList()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSResponse.BuilderImpl
    implements Builder {
        private List<OptionGroup> optionGroupsList;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOptionGroupsResponse model) {
            this.optionGroupsList(model.optionGroupsList);
            this.marker(model.marker);
        }

        public final Collection<OptionGroup.Builder> getOptionGroupsList() {
            return this.optionGroupsList != null ? (Collection)this.optionGroupsList.stream().map(OptionGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder optionGroupsList(Collection<OptionGroup> optionGroupsList) {
            this.optionGroupsList = OptionGroupsListCopier.copy(optionGroupsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupsList(OptionGroup ... optionGroupsList) {
            this.optionGroupsList(Arrays.asList(optionGroupsList));
            return this;
        }

        public final void setOptionGroupsList(Collection<OptionGroup.BuilderImpl> optionGroupsList) {
            this.optionGroupsList = OptionGroupsListCopier.copyFromBuilder(optionGroupsList);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeOptionGroupsResponse build() {
            return new DescribeOptionGroupsResponse(this);
        }
    }

    public static interface Builder
    extends RDSResponse.Builder,
    CopyableBuilder<Builder, DescribeOptionGroupsResponse> {
        public Builder optionGroupsList(Collection<OptionGroup> var1);

        public Builder optionGroupsList(OptionGroup ... var1);

        public Builder marker(String var1);
    }
}

