/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class CreateEventSubscriptionRequestMarshaller
implements Marshaller<Request<CreateEventSubscriptionRequest>, CreateEventSubscriptionRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<CreateEventSubscriptionRequest> marshall(CreateEventSubscriptionRequest createEventSubscriptionRequest) {
        List<Tag> tagsList;
        List<String> sourceIdsList;
        List<String> eventCategoriesList;
        if (createEventSubscriptionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createEventSubscriptionRequest, "RDSClient");
        request.addParameter("Action", "CreateEventSubscription");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createEventSubscriptionRequest.subscriptionName() != null) {
            request.addParameter("SubscriptionName", StringUtils.fromString((String)createEventSubscriptionRequest.subscriptionName()));
        }
        if (createEventSubscriptionRequest.snsTopicArn() != null) {
            request.addParameter("SnsTopicArn", StringUtils.fromString((String)createEventSubscriptionRequest.snsTopicArn()));
        }
        if (createEventSubscriptionRequest.sourceType() != null) {
            request.addParameter("SourceType", StringUtils.fromString((String)createEventSubscriptionRequest.sourceType()));
        }
        if ((eventCategoriesList = createEventSubscriptionRequest.eventCategories()) != null) {
            if (!eventCategoriesList.isEmpty()) {
                int eventCategoriesListIndex = 1;
                for (String string : eventCategoriesList) {
                    if (string != null) {
                        request.addParameter("EventCategories.EventCategory." + eventCategoriesListIndex, StringUtils.fromString((String)string));
                    }
                    ++eventCategoriesListIndex;
                }
            } else {
                request.addParameter("EventCategories", "");
            }
        }
        if ((sourceIdsList = createEventSubscriptionRequest.sourceIds()) != null) {
            if (!sourceIdsList.isEmpty()) {
                int sourceIdsListIndex = 1;
                for (String sourceIdsListValue : sourceIdsList) {
                    if (sourceIdsListValue != null) {
                        request.addParameter("SourceIds.SourceId." + sourceIdsListIndex, StringUtils.fromString((String)sourceIdsListValue));
                    }
                    ++sourceIdsListIndex;
                }
            } else {
                request.addParameter("SourceIds", "");
            }
        }
        if (createEventSubscriptionRequest.enabled() != null) {
            request.addParameter("Enabled", StringUtils.fromBoolean((Boolean)createEventSubscriptionRequest.enabled()));
        }
        if ((tagsList = createEventSubscriptionRequest.tags()) != null) {
            if (!tagsList.isEmpty()) {
                boolean bl = true;
                for (Tag tagsListValue : tagsList) {
                    void var6_12;
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.Tag." + (int)var6_12 + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.Tag." + (int)var6_12 + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++var6_12;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        return request;
    }
}

