/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DBParameterGroup;
import software.amazon.awssdk.services.rds.model.DescribeDBParameterGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDBParameterGroupsResponse;

public final class DescribeDBParameterGroupsPaginator
implements SdkIterable<DescribeDBParameterGroupsResponse> {
    private final RDSClient client;
    private final DescribeDBParameterGroupsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeDBParameterGroupsPaginator(RDSClient client, DescribeDBParameterGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDBParameterGroupsResponseFetcher();
    }

    public Iterator<DescribeDBParameterGroupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<DBParameterGroup> dbParameterGroups() {
        Function<DescribeDBParameterGroupsResponse, Iterator> getIterator = response -> response != null ? response.dbParameterGroups().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeDBParameterGroupsResponseFetcher
    implements NextPageFetcher<DescribeDBParameterGroupsResponse> {
        private DescribeDBParameterGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDBParameterGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeDBParameterGroupsResponse nextPage(DescribeDBParameterGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBParameterGroupsPaginator.this.client.describeDBParameterGroups(DescribeDBParameterGroupsPaginator.this.firstRequest);
            }
            return DescribeDBParameterGroupsPaginator.this.client.describeDBParameterGroups((DescribeDBParameterGroupsRequest)((Object)DescribeDBParameterGroupsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

