/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DescribeDBLogFilesDetails;
import software.amazon.awssdk.services.rds.model.DescribeDBLogFilesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDBLogFilesResponse;

public final class DescribeDBLogFilesPaginator
implements SdkIterable<DescribeDBLogFilesResponse> {
    private final RDSClient client;
    private final DescribeDBLogFilesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeDBLogFilesPaginator(RDSClient client, DescribeDBLogFilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDBLogFilesResponseFetcher();
    }

    public Iterator<DescribeDBLogFilesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<DescribeDBLogFilesDetails> describeDBLogFiles() {
        Function<DescribeDBLogFilesResponse, Iterator> getIterator = response -> response != null ? response.describeDBLogFiles().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeDBLogFilesResponseFetcher
    implements NextPageFetcher<DescribeDBLogFilesResponse> {
        private DescribeDBLogFilesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDBLogFilesResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeDBLogFilesResponse nextPage(DescribeDBLogFilesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBLogFilesPaginator.this.client.describeDBLogFiles(DescribeDBLogFilesPaginator.this.firstRequest);
            }
            return DescribeDBLogFilesPaginator.this.client.describeDBLogFiles((DescribeDBLogFilesRequest)((Object)DescribeDBLogFilesPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

