/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.rds.model.PendingMaintenanceAction;
import software.amazon.awssdk.services.rds.model.PendingMaintenanceActionDetailsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResourcePendingMaintenanceActions
implements ToCopyableBuilder<Builder, ResourcePendingMaintenanceActions> {
    private final String resourceIdentifier;
    private final List<PendingMaintenanceAction> pendingMaintenanceActionDetails;

    private ResourcePendingMaintenanceActions(BuilderImpl builder) {
        this.resourceIdentifier = builder.resourceIdentifier;
        this.pendingMaintenanceActionDetails = builder.pendingMaintenanceActionDetails;
    }

    public String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public List<PendingMaintenanceAction> pendingMaintenanceActionDetails() {
        return this.pendingMaintenanceActionDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingMaintenanceActionDetails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcePendingMaintenanceActions)) {
            return false;
        }
        ResourcePendingMaintenanceActions other = (ResourcePendingMaintenanceActions)obj;
        return Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && Objects.equals(this.pendingMaintenanceActionDetails(), other.pendingMaintenanceActionDetails());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resourceIdentifier() != null) {
            sb.append("ResourceIdentifier: ").append(this.resourceIdentifier()).append(",");
        }
        if (this.pendingMaintenanceActionDetails() != null) {
            sb.append("PendingMaintenanceActionDetails: ").append(this.pendingMaintenanceActionDetails()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceIdentifier": {
                return Optional.of(clazz.cast(this.resourceIdentifier()));
            }
            case "PendingMaintenanceActionDetails": {
                return Optional.of(clazz.cast(this.pendingMaintenanceActionDetails()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceIdentifier;
        private List<PendingMaintenanceAction> pendingMaintenanceActionDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcePendingMaintenanceActions model) {
            this.resourceIdentifier(model.resourceIdentifier);
            this.pendingMaintenanceActionDetails(model.pendingMaintenanceActionDetails);
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        public final Collection<PendingMaintenanceAction.Builder> getPendingMaintenanceActionDetails() {
            return this.pendingMaintenanceActionDetails != null ? (Collection)this.pendingMaintenanceActionDetails.stream().map(PendingMaintenanceAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pendingMaintenanceActionDetails(Collection<PendingMaintenanceAction> pendingMaintenanceActionDetails) {
            this.pendingMaintenanceActionDetails = PendingMaintenanceActionDetailsCopier.copy(pendingMaintenanceActionDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingMaintenanceActionDetails(PendingMaintenanceAction ... pendingMaintenanceActionDetails) {
            this.pendingMaintenanceActionDetails(Arrays.asList(pendingMaintenanceActionDetails));
            return this;
        }

        public final void setPendingMaintenanceActionDetails(Collection<PendingMaintenanceAction.BuilderImpl> pendingMaintenanceActionDetails) {
            this.pendingMaintenanceActionDetails = PendingMaintenanceActionDetailsCopier.copyFromBuilder(pendingMaintenanceActionDetails);
        }

        public ResourcePendingMaintenanceActions build() {
            return new ResourcePendingMaintenanceActions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourcePendingMaintenanceActions> {
        public Builder resourceIdentifier(String var1);

        public Builder pendingMaintenanceActionDetails(Collection<PendingMaintenanceAction> var1);

        public Builder pendingMaintenanceActionDetails(PendingMaintenanceAction ... var1);
    }
}

