/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.rds.model.RDSRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RemoveSourceIdentifierFromSubscriptionRequest
extends RDSRequest
implements ToCopyableBuilder<Builder, RemoveSourceIdentifierFromSubscriptionRequest> {
    private final String subscriptionName;
    private final String sourceIdentifier;

    private RemoveSourceIdentifierFromSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.subscriptionName = builder.subscriptionName;
        this.sourceIdentifier = builder.sourceIdentifier;
    }

    public String subscriptionName() {
        return this.subscriptionName;
    }

    public String sourceIdentifier() {
        return this.sourceIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveSourceIdentifierFromSubscriptionRequest)) {
            return false;
        }
        RemoveSourceIdentifierFromSubscriptionRequest other = (RemoveSourceIdentifierFromSubscriptionRequest)((Object)obj);
        return Objects.equals(this.subscriptionName(), other.subscriptionName()) && Objects.equals(this.sourceIdentifier(), other.sourceIdentifier());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.subscriptionName() != null) {
            sb.append("SubscriptionName: ").append(this.subscriptionName()).append(",");
        }
        if (this.sourceIdentifier() != null) {
            sb.append("SourceIdentifier: ").append(this.sourceIdentifier()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubscriptionName": {
                return Optional.of(clazz.cast(this.subscriptionName()));
            }
            case "SourceIdentifier": {
                return Optional.of(clazz.cast(this.sourceIdentifier()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSRequest.BuilderImpl
    implements Builder {
        private String subscriptionName;
        private String sourceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveSourceIdentifierFromSubscriptionRequest model) {
            this.subscriptionName(model.subscriptionName);
            this.sourceIdentifier(model.sourceIdentifier);
        }

        public final String getSubscriptionName() {
            return this.subscriptionName;
        }

        @Override
        public final Builder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public final void setSubscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
        }

        public final String getSourceIdentifier() {
            return this.sourceIdentifier;
        }

        @Override
        public final Builder sourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
            return this;
        }

        public final void setSourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RemoveSourceIdentifierFromSubscriptionRequest build() {
            return new RemoveSourceIdentifierFromSubscriptionRequest(this);
        }
    }

    public static interface Builder
    extends RDSRequest.Builder,
    CopyableBuilder<Builder, RemoveSourceIdentifierFromSubscriptionRequest> {
        public Builder subscriptionName(String var1);

        public Builder sourceIdentifier(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

