/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.rds.model.RDSRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CopyDBSnapshotRequest
extends RDSRequest
implements ToCopyableBuilder<Builder, CopyDBSnapshotRequest> {
    private final String sourceDBSnapshotIdentifier;
    private final String targetDBSnapshotIdentifier;
    private final String kmsKeyId;
    private final List<Tag> tags;
    private final Boolean copyTags;
    private final String preSignedUrl;
    private final String optionGroupName;
    private final String sourceRegion;

    private CopyDBSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.sourceDBSnapshotIdentifier = builder.sourceDBSnapshotIdentifier;
        this.targetDBSnapshotIdentifier = builder.targetDBSnapshotIdentifier;
        this.kmsKeyId = builder.kmsKeyId;
        this.tags = builder.tags;
        this.copyTags = builder.copyTags;
        this.preSignedUrl = builder.preSignedUrl;
        this.optionGroupName = builder.optionGroupName;
        this.sourceRegion = builder.sourceRegion;
    }

    public String sourceDBSnapshotIdentifier() {
        return this.sourceDBSnapshotIdentifier;
    }

    public String targetDBSnapshotIdentifier() {
        return this.targetDBSnapshotIdentifier;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Boolean copyTags() {
        return this.copyTags;
    }

    public String preSignedUrl() {
        return this.preSignedUrl;
    }

    public String optionGroupName() {
        return this.optionGroupName;
    }

    public String sourceRegion() {
        return this.sourceRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDBSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDBSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.preSignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRegion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyDBSnapshotRequest)) {
            return false;
        }
        CopyDBSnapshotRequest other = (CopyDBSnapshotRequest)((Object)obj);
        return Objects.equals(this.sourceDBSnapshotIdentifier(), other.sourceDBSnapshotIdentifier()) && Objects.equals(this.targetDBSnapshotIdentifier(), other.targetDBSnapshotIdentifier()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.copyTags(), other.copyTags()) && Objects.equals(this.preSignedUrl(), other.preSignedUrl()) && Objects.equals(this.optionGroupName(), other.optionGroupName()) && Objects.equals(this.sourceRegion(), other.sourceRegion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.sourceDBSnapshotIdentifier() != null) {
            sb.append("SourceDBSnapshotIdentifier: ").append(this.sourceDBSnapshotIdentifier()).append(",");
        }
        if (this.targetDBSnapshotIdentifier() != null) {
            sb.append("TargetDBSnapshotIdentifier: ").append(this.targetDBSnapshotIdentifier()).append(",");
        }
        if (this.kmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.kmsKeyId()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.copyTags() != null) {
            sb.append("CopyTags: ").append(this.copyTags()).append(",");
        }
        if (this.preSignedUrl() != null) {
            sb.append("PreSignedUrl: ").append(this.preSignedUrl()).append(",");
        }
        if (this.optionGroupName() != null) {
            sb.append("OptionGroupName: ").append(this.optionGroupName()).append(",");
        }
        if (this.sourceRegion() != null) {
            sb.append("SourceRegion: ").append(this.sourceRegion()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceDBSnapshotIdentifier": {
                return Optional.of(clazz.cast(this.sourceDBSnapshotIdentifier()));
            }
            case "TargetDBSnapshotIdentifier": {
                return Optional.of(clazz.cast(this.targetDBSnapshotIdentifier()));
            }
            case "KmsKeyId": {
                return Optional.of(clazz.cast(this.kmsKeyId()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "CopyTags": {
                return Optional.of(clazz.cast(this.copyTags()));
            }
            case "PreSignedUrl": {
                return Optional.of(clazz.cast(this.preSignedUrl()));
            }
            case "OptionGroupName": {
                return Optional.of(clazz.cast(this.optionGroupName()));
            }
            case "SourceRegion": {
                return Optional.of(clazz.cast(this.sourceRegion()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSRequest.BuilderImpl
    implements Builder {
        private String sourceDBSnapshotIdentifier;
        private String targetDBSnapshotIdentifier;
        private String kmsKeyId;
        private List<Tag> tags;
        private Boolean copyTags;
        private String preSignedUrl;
        private String optionGroupName;
        private String sourceRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyDBSnapshotRequest model) {
            this.sourceDBSnapshotIdentifier(model.sourceDBSnapshotIdentifier);
            this.targetDBSnapshotIdentifier(model.targetDBSnapshotIdentifier);
            this.kmsKeyId(model.kmsKeyId);
            this.tags(model.tags);
            this.copyTags(model.copyTags);
            this.preSignedUrl(model.preSignedUrl);
            this.optionGroupName(model.optionGroupName);
            this.sourceRegion(model.sourceRegion);
        }

        public final String getSourceDBSnapshotIdentifier() {
            return this.sourceDBSnapshotIdentifier;
        }

        @Override
        public final Builder sourceDBSnapshotIdentifier(String sourceDBSnapshotIdentifier) {
            this.sourceDBSnapshotIdentifier = sourceDBSnapshotIdentifier;
            return this;
        }

        public final void setSourceDBSnapshotIdentifier(String sourceDBSnapshotIdentifier) {
            this.sourceDBSnapshotIdentifier = sourceDBSnapshotIdentifier;
        }

        public final String getTargetDBSnapshotIdentifier() {
            return this.targetDBSnapshotIdentifier;
        }

        @Override
        public final Builder targetDBSnapshotIdentifier(String targetDBSnapshotIdentifier) {
            this.targetDBSnapshotIdentifier = targetDBSnapshotIdentifier;
            return this;
        }

        public final void setTargetDBSnapshotIdentifier(String targetDBSnapshotIdentifier) {
            this.targetDBSnapshotIdentifier = targetDBSnapshotIdentifier;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Boolean getCopyTags() {
            return this.copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        public final String getPreSignedUrl() {
            return this.preSignedUrl;
        }

        @Override
        public final Builder preSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
            return this;
        }

        public final void setPreSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CopyDBSnapshotRequest build() {
            return new CopyDBSnapshotRequest(this);
        }
    }

    public static interface Builder
    extends RDSRequest.Builder,
    CopyableBuilder<Builder, CopyDBSnapshotRequest> {
        public Builder sourceDBSnapshotIdentifier(String var1);

        public Builder targetDBSnapshotIdentifier(String var1);

        public Builder kmsKeyId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder copyTags(Boolean var1);

        public Builder preSignedUrl(String var1);

        public Builder optionGroupName(String var1);

        public Builder sourceRegion(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

